/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __UIFORM_H__
#define __UIFORM_H__

#include "ui_form.h"
#include "SigCSlot.h"

#pragma make_public(::bec::UIForm)
#pragma make_public(::bec::MenuItem)
#pragma make_public(::bec::ToolbarItem)

namespace MySQL {
  namespace Grt {

    public enum class MenuItemType
    {
      MenuAction=        ::bec::MenuAction,
      MenuSeparator=     ::bec::MenuSeparator,
      MenuCascade=       ::bec::MenuCascade,
      MenuCheck=         ::bec::MenuCheck,
      MenuRadio=         ::bec::MenuRadio,

      MenuUnavailable=   ::bec::MenuUnavailable
    };

    
    public ref class MenuItem
    {
      String^ caption;
      String^ shortcut;
      String^ name;
      MenuItemType type;

      bool enabled;
      bool checked;

      List<MySQL::Grt::MenuItem^>^ subitems;

    public:

      MenuItem(const ::bec::MenuItem& item)
        : caption(CppStringToNative(item.caption)),
        shortcut(CppStringToNative(item.shortcut)),
        name(CppStringToNative(item.name)),
        type((MenuItemType)item.type),
        enabled(item.enabled),
        checked(item.checked)
      {
        subitems= gcnew List<MySQL::Grt::MenuItem^>();
        for (bec::MenuItemList::const_iterator iter= item.subitems.begin(); iter != item.subitems.end(); ++iter)
          subitems->Add(gcnew MySQL::Grt::MenuItem(*iter));
      }

      String^ get_caption()
      { return caption; }

      String^ get_shortcut()
      { return shortcut; }

      String^ get_name()
      { return name; }

      MenuItemType get_type()
      { return type; }

      bool get_checked()
      { return checked; }

      bool get_enabled()
      { return enabled; }

      List<MySQL::Grt::MenuItem^>^ get_subitems()
      { return subitems; }
    };


    public enum class ToolbarItemType 
    {
      ToolbarAction=        ::bec::ToolbarAction,
      ToolbarSeparator=     ::bec::ToolbarSeparator,
      ToolbarToggle=        ::bec::ToolbarToggle,
      ToolbarLabel=         ::bec::ToolbarLabel,
      ToolbarDropDown=      ::bec::ToolbarDropDown,
      ToolbarRadio=         ::bec::ToolbarRadio,
      ToolbarCheck=         ::bec::ToolbarCheck,
      ToolbarSearch=        ::bec::ToolbarSearch
    };

    public ref class ToolbarItem
    {
      int icon;
      int alt_icon;
      String^ name;
      String^ caption;
      String^ command;
      String^ tooltip;
      ToolbarItemType type;

      bool enabled;
      bool checked;

    public:

      ToolbarItem(const ::bec::ToolbarItem& item)
        : icon(item.icon), alt_icon(item.alt_icon),
        name(CppStringToNative(item.name)),
        caption(CppStringToNative(item.caption)),
        command(CppStringToNative(item.command)),
        tooltip(CppStringToNative(item.tooltip)),
        type((ToolbarItemType)item.type),
        enabled(item.enabled),
        checked(item.checked)
      {}

      int get_icon()
      { return icon; }

      int get_alt_icon()
      { return alt_icon; }

      String^ get_name()
      { return name; }

      String^ get_caption()
      { return caption; }

      String^ get_command()
      { return command; }

      String^ get_tooltip()
      { return tooltip; }

      ToolbarItemType get_type()
      { return type; }

      bool get_checked()
      { return checked; }

      bool get_enabled()
      { return enabled; }
    };


    public ref class UIForm
    {
    protected:
      ::bec::UIForm *inner;
      GCHandle m_gch;

      UIForm(::bec::UIForm *inn)
      {
        init(inn);
      }

      UIForm()
        : inner(NULL)
      {
      }

      void init(::bec::UIForm *inn)
      {
        inner= inn;

        // get a fixed pointer to this object
        IntPtr ip = this->GetFixedId();

        // set it as the user data
        inner->set_frontend_data((void*)(intptr_t)ip);

        backend_destroyed_cb(gcnew BackendDestroyedDelegate::ManagedDelegate(this, &UIForm::on_backend_destroyed));
      }

      // Returns a fixed pointer to this object that will not be modified by the GC
      IntPtr GetFixedId()
      {
        if (!m_gch.IsAllocated)
           m_gch = GCHandle::Alloc( this );
         return GCHandle::ToIntPtr( m_gch );
      }

      // Needs to be called when destroying the object
      void ReleaseHandle()
      {
        m_gch.Free();
      }

    public:
      virtual ~UIForm()
      { 
        ReleaseHandle();
        delete inner; 
      }

      ::bec::UIForm *get_unmanaged_object()
      { return inner; }

        // Returns the object based on the fixed pointer retrieved by GetFixedId()
      static UIForm^ GetFromFixedId( IntPtr ip )
      {
        GCHandle gcHandle = GCHandle::FromIntPtr( ip );
        return (UIForm^)gcHandle.Target;
      }

      bool can_close()
      {
        return get_unmanaged_object()->can_close();
      } 

      bool close()
      {
        return get_unmanaged_object()->close();
      } 
    public:
      typedef DelegateSlot0<void, void> BackendDestroyedDelegate;
      void backend_destroyed_cb(BackendDestroyedDelegate::ManagedDelegate ^cb)
      {
        on_backend_destroyed_delegate= gcnew BackendDestroyedDelegate(cb);
        inner->slot_destroyed= on_backend_destroyed_delegate->get_slot();
      }
    protected:
      BackendDestroyedDelegate^ on_backend_destroyed_delegate;
      void on_backend_destroyed()
      {
        inner= NULL;
      }
    };

  } // namespace Grt
} // namespace MySQL

#endif // __UIFORM_H__