#ifndef __USER_ROLE_EDITOR_H__
#define __USER_ROLE_EDITOR_H__

#include "DBObjectEditorBE.h"
#include "RoleTreeBE.h"
#include "GrtTemplates.h"
#include "grtdb/editor_user_role.h"

#pragma make_public(::bec::RoleEditorBE)
#pragma make_public(::bec::RolePrivilegeListBE)
#pragma make_public(::bec::RoleObjectListBE)

namespace MySQL {
namespace Grt {
namespace Db {



public ref class RolePrivilegeListBE : public MySQL::Grt::ListModel
{
public:
  enum class Columns {
    Enabled = ::bec::RolePrivilegeListBE::Enabled,
    Name = ::bec::RolePrivilegeListBE::Name
  };

public:
  RolePrivilegeListBE(::bec::RolePrivilegeListBE *inn)
    : MySQL::Grt::ListModel(inn)
  {}

  ::bec::RolePrivilegeListBE *get_unmanaged_object()
  { return static_cast<::bec::RolePrivilegeListBE *>(inner); }
};


public ref class RoleObjectListBE : public MySQL::Grt::ListModel
{
public:
  enum class Columns {
    Name = ::bec::RoleObjectListBE::Name
  };

public:
  RoleObjectListBE(::bec::RoleObjectListBE *inn)
    : MySQL::Grt::ListModel(inn)
  {}

  ::bec::RoleObjectListBE *get_unmanaged_object()
  { return static_cast<::bec::RoleObjectListBE *>(inner); }

  void set_selected_node(NodeId ^node)
  {
    get_unmanaged_object()->set_selected_node(*node->get_unmanaged_object());
  }

};



public ref class RoleEditorBE : public BaseEditor
{

public:
    RoleEditorBE::RoleEditorBE(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ arglist)
    : BaseEditor(
        new bec::RoleEditorBE(grtm->get_unmanaged_object(), 
        db_RoleRef::cast_from(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0)),
        get_rdbms_for_db_object(grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
          )
      )
  {
  }

  ::bec::RoleEditorBE *get_unmanaged_object()
  { return static_cast<::bec::RoleEditorBE *>(inner); }

//XXXXX this is deprecated
  void set_role(MySQL::Grt::GrtValue^ role) 
  { /*get_unmanaged_object()->set_role(db_RoleRef::cast_from(role->get_unmanaged_object())); */ 

}

  String^ get_name()
  { return CppStringToNative(get_unmanaged_object()->get_name()); }

  void set_name(String ^name)
  { get_unmanaged_object()->set_name(NativeToCppString(name)); }

  void set_parent_role(String ^name)
  { get_unmanaged_object()->set_parent_role(NativeToCppString(name)); }

  String^ get_parent_role()
  { return CppStringToNative(get_unmanaged_object()->get_parent_role()); }

  RoleTreeBE^ get_role_tree()
  {
    return gcnew RoleTreeBE(get_unmanaged_object()->get_role_tree());
  }

  RolePrivilegeListBE^ get_privilege_list()
  {
    return gcnew RolePrivilegeListBE(get_unmanaged_object()->get_privilege_list());
  }

  RoleObjectListBE^ get_object_list()
  {
    return gcnew RoleObjectListBE(get_unmanaged_object()->get_object_list());
  }

  void add_object(GrtValue ^object)
  {
    get_unmanaged_object()->add_object(db_DatabaseObjectRef::cast_from(object->get_unmanaged_object()));
  }

  void remove_object(NodeId^ node)
  {
    get_unmanaged_object()->remove_object(*node->get_unmanaged_object());
  }
};


} // namespace Db
} // namespace Grt
} // namespace MySQL

#endif // __USER_ROLE_EDITOR_H__
