/*
// libmysql defines HAVE_STRTOUL (on win), so we have to follow different pattern in definitions names
// to avoid annoying warnings.


#define HAVE_INT8_T   1
#define HAVE_UINT8_T  1
#define HAVE_INT16_T  1
#define HAVE_UINT16_T 1
#define HAVE_INT32_T  1
#define HAVE_UINT32_T 1
#define HAVE_INT32_T  1
#define HAVE_UINT32_T 1
#define HAVE_INT64_T  1
#define HAVE_UINT64_T 1
*/

#if defined(_WIN32) || defined(_WIN64)
  //#define HAVE_STDINT_H 1
  //#define HAVE_INTTYPES_H 1

  #define HAVE_MS_INT8
  #define HAVE_MS_UINT8
  #define HAVE_MS_INT16
  #define HAVE_MS_UINT16
  #define HAVE_MS_INT32
  #define HAVE_MS_UINT32
  #define HAVE_MS_INT64
  #define HAVE_MS_UINT64
#elif defined __APPLE__
  #define HAVE_STDINT_H 1
  #define HAVE_INTTYPES_H 1
  
  #define HAVE_FUNCTION_STRTOLD 1
  #define HAVE_FUNCTION_STRTOLL 1
  #define HAVE_FUNCTION_STRTOL 1
  #define HAVE_FUNCTION_STRTOULL 1

  #define HAVE_FUNCTION_STRTOUL 1

  #define HAVE_FUNCTION_STRTOIMAX 1
  #define HAVE_FUNCTION_STRTOUMAX 1
#else
  #include "../../../config.h"

  // Defines for *nices
  #define HAVE_FUNCTION_STRTOLD HAVE_STRTOLD
  #define HAVE_FUNCTION_STRTOLL HAVE_STRTOLL
  #define HAVE_FUNCTION_STRTOL HAVE_STRTOL
  #define HAVE_FUNCTION_STRTOULL HAVE_STRTOULL
  
  #define HAVE_FUNCTION_STRTOUL HAVE_STRTOUL
  
  #define HAVE_FUNCTION_STRTOIMAX HAVE_STRTOIMAX
  #define HAVE_FUNCTION_STRTOUMAX HAVE_STRTOUMAX
#endif


#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#if defined(_WIN32) || defined(_WIN64)
#ifndef CPPCONN_DONT_TYPEDEF_MS_TYPES_TO_C99_TYPES

#ifdef HAVE_MS_INT8
typedef __int8			int8_t;
#endif

#ifdef HAVE_MS_UINT8
typedef unsigned __int8	uint8_t;
#endif
#ifdef HAVE_MS_INT16
typedef __int16			int16_t;
#endif

#ifdef HAVE_MS_UINT16
typedef unsigned __int16	uint16_t;
#endif

#ifdef HAVE_MS_INT32
typedef __int32			int32_t;
#endif

#ifdef HAVE_MS_UINT32
typedef unsigned __int32	uint32_t;
#endif

#ifdef HAVE_MS_INT64
typedef __int64			int64_t;
#endif
#ifdef HAVE_MS_UINT64
typedef unsigned __int64	uint64_t;
#endif

#endif  // CPPCONN_DONT_TYPEDEF_MS_TYPES_TO_C99_TYPES
#endif	//	_WIN32
