/* 
 * (c) 2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GRT_SHELL_WINDOW_H__
#define __GRT_SHELL_WINDOW_H__

#include <mforms/mforms.h>
#include "grt/grt_manager.h"
#include "mforms/grttreeview.h"

class GRTShellWindow : public mforms::Form
{
public:
  GRTShellWindow(bec::GRTManager *grtm);
  
  virtual void show(bool flag=true);
  void refresh_all();
protected:
  bec::GRTManager *_grtm;
  
  mforms::Splitter _hsplitter;
  mforms::TabView _side_tab;
  mforms::TabView _main_tab;

  mforms::Box _global_box1;
  mforms::Box _global_box2;
  mforms::Splitter _global_splitter;
  mforms::Selector _global_combo;
  mforms::GRTTreeView _global_tree;
  mforms::TextEntry _global_entry;
  mforms::GRTTreeView _global_list;
  bec::ValueInspectorBE *_inspector;
  bec::ValueTreeBE *_global_tree_be;

  mforms::Box _classes_box;
  mforms::Splitter _classes_splitter;
  mforms::Selector _classes_sorting;
  mforms::GRTTreeView _classes_tree;
  mforms::TextBox _classes_text;

  mforms::Splitter _modules_splitter;
  mforms::GRTTreeView _modules_tree;
  mforms::TextBox _modules_text;
  
  mforms::Box _shell_box;
  mforms::TextBox _shell_text;
  mforms::Box _shell_hbox;
  mforms::Label _shell_prompt;
  mforms::TextEntry _shell_entry;
  
  bool _first_show;
  
  void shell_action(mforms::TextEntryAction action);

  void handle_prompt(const std::string &text);
  void handle_output(const std::string &text);
  void handle_error(const std::string &text, const std::string &detail);
  void set_globals_tree_path(const std::string &path);
  
  void global_selected();
  void class_selected();
  void module_selected();
  void change_class_sorting();
  void change_global_path();
};

#endif
