/* 
 * Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "output_view.h"

OutputView::OutputView(bec::MessageListStorage *storage)
  : mforms::AppView(true, "output", false), _splitter(true), _message_list(true),
  _output_text(mforms::VerticalScrollBar)
{
  add(&_splitter, true, true);

  _splitter.add(&_message_list);
  _splitter.add(&_output_text);
  
  _message_list.add_column(mforms::IconStringGRTColumnType, 0, "");
  _message_list.set_column_width(0, 20);
  _message_list.add_column(mforms::StringGRTColumnType, 1, "Message");
  _message_list.set_column_width(1, 500);
  
  storage->set_output_handler(sigc::bind(sigc::mem_fun(_output_text, &mforms::TextBox::append_text), true));
  
  _storage = storage;
  _messages = storage->create_list();
  _message_list.set_model(_messages);
  
  _messages->signal_row_added().connect(sigc::mem_fun(this, &OutputView::row_added));
  
  _output_text.set_read_only(true);
  
  set_on_close(sigc::mem_fun(this, &OutputView::will_close));
}


OutputView::~OutputView()
{
  _message_list.set_model(0);
  delete _messages;
}


void OutputView::row_added()
{
  _message_list.row_count_changed(_messages->count()-1);
}


bool OutputView::will_close()
{
  return true;
}


