/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef _PREFERENCES_FORM_H_
#define _PREFERENCES_FORM_H_

#include <mforms/mforms.h>
#include <mforms/fs_object_selector.h>

#include "workbench/wb_context_ui.h"
#include "workbench/wb_backend_public_interface.h"

class MYSQLWBBACKEND_PUBLIC_FUNC PreferencesForm : public mforms::Form 
{
public:
  struct Option
  {
    mforms::View *view;
    sigc::slot<void> show_value;
    sigc::slot<void> update_value;
  };
  
private:
  std::list<Option*> _options;

  mforms::Box _top_box;
  mforms::Box _bottom_box;
  mforms::TabView _tabview;

  mforms::Box _button_box;
  mforms::Button _ok_button;
  mforms::Button _cancel_button;
  
  mforms::CheckBox _use_global;

  mforms::TreeView _font_list;
  std::vector<std::string> _font_options;

  std::string _model_id; // "" unless we're showing model specific options
  wb::WBContextUI *_wbui;

  sigc::slot<std::string,std::string,std::string> _edit_font;
  sigc::slot<void> _handle_close;
  
  mforms::Label *new_label(const std::string &text, bool right_align= false, bool help=false);

  mforms::TextEntry *new_entry_option(const std::string &option, bool numeric);
  mforms::FsObjectSelector *new_path_option(const std::string &option, bool file);  
  mforms::TextEntry *new_numeric_entry_option(const std::string &option, int minrange, int maxrange);
  mforms::CheckBox *new_checkbox_option(const std::string &option);
  mforms::Selector *new_selector_option(const std::string &option);

  void ok_clicked();
  void cancel_clicked();
  void test_clicked();
  
  void show_values();
  void update_values();

  void show_colors_and_fonts();
  void update_colors_and_fonts();
  
  void create_admin_page();
  void create_sqlide_page();
  void create_general_page();
  void create_model_page();
  void create_mysql_page();
  void create_diagram_page();
  void create_appearance_page();
#if defined(_DEBUG) || defined(ENABLE_DEBUG)
  void create_test_page();
#endif

  grt::DictRef get_options(bool global= false);
  
  void toggle_use_global();

  void show_path_option(const std::string &option_name, mforms::FsObjectSelector *entry);
  void update_path_option(const std::string &option_name, mforms::FsObjectSelector *entry);

  void show_entry_option(const std::string &option_name, mforms::TextEntry *entry, bool numeric);
  void update_entry_option(const std::string &option_name, mforms::TextEntry *entry, bool numeric);
  void update_entry_option_numeric(const std::string &option_name, mforms::TextEntry *entry, int minrange, int maxrange);
  
  void show_checkbox_option(const std::string &option_name, mforms::CheckBox *checkbox);
  void update_checkbox_option(const std::string &option_name, mforms::CheckBox *checkbox);
  void show_selector_option(const std::string &option_name, mforms::Selector *selector,
                            const std::vector<std::string> &choices);
  void update_selector_option(const std::string &option_name, mforms::Selector *selector,
                              const std::vector<std::string> &choices, const std::string &default_value);

public:
  PreferencesForm(wb::WBContextUI *wbui, const std::string &model_id= "");
  virtual ~PreferencesForm();
  
  // returned font, title, current font
  void set_font_panel_function(const sigc::slot<std::string,std::string,std::string> &edit_font);

  void set_closed_handler(const sigc::slot<void> &slot);
  
  void show();
};


#endif /* _PREFERENCES_FORM_H_ */
