#ifndef _FORM_VIEW_BASE_H_
#define _FORM_VIEW_BASE_H_

#include <gtkmm/notebook.h>
#include <gtkmm/widget.h>
#include "ui_form.h"

class PluginEditorBase;

class FormViewBase
{
protected:
  sigc::signal<void,std::string> _title_changed;
  Gtk::Notebook *_editor_note;
  
public:
  sigc::signal<void,std::string> signal_title_changed() { return _title_changed; }

  virtual std::string get_title()= 0;
  virtual Gtk::Widget *get_panel()= 0;

  virtual bec::UIForm *get_form() const= 0;
  
  virtual bool will_close() { return true; }

  virtual void toggle_sidebar() {}
  
  virtual void reset_layout() {}
  // close the selected tab and return true or false if no tab is active
  virtual bool close_focused_tab();

private:
  bool close_plugin_tab(PluginEditorBase *editor);
  
protected:
  sigc::slot<void, PluginEditorBase*> _close_editor;

public:
  void set_close_editor_callback(const sigc::slot<void, PluginEditorBase*> &handler);

  void add_plugin_tab(PluginEditorBase *plugin);
  void remove_plugin_tab(PluginEditorBase *plugin);
  bool close_editors_for_object(const std::string &id);

  PluginEditorBase *get_focused_plugin_tab();
};

#endif

