//!
//! \addtogroup linuxui Linux UI
//! @{
//! 

#ifndef _TOOLBAR_MANAGER_H_
#define _TOOLBAR_MANAGER_H_

#include <string>

namespace Gtk
{
  class Toolbar;
  class ToolButton;
  class Entry;
  class Button;
  class ComboBoxText;
  class ComboBox;
  class ToggleButton;
}

namespace wb
{
  class CommandUI;
}

namespace bec
{
  class ToolbarItem;
}

//==============================================================================
//
//==============================================================================
class ToolbarManager
{
  public:
    typedef sigc::slot<bool, const std::string&> CallbackSlot;
    typedef sigc::slot<Gtk::Widget*, bec::ToolbarItem> CustomItemSlot;

    ToolbarManager(wb::CommandUI *be);

    std::string get_search_text() const { return _search_text; }
    void rebuild_toolbar(Gtk::Box *toolbar, const std::string& toolbar_name);
    static void rebuild_toolbar(Gtk::Box *toolbar, const std::vector<bec::ToolbarItem> items,
                                const CustomItemSlot &create_item,
                                const CallbackSlot &cb);
  private:
    void add_toolbar_item(Gtk::Box* toolbar, const bec::ToolbarItem& item, bool right);
    void clicked(Gtk::Button *btn);
    static void clicked_to_slot(Gtk::Button *btn);
    void toggled(const Gtk::ToggleButton *btn, const std::string &name, const std::string &option);
    void combo_changed(const std::string &toolbar, Gtk::ComboBoxText *combo);
    void color_combo_changed(const std::string &toolbar, Gtk::ComboBox *combo);
  
    bool on_searchitem_key_release_event(GdkEventKey* event, Gtk::Entry* entry);

    Gtk::Box            *_toolbar;
    wb::CommandUI       *_be;
    sigc::connection     _search_conn;
    std::string          _search_text;
};

#endif /* _TOOLBAR_MANAGER_H_ */

//!                                                                                                                                     
//! @}                                                                                                                                  
//!
