#ifndef __SQL_EDITOR_FE_H__
#define __SQL_EDITOR_FE_H__

#include "sqlide/sql_editor_be.h"
#include <gtkmm.h>

#include "Scintilla.h"
#include "SciLexer.h"
#define PLAT_GTK 2
#include "ScintillaWidget.h"

class SqlEditorFE : public sigc::trackable
{
  public:
    SqlEditorFE();
    Gtk::Widget& widget();

  public:
    Sql_editor::Ref be() { return _be; }
    void be(Sql_editor::Ref be);
    void check_sql(bool sync= false);
    void background_action_cb(sigc::slot<void> slot) { _background_action_cb= slot; }
  
    bool is_dirty() { return _dirty; }
    void set_dirty(bool flag);
  private:
    bool on_background_action_timer();

    Sql_editor::Ref _be;
    sigc::slot<void> _background_action_cb;
    sigc::connection _background_action_timer_conn;

  public:
    std::string current_sql_statement();

  public:
    void set_text(const std::string& text);
    std::string get_text();
    std::string get_selected_text();
    void set_selected_range();
    void set_savepoint();
    bool get_modify();
    void scroll_to(const int line, const std::string& msg);
    void set_focus();

    sigc::signal<void>& signal_text_changed() {return _text_changed_signal;}

    int reset_sql_check_state();
    int process_sql_statement_border(int begin_lineno, int begin_line_pos, int end_lineno, int end_line_pos);
    int process_sql_error(const int err_tok_line, const int err_tok_line_pos, const int err_tok_len, const std::string &err_msg);

    bool sql_got_errors() const { return _errors_count != 0; }

    void insert_text(const std::string &text);
  private:
    void init_lexer();

    void notify(SCNotification *notification);
    bool margin_click(int position, int modifiers);
    void fold_changed(int line, int levelNow, int levelPrev);
    void expand(int &line, bool doExpand, bool force=false, int visLevels=0, int level=-1);
    void fold_code(bool expanding);
    void fold_open_all();
    void fold_close_all();

    Gtk::Widget         *_widget; // Gtkmm wrapped _editor
    GtkWidget           *_editor;
    ScintillaObject     *_sci;

    sptr_t send_editor(unsigned int msg, uptr_t uparam = 0, sptr_t sparam = 0);
    sigc::signal<void>  _text_changed_signal;

    static void notify_signal(GtkWidget *w, gint wParam, gpointer lParam, SqlEditorFE *editor);
    int _errors_count;
  
    bool _dirty;
};

#endif
