//!
//! \addtogroup linuxui Linux UI
//! @{
//! 

#include <gtkmm/box.h>
#include "widgets_auto_cleaner.h"

namespace Gtk
{
class Entry;
}

class AutoCompletable;
class ListModelWrapper;
class MGGladeXML;

namespace wb
{
  class WBContextUI;
  class FindDialogBE;
};


class FindPanel : public Gtk::VBox, protected WidgetsAutoCleaner
{
  wb::WBContextUI *_wbui;
  MGGladeXML *_ui;
  wb::FindDialogBE *_be;

  void init(wb::WBContextUI *wbui, MGGladeXML *ui);

  void find_next();
  void find_previous();

  void setup_arguments();
  
  void key_press(GdkEventKey *ev, Gtk::Entry *entry);

  void handle_close();
  
  
public:
  FindPanel(GtkVBox *box);
  virtual ~FindPanel();

  virtual void show();
  
  static FindPanel *create(wb::WBContextUI *wbui);
  
};

//!                                                                                                                                     
//! @}                                                                                                                                  
//!
