//!
//! \addtogroup linuxui Linux UI
//! @{
//! 

#ifndef __WORKBENCH_MENU_MANAGER_H__
#define __WORKBENCH_MENU_MANAGER_H__

#include "ui_form.h"
#include <set>
#include <glibmm.h>
#include <vector>

namespace Gtk
{
  class VBox;
  class Alignment;
  class Menu;
  class MenuItem;
  class MenuBar;
  class AccelGroup;
}

namespace wb
{
  class CommandUI;
}

namespace bec
{
  class NodeId;
  class MenuItem;
  class ListModel;
}

typedef const sigc::slot<void, const std::string&, const std::vector<bec::NodeId>&> FEMenuHandler;

//==============================================================================
//
//==============================================================================
class MenuManager
{
  public:
    MenuManager(wb::CommandUI *be, Glib::RefPtr<Gtk::AccelGroup> agroup)
    : _be(be), _accel_group(agroup), _menu_holder(0) {}
    
    ~MenuManager();

    static void run_and_forward_action(const bec::MenuItemList& items
                                      ,const int x
                                      ,const int y
                                      ,const int time
                                      ,bec::ListModel* model
                                      ,const std::vector<bec::NodeId> &nodes
                                      ,FEMenuHandler fe_menu_handler = FEMenuHandler());

    void rebuild(Gtk::Alignment *menu_holder);
  private:
    bool process_menuitem(const bec::MenuItem &cur_item, Gtk::MenuItem* cur_menu_item, Gtk::Menu* menu);
    void add_menu_item(const bec::MenuItem& cur_item, Gtk::Menu* menu, Gtk::MenuItem* empty_item);
    
    wb::CommandUI     *_be;
    Glib::RefPtr<Gtk::AccelGroup> _accel_group;
    Gtk::Alignment    *_menu_holder; // MenuBar holder
    
    void item_activated(const Gtk::MenuItem* item);
};

#endif

//!                                                                                                                                     
//! @}
//!
