#include "sql_snippets_view.h"
#include <gtkmm/box.h>
#include "linux_utilities/MGGladeXML.h"
#include "linux_utilities/toolbar_manager.h"
#include "linux_utilities/gtk_helpers.h"

SqlSnippetsView::SqlSnippetsView(wb::WBContextUI *wbui, MGGladeXML *ui_xml)
:
_wbui(wbui)
{
  set_policy(Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
  add(_tree);
  set_shadow_type(Gtk::SHADOW_IN);
  _tree.set_headers_visible(true);
  _tree.get_selection()->set_mode(Gtk::SELECTION_SINGLE);

  show_all();
 
  _sql_snippets_model= DbSqlEditorSnippets::get_instance();
  
  _ui_model= ListModelWrapper::create(_sql_snippets_model, &_tree, "SqlSnippetsView");
  _ui_model->model().append_string_column(0, " ", RO, NO_ICON);
  _ui_model->model().append_string_column(1, "Description", RO, NO_ICON);

  _tree.set_model(_ui_model);
  _ui_model->set_fe_menu_handler(sigc::mem_fun(this, &SqlSnippetsView::handle_context_menu_item));
  
  _tree.signal_row_activated().connect(sigc::mem_fun(this, &SqlSnippetsView::activate_row));
  _tree.get_selection()->signal_changed().connect(sigc::mem_fun(this, &SqlSnippetsView::selected_snippet));

  Gtk::Box *snippets_box;
  ui_xml->get("snippets_hbox", &snippets_box);
  snippets_box->pack_start(_editor.widget(), true, true);

  
  Gtk::Box *category_box;
  ui_xml->get("category_toolbar", &category_box);
  category_box->pack_start(_category_combo, false, true);
  _category_combo.show();
  _category_combo.signal_changed().connect(sigc::mem_fun(this, &SqlSnippetsView::change_category));
  
  _last_count= 0;

  Gtk::HBox *sql_snippets_toolbar = ui_xml->get("sql_snippets_toolbar", &sql_snippets_toolbar);
  ToolbarManager::rebuild_toolbar(sql_snippets_toolbar,
                                  _sql_snippets_model->get_toolbar_items(),
                                  sigc::slot<Gtk::Widget*,bec::ToolbarItem>(),
                                  sigc::mem_fun(this, &SqlSnippetsView::toolbar_action)
                                 );

  fill_combo_from_string_list(&_category_combo, _sql_snippets_model->get_category_list());
  if (_sql_snippets_model->selected_category().empty())
    _category_combo.set_active(0);
  else
    _category_combo.set_active_text(_sql_snippets_model->selected_category());

  refresh();
}

//------------------------------------------------------------------------------
bool SqlSnippetsView::toolbar_action(const std::string& name)
{
  _sql_snippets_model->activate_toolbar_item(bec::NodeId(0), name);
  return true;
}

//------------------------------------------------------------------------------
void SqlSnippetsView::change_category()
{
  _sql_snippets_model->select_category(_category_combo.get_active_text());
  refresh();
}

//------------------------------------------------------------------------------
void SqlSnippetsView::refresh()
{
  _ui_model->set_be_model(0);

  _tree.unset_model();
  _tree.set_model(_ui_model);

  _ui_model->set_be_model(_sql_snippets_model);
  
  _tree.unset_model();
  //!_sql_snippets_model->refresh();
  _tree.set_model(_ui_model);
}


void SqlSnippetsView::selected_snippet()
{
  std::string text;
  if (_tree.get_selection()->get_selected())
  {
    int row = _ui_model->get_path(_tree.get_selection()->get_selected()).front();
    _sql_snippets_model->get_field(row, 2, text);
    _editor.set_text(text);
  }
  else
    _editor.set_text("");
}

void SqlSnippetsView::activate_row(const Gtk::TreeModel::Path &path, Gtk::TreeViewColumn *column)
{
  _sql_snippets_model->activate_node(_ui_model->get_node_for_path(path));
}


void SqlSnippetsView::handle_context_menu_item(const std::string& name, const std::vector<bec::NodeId>& nodes)
{
  if (name == "refresh")
    refresh();//!
}
