
/*!
 Copyright 2009 Sun Microsystems, Inc.
 
 @author
 jak
 
 @class
 WBToolbarTabItem
 
 @abstract
 Implements custom tabs. Tabs at the top of the window, pointing downwards, looking like they are part of the window frame.
 
 @ingroup
 Custom Tab Views
 */



#import "WBToolbarTabItem.h"
#import "CGColorUtilities.h"



@implementation WBToolbarTabItem



- (CGFloat) preferredWidth;
{
  CGFloat preferredWidth = 0;
  
  NSFont* font = [NSFont boldSystemFontOfSize: 11.5];
  NSDictionary* attributes = [NSDictionary dictionaryWithObject: font
                                                         forKey: NSFontAttributeName];
  CGFloat labelWidth = ceil([mLabel sizeWithAttributes:attributes].width);
  preferredWidth = 35 + [mDocumentIconImage size].width + labelWidth + [mCloseButtonImage size].width;
  
//  if (preferredWidth < 150)
//    preferredWidth = 150;
  
  return preferredWidth;
//	return 150;
}



- (id) initWithIdentifier: (id) identifier
                    label: (NSString*) label
                direction: (WBTabDirection) tabDirection
                placement: (WBTabPlacement) tabPlacement
                     size: (WBTabSize) tabSize
                  hasIcon: (BOOL) hasIcon
                 canClose: (BOOL) canClose;
{
	self = [super initWithIdentifier: identifier
                             label: label
                         direction: tabDirection
                         placement: tabPlacement
                              size: tabSize
                           hasIcon: hasIcon
                          canClose: canClose];
	
	if (self != nil) {
		CGColorRef colorActiveSelected = WB_CGColorCreateCalibratedRGB(0.5882, 0.5882, 0.5882, 1);
		CGColorRef colorActiveNotSelected = WB_CGColorCreateCalibratedRGB(0.5, 0.5, 0.5, 1);
		CGColorRef colorNotActiveSelected = WB_CGColorCreateCalibratedRGB(0.8118, 0.8118, 0.8118, 1);
		CGColorRef colorNotActiveNotSelected = WB_CGColorCreateCalibratedRGB(0.8, 0.8, 0.8, 1);
    
    SInt32 MacVersion;
    if (Gestalt(gestaltSystemVersion, &MacVersion) == noErr) {
      // Snow Leopard, Security Update 1, all following
      if (MacVersion == 0x1060 || MacVersion == 0x1061 || 
            (MacVersion >= 0x1062 && MacVersion < 0x1070)) {
        colorActiveSelected = WB_CGColorCreateCalibratedRGB(0.65, 0.65, 0.65, 1);
        colorNotActiveSelected = WB_CGColorCreateCalibratedRGB(0.85, 0.85, 0.85, 1);
      }
    }
    
		[self setColorActiveSelected: colorActiveSelected
          colorActiveNotSelected: colorActiveNotSelected
          colorNotActiveSelected: colorNotActiveSelected
		   colorNotActiveNotSelected: colorNotActiveNotSelected];
		CGColorRelease(colorActiveSelected);
		CGColorRelease(colorActiveNotSelected);
		CGColorRelease(colorNotActiveSelected);
		CGColorRelease(colorNotActiveNotSelected);
    
    // Border.
		[self setCornerRadius: 6];
		[self setBorderWidth: 1];
		CGColorRef c = WB_CGColorCreateCalibratedRGB(0.3, 0.3, 0.3, 0.7);
		[self setBorderColor: c];
		CGColorRelease(c);
  }
	
	return self;
}



+ (WBTabItem*) tabItemWithIdentifier: (id) identifier
															 label: (NSString*) label;
{
	return [[[self alloc] initWithIdentifier: identifier
																		 label: label
																 direction: WBTabDirectionDown
																 placement: WBTabPlacementTop
																			size: WBTabSizeLarge
																	 hasIcon: YES
																	canClose: YES] autorelease];
}

@end


