/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import "WBPluginEditorBase.h"

@implementation WBPluginEditorBase

- (id)identifier
{
  return nil;
}


- (NSString*)title
{
  return nil;
}


- (NSImage*)titleIcon
{
  return nil;
}


- (NSView*)dockableView
{
  return nil;
}


- (void)reinitWithArguments:(const grt::BaseListRef&)args
{
}


- (void)updateTitle:(NSString*)title
{
  id superview = [[self dockableView] superview];
  if ([superview isKindOfClass: [NSTabView class]])
  {
    NSTabView *tabView= (NSTabView*)superview;
    NSInteger index = [tabView indexOfTabViewItemWithIdentifier: [self identifier]];
    if (index != NSNotFound)
    {
      id item= [tabView tabViewItemAtIndex: index];
      [item setLabel: title];
    }
  }
}


- (void)setMinimumSize:(NSSize)size
{
  mMinumumSize= size;
}


- (void)refresh
{
}


- (NSSize)minimumSize
{
  return mMinumumSize;
}


- (BOOL)matchesIdentifierForClosingEditor:(NSString*)identifier
{
  return NO;
}


- (void)applyLiveChanges
{
}

- (BOOL)pluginWillClose: (id)sender
{
  // by default, we check if the firstResponder belongs to this plugin and make it
  // resign so that edits are commited
  id first= [[[self dockableView] window] firstResponder];
  id dockableView= [self dockableView];
  NSWindow *window= [[self dockableView] window];
  
  while (first && first != dockableView && first != window)
    first= [first superview];

  if (first != window)
    [first resignFirstResponder];
  
  return YES;
}

//--------------------------------------------------------------------------------------------------

/**
 * Helper method to simplify setup of code editors.
 *
 * TODO: make color and font settings customizable.
 */
+ (void) setupCodeEditor: (ScintillaView*) editor backend: (Sql_editor::Ref) backend withStatus: (BOOL) withStatus
{
  // Lexer type is MySQL.
  [editor setGeneralProperty: SCI_SETLEXER parameter: SCLEX_MYSQL value: 0];
  // alternatively: [editor setStringProperty: SCI_SETLEXERLANGUAGE parameter: nil value: @"mysql"];
  
  // Number of styles we use with this lexer.
  [editor setGeneralProperty: SCI_SETSTYLEBITS parameter: 5 value: 0];
  
  // Keywords to highlight. Indices are:
  // 0 - Major keywords (reserved keywords)
  // 1 - Normal keywords (everything not reserved but integral part of the language)
  // 2 - Database objects
  // 3 - Function keywords
  // 4 - System variable keywords
  // 5 - Procedure keywords (keywords used in procedures like "begin" and "end")
  // 6..8 - User keywords 1..3
  [editor setReferenceProperty: SCI_SETKEYWORDS
                     parameter: 0
                         value: backend->get_keywords(Sql_editor::General_Keywords)];
  [editor setReferenceProperty: SCI_SETKEYWORDS
                     parameter: 3
                         value: backend->get_function_names()];
  [editor setReferenceProperty: SCI_SETKEYWORDS
                     parameter: 5
                         value: backend->get_keywords(Sql_editor::Procedure_Keywords)];
  [editor setReferenceProperty: SCI_SETKEYWORDS
                     parameter: 6
                         value: backend->get_keywords(Sql_editor::Client_Keywords)];
  [editor setReferenceProperty: SCI_SETKEYWORDS
                     parameter: 7
                         value: backend->get_keywords(Sql_editor::User_Keywords)];
  
  [editor setStringProperty: SCI_STYLESETFONT parameter: STYLE_DEFAULT value: @"Andale Mono"];
  // [editor setStringProperty: SCI_STYLESETFONT parameter: STYLE_DEFAULT value: @"Monospac821 BT"]; // Very pleasing programmer's font.
  [editor setGeneralProperty: SCI_STYLESETSIZE parameter: STYLE_DEFAULT value: 14];
  [editor setColorProperty: SCI_STYLESETFORE parameter: STYLE_DEFAULT value: [NSColor blackColor]];
  
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_DEFAULT value: [NSColor blackColor]];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_COMMENT fromHTML: @"#097BF7"];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_COMMENTLINE fromHTML: @"#097BF7"];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_HIDDENCOMMAND fromHTML: @"#097BF7"];
  [editor setColorProperty: SCI_STYLESETBACK parameter: SCE_MYSQL_HIDDENCOMMAND fromHTML: @"#F0F0F0"];
  
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_VARIABLE fromHTML: @"#378EA5"];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_SYSTEMVARIABLE fromHTML: @"#378EA5"];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_KNOWNSYSTEMVARIABLE fromHTML: @"#3A37A5"];
  
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_NUMBER fromHTML: @"#7F7F00"];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_SQSTRING fromHTML: @"#FFAA3E"];
  
  // Note: if we were using ANSI quotes we would set the DQSTRING to the same color as the 
  //       the back tick string.
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_DQSTRING fromHTML: @"#274A6D"];
  
  // Keyword highlighting.
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_MAJORKEYWORD fromHTML: @"#007F00"];
  [editor setGeneralProperty: SCI_STYLESETBOLD parameter: SCE_MYSQL_MAJORKEYWORD value: 1];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_KEYWORD fromHTML: @"#007F00"];
  [editor setGeneralProperty: SCI_STYLESETBOLD parameter: SCE_MYSQL_KEYWORD value: 1];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_PROCEDUREKEYWORD fromHTML: @"#56007F"];
  [editor setGeneralProperty: SCI_STYLESETBOLD parameter: SCE_MYSQL_PROCEDUREKEYWORD value: 1];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_USER1 fromHTML: @"#007F00"];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_USER2 fromHTML: @"#007F00"];
  //[editor setColorProperty: SCI_STYLESETBACK parameter: SCE_MYSQL_USER2 fromHTML: @"#E0E0E0"];
  
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_FUNCTION fromHTML: @"#903600"];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_DATABASEOBJECT value: [NSColor redColor]];
  
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_IDENTIFIER value: [NSColor blackColor]];
  [editor setColorProperty: SCI_STYLESETFORE parameter: SCE_MYSQL_QUOTEDIDENTIFIER fromHTML: @"#274A6D"];
  [editor setGeneralProperty: SCI_STYLESETBOLD parameter: SCE_SQL_OPERATOR value: 1];
  
  // Margin: Line number style.
  [editor setColorProperty: SCI_STYLESETFORE parameter: STYLE_LINENUMBER fromHTML: @"#404040"];
  [editor setColorProperty: SCI_STYLESETBACK parameter: STYLE_LINENUMBER fromHTML: @"#E0E0E0"];
  
  [editor setGeneralProperty: SCI_SETMARGINTYPEN parameter: 0 value: SC_MARGIN_NUMBER];
  int lineNumberStyleWidth = [editor getGeneralProperty: SCI_TEXTWIDTH parameter: STYLE_LINENUMBER extra: (int)"_99999"];
	[editor setGeneralProperty: SCI_SETMARGINWIDTHN parameter: 0 value: lineNumberStyleWidth];
  
  // Margin: Markers.
  [editor setGeneralProperty: SCI_SETMARGINWIDTHN parameter: 1 value: 16];
  
  // Some special lexer properties.
  [editor setLexerProperty: @"fold" value: @"1"];
  [editor setLexerProperty: @"fold.compact" value: @"0"];
  [editor setLexerProperty: @"fold.comment" value: @"1"];
  [editor setLexerProperty: @"fold.preprocessor" value: @"1"];
  
  // Folder setup.
  [editor setGeneralProperty: SCI_SETMARGINWIDTHN parameter: 2 value: 16];
  [editor setGeneralProperty: SCI_SETMARGINMASKN parameter: 2 value: SC_MASK_FOLDERS];
  [editor setGeneralProperty: SCI_SETMARGINSENSITIVEN parameter: 2 value: 1];
  [editor setGeneralProperty: SCI_MARKERDEFINE parameter: SC_MARKNUM_FOLDEROPEN value: SC_MARK_BOXMINUS];
  [editor setGeneralProperty: SCI_MARKERDEFINE parameter: SC_MARKNUM_FOLDER value: SC_MARK_BOXPLUS];
  [editor setGeneralProperty: SCI_MARKERDEFINE parameter: SC_MARKNUM_FOLDERSUB value: SC_MARK_VLINE];
  [editor setGeneralProperty: SCI_MARKERDEFINE parameter: SC_MARKNUM_FOLDERTAIL value: SC_MARK_LCORNER];
  [editor setGeneralProperty: SCI_MARKERDEFINE parameter: SC_MARKNUM_FOLDEREND value: SC_MARK_BOXPLUSCONNECTED];
  [editor setGeneralProperty: SCI_MARKERDEFINE parameter: SC_MARKNUM_FOLDEROPENMID value: SC_MARK_BOXMINUSCONNECTED];
  [editor setGeneralProperty: SCI_MARKERDEFINE parameter: SC_MARKNUM_FOLDERMIDTAIL value: SC_MARK_TCORNER];
  for (int n= 25; n < 32; ++n) // Markers 25..31 are reserved for folding.
  {
    [editor setColorProperty: SCI_MARKERSETFORE parameter: n value: [NSColor whiteColor]];
    [editor setColorProperty: SCI_MARKERSETBACK parameter: n fromHTML: @"#404040"];
  }
  
  // Init markers & indicators for highlighting of syntax errors.
  [editor setColorProperty: SCI_INDICSETFORE parameter: 0 fromHTML: @"#D01921"];
  [editor setGeneralProperty: SCI_INDICSETUNDER parameter: 0 value: 1];
  [editor setGeneralProperty: SCI_INDICSETSTYLE parameter: 0 value: INDIC_SQUIGGLE];
  
  // Gutter markers for errors and statments.
  NSBundle* bundle = [NSBundle bundleForClass: [self class]];
  NSString* path = [bundle pathForResource: @"editor_statement" ofType: @"xpm"];
  NSError* error = nil;
  NSString* xpm = [NSString stringWithContentsOfFile: path encoding: NSASCIIStringEncoding error: &error];
  if (error != nil)
    NSLog(@"%@ (editor_statement.xpm)", error);
  else
    [editor setStringProperty: SCI_MARKERDEFINEPIXMAP parameter: 0 value: xpm];
  [editor setColorProperty: SCI_MARKERSETBACK parameter: 0 fromHTML: @"#D01921"];
  
  path = [bundle pathForResource: @"editor_error" ofType: @"xpm"];
  error = nil;
  xpm = [NSString stringWithContentsOfFile: path encoding: NSASCIIStringEncoding error: &error];
  if (error != nil)
    NSLog(@"%@ (editor_error.xpm)", error);
  else
    [editor setStringProperty: SCI_MARKERDEFINEPIXMAP parameter: 1 value: xpm];
  [editor setColorProperty: SCI_MARKERSETBACK parameter: 1 fromHTML: @"#D01921"];

  // Other settings.
  // - Set up the normal selection background color.
  [editor setColorProperty: SCI_SETSELBACK parameter: 1 value: [NSColor selectedTextBackgroundColor]];
  
  // - Tabulators + indentation
  [editor setGeneralProperty: SCI_SETTABWIDTH parameter: 2 value: 0];
  [editor setGeneralProperty: SCI_SETUSETABS parameter: 0 value: 0];
  [editor setGeneralProperty: SCI_SETINDENT parameter: 2 value: 0];
  [editor setGeneralProperty: SCI_SETTABINDENTS parameter: 1 value: 0];
  
  InfoBar* infoBar = [[[InfoBar alloc] initWithFrame: NSMakeRect(0, 0, 400, 0)] autorelease];
  IBDisplay parts = IBDisplay(IBShowZoom | IBShowCaretPosition);
  if (withStatus)
    parts = IBShowAll;
  [infoBar setDisplay: parts];
  if (!withStatus)
    [infoBar sizeToFit];
  [editor setInfoBar: infoBar top: NO];
}

@end
