/* 
 * (c) 2009-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#import <Cocoa/Cocoa.h>

@class ScintillaView;

#include "sqlide/sql_editor_be.h"

@interface MSQLEditorController : NSObject 
{
  IBOutlet ScintillaView* mScintillaView;

  NSTimer* mSqlCheckTimer;
  
  int mErrorCount;
  Sql_editor::Ref* mBackEnd;
}

- (void)setEditorBackEnd:(const Sql_editor::Ref&)be;
- (Sql_editor::Ref)backEnd;

- (void)setView:(ScintillaView*)view;
- (ScintillaView*)view;

- (NSString*) currentSqlStatement; // SQL statement under current cursor position.
- (NSString*) string;              // Selected text only or entire editor contents (if no selection).
- (void)setString: (NSString*) string;
- (void)insertText: (NSString*) text;

@end
