//
//  WBQuerySidebarController.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 3/May/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MOutlineView.h"


namespace wb {
  class WBContextUI;
}

@class WBSQLQueryPanel;
@class GRTTreeDataSource;
@class GRTListDataSource;

@interface WBQuerySidebarController : NSObject 
{
  IBOutlet NSPopUpButton *schemaPop;
  
  IBOutlet MOutlineView *schemaOutline;
  IBOutlet GRTTreeDataSource *schemaDS;
    
  IBOutlet NSTextView *detailsText;
  
  IBOutlet NSSplitView *paletteSplitView;
  
  IBOutlet WBSQLQueryPanel *mQueryPanel;
  
  id delegate;
  sigc::connection mRefreshConn;
}

- (void)setup;

- (void)setDelegate:(id)delegate;

- (void)refresh;
- (void)refreshSchemaTree;
@end
