//
//  WBQuerySidebarController.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 3/May/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "sigobjc++.h"
#import "WBQuerySidebarController.h"
#import "MCPPUtilities.h"
#import "WBSQLQueryPanel.h"
#import "GRTTreeDataSource.h"
#import "MTextImageCell.h"
#import "GRTIconCache.h"

#include "sqlide/wb_sql_editor_form.h"


@implementation WBQuerySidebarController


static void refreshTreeNode(bec::NodeId node, WBQuerySidebarController *self)
{
  id item = [self->schemaDS itemForNodeId:node];
  [self->schemaOutline reloadItem: item reloadChildren:YES];
}


- (void)setup
{
  [[NSNotificationCenter defaultCenter] addObserver: self
                                           selector: @selector(outlineViewSelectionDidChange:)
                                               name: NSOutlineViewSelectionDidChangeNotification
                                             object: schemaOutline];
  
  [schemaOutline setTarget: self];
  [schemaOutline setDoubleAction: @selector(doubleClickRow:)];
  [schemaOutline setIndentationPerLevel: 10];

  [detailsText setFont: [NSFont fontWithName:@"Monaco" size:10]];

  [[detailsText textContainer] setContainerSize: NSMakeSize(1000000000, 1000000000)];
  [[detailsText textContainer] setWidthTracksTextView:NO];
  [[detailsText textContainer] setHeightTracksTextView:NO];
  
  [schemaDS setTreeModel: [mQueryPanel backEnd]->get_schema_tree()];
  
  mRefreshConn.disconnect();
  mRefreshConn = [mQueryPanel backEnd]->get_schema_tree()->refresh_node_ui.
  connect(sigc::bind(sigc::ptr_fun(refreshTreeNode), self));
  
  [self refresh];  
}


- (void)refreshSchemaTree
{
  [schemaOutline setNeedsDisplay:YES];
//  [schemaOutline reloadData];
}


- (void)dealloc
{
  mRefreshConn.disconnect();

  [[NSNotificationCenter defaultCenter] removeObserver: self];
  [super dealloc];
}


- (void)refresh
{
  std::list<std::string> schemata;
  if (mQueryPanel)
  {
    [mQueryPanel backEnd]->get_schemata(schemata);

    [schemaPop removeAllItems];
    for (std::list<std::string>::const_iterator iter= schemata.begin(); iter != schemata.end(); ++iter)
      [schemaPop addItemWithTitle: [NSString stringWithCPPString: *iter]];

    std::string schema= [mQueryPanel backEnd]->active_schema();
    [schemaPop selectItemWithTitle: [NSString stringWithCPPString: schema]];
    
    [schemaOutline reloadData];
    
    [self outlineViewSelectionDidChange:nil];
  }
}


- (void)setDelegate:(id)d
{
  delegate = d;
}


- (void)selectCollectionItem:(id)sender
{
  if (sender == schemaPop)
  {
    if (mQueryPanel)
    {
      NSString *item= [schemaPop titleOfSelectedItem];
      if (item)
      {
        [mQueryPanel backEnd]->active_schema([item UTF8String]);
        
        [delegate performSelector:@selector(activeSchemaChanged:) withObject:item];
        
        
        bec::NodeId node= [mQueryPanel backEnd]->get_schema_tree()->get_node_for_schema([item UTF8String]);        
        id treeItem= [schemaDS itemForNodeId: node];

        // expand all subnodes
        [schemaOutline expandItem:treeItem expandChildren:YES];

        // make the selected schema the 1st one in the visible area
        NSRect frame= [schemaOutline frameOfCellAtColumn:0 row: [schemaOutline rowForItem:treeItem]];

        [(NSClipView*)[schemaOutline superview] scrollToPoint: NSMakePoint(0, frame.origin.y)];
      }
    }
  }
}


- (void)doubleClickRow:(id)sender
{
  if ([schemaOutline clickedRow] >= 0)
  {
    bec::NodeId node= [[schemaOutline itemAtRow: [schemaOutline clickedRow]] nodeId];
  
    [mQueryPanel backEnd]->get_schema_tree()->activate_node(node);
  }
}

- (void)outlineViewSelectionDidChange:(NSNotification *)notification
{
  int row= [schemaOutline selectedRow];
  std::string details;
  if (row < 0)
    details= [mQueryPanel backEnd]->connection_info();
  else
    details= [mQueryPanel backEnd]->get_schema_tree()->get_field_description([[schemaOutline itemAtRow: row] nodeId], 0);
    
  [detailsText setString: [NSString stringWithCPPString: details]];
}

- (void)splitView:(NSSplitView *)sender resizeSubviewsWithOldSize: (NSSize)oldSize
{
  CGFloat dividerThickness = [sender dividerThickness];
  NSRect topRect = [[[sender subviews] objectAtIndex:0] frame];
  NSRect bottomRect = [[[sender subviews] objectAtIndex:1] frame];
  NSRect newFrame = [sender frame];
  
  topRect.size.width= newFrame.size.width;
  topRect.origin= NSMakePoint(0, 0);
  bottomRect.size.width= newFrame.size.width;
  bottomRect.size.height= newFrame.size.height - topRect.size.height
    - dividerThickness;
  bottomRect.origin.x= 0;
  bottomRect.origin.y= topRect.size.height + dividerThickness;
  
  
  [[[sender subviews] objectAtIndex:0] setFrame:topRect];
  [[[sender subviews] objectAtIndex:1] setFrame:bottomRect];
}

@end
