
/*!
 Copyright 2009 Sun Microsystems, Inc.
 */



#import <Cocoa/Cocoa.h>
#import "WBBasePanel.h"


#include "sqlide/wb_sql_editor_form.h"

@class ScintillaView;
@class MSQLEditorController;
@class MTogglePane;
@class MResultsetViewer;
@class WBQuerySidebarController;
@class MVerticalLayoutView;
@class WBSplitView;
@class WBSplitViewUnbrokenizerDelegate;
@class WBOverviewPanel;
@class WBMiniToolbar;
@class GRTListDataSource;

@interface WBSQLQueryPanel : WBBasePanel
{
  IBOutlet WBSplitView* mView;
  IBOutlet WBSplitView* mWorkView;
  IBOutlet WBSplitViewUnbrokenizerDelegate* mSplitterDelegate;
  
  IBOutlet NSTableView* mMessagesTable;
  IBOutlet NSTableView* mHistoryTable;
  IBOutlet NSTableView* mHistoryDetailsTable;

  IBOutlet NSTextView* mOutputActionText;
  IBOutlet NSTextView* mOutputResponseText;

  IBOutlet NSTabView* mUpperTabView;
  IBOutlet NSTabView* mLowerTabView;
  IBOutlet WBQuerySidebarController *mSidebar;
  IBOutlet NSView *mSidebarView;
  
  IBOutlet WBMiniToolbar* mOverviewToolbar;
  IBOutlet WBMiniToolbar* mSnippetsToolbar;
  
  IBOutlet NSTableView *snippetTable;
  IBOutlet GRTListDataSource *snippetDS;
  IBOutlet ScintillaView *mSnippetText;

  IBOutlet NSPopUpButton *mSchemaPop;
  
  NSTimeInterval mLastClick;
  
  BOOL mQueryAreaOpen;
  BOOL mResultsAreaOpen;
  
  WBOverviewPanel *mOverview;

  NSMutableArray *mEditors;
  
  NSMutableArray *mResultsetViews;
  
  Db_sql_editor::Ref *mBackEnd;
  
  BOOL sidebarHidden;
  BOOL sidebarAtRight;
  CGFloat lastSidebarWidth;
}


- (void)executeQuery:(id)sender currentStatementOnly: (bool) currentStatementOnly;
- (id)initWithBE:(const Db_sql_editor::Ref&)be;
- (Db_sql_editor::Ref)backEnd;
- (MResultsetViewer*)selectedResultset;
- (MSQLEditorController*)activeEditor;
- (void)addEditorTab;
- (void)addEditorTabWithBackEndIndex:(int)index;
- (void)setRightSidebar:(BOOL)flag;
@end


