//
//  GRTTreeOutline.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 29/Sep/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GRTListDataSource.h"



@protocol GRTDragDelegate
- (BOOL)dataSource:(id)source
        writeItems:(NSArray*)items
      toPasteboard:(NSPasteboard*)pboard;
@end


@interface GRTTreeDataSource : NSObject 
{
  bec::TreeModel *_tree;
  NSMutableDictionary *_nodeCache;
  BOOL _hideRootNode;
  id _dragDelegate;
}

- (id)initWithTreeModel:(bec::TreeModel*)model;

- (void)setTreeModel:(bec::TreeModel*)model;
- (void)setHidesRootNode:(BOOL)flag;

- (bec::TreeModel*)treeModel;
- (void)refreshModel;

- (bec::NodeId)nodeIdForItem:(id)item;
- (id)itemForNodeId:(const bec::NodeId&)nodeId;

- (void)setDragDelegate:(id<GRTDragDelegate>)delegate;

@end
