//
//  WBMFormsPluginPanel.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 1/Sep/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "WBMFormsPluginPanel.h"
#include <mforms/mforms.h>
#import "cocoa/MFView.h"

@implementation WBMFormsPluginPanel


+ (WBMFormsPluginPanel*)panelOfAppView:(mforms::AppView*)view
{
  return (WBMFormsPluginPanel*)view->get_frontend_data();
}


- (id)initWithAppView:(mforms::AppView*)view
{
  self = [super init];
  if (self)
  {
    _owner = view;
    view->retain();
    view->set_frontend_data(self);
  }
  return self;
}

- (void) dealloc
{
  _owner->set_frontend_data(0);
  _owner->release();
  
  [super dealloc];
}


- (NSView*)topView
{
  return nsviewForView(_owner);
}


- (void)setTitle:(NSString*)title
{
  [_title autorelease];
  _title = [title retain];
}


- (NSString*)title
{
  return _title;
}


- (NSString*)identifier
{
  return [NSString stringWithFormat: @"mformsview%p", _owner];
}


- (NSImage*)tabIcon
{
  return nil;
}


- (bec::UIForm*)formBE
{
  return _owner;
}


- (NSSize)minimumSize
{
  return NSMakeSize(1, 1);
}


- (BOOL)willClose
{
  return _owner->on_close();
}


- (void)didOpen
{
}


@end
