//
//  WBMainController.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 1/Oct/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#include <map>
#include <string>


namespace bec
{
  class UIForm;
};

namespace wb
{
  class WBContextUI;
  class WBContext;
  class WBOptions;
};

@class WBMainWindow;
@class WBBasePanel;

typedef WBBasePanel *(*FormPanelFactory)(WBMainWindow *mainwin, bec::UIForm *form);


@interface WBMainController : NSObject 
{
  wb::WBContextUI *_wbui;
  wb::WBContext *_wb;
  wb::WBOptions *_options;
  std::map<std::string, FormPanelFactory> *_formPanelFactories;
  
  NSMutableArray *_editorWindows;
  
  BOOL _initFinished;
  BOOL _quitting;

  IBOutlet WBMainWindow *mainWindow;
  IBOutlet NSWindow *aboutWindow;

  IBOutlet NSPanel *pageSetup;
  IBOutlet NSPopUpButton *paperSize;
  IBOutlet NSTextField *paperSizeLabel;
  IBOutlet NSButton *landscapeButton;
  IBOutlet NSButton *portraitButton;
  
  IBOutlet NSTextField *inputDialogMessage;
  IBOutlet NSTextField *inputDialogText;
  IBOutlet NSSecureTextField *inputDialogSecureText;
  IBOutlet NSPanel *inputDialog;
}

- (void)registerFormPanelFactory:(FormPanelFactory)fac forFormType:(const std::string&)type;

- (IBAction)showAbout:(id)sender;
- (IBAction)showDiagramProperties:(id)sender;
- (void)requestRefresh;

- (IBAction)buttonClicked:(id)sender;

- (IBAction)inputDialogClose:(id)sender;
- (void) showPageSetup: (id)sender;
@end
