//
//  WBPluginWindowController.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 11/Nov/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "WBPluginWindowController.h"


@implementation WBPluginWindowController

- (id)initWithPlugin:(WBPluginEditorBase*)plugin
{
  self = [super init];
  if (self)
  {
    mPluginEditor= [plugin retain];
    
    [NSBundle loadNibNamed:@"PluginEditorWindow" owner:self];

    float yextra;
    NSSize size = [mPluginEditor minimumSize];
    {
      NSSize wsize = [window contentRectForFrameRect: [window frame]].size;
      NSSize csize = [contentView frame].size;
      yextra = wsize.height - csize.height;
    }
    size.width += 100;
    size.height += 80;
    NSRect rect = NSZeroRect;
    rect.size = size;
    
    size.height += yextra;
    [window setContentSize: size];
    
    id view = [mPluginEditor dockableView];
    [contentView addSubview: view];
    [view setFrame: rect];
    
    [window setTitle: [mPluginEditor title]];
    
    [window makeKeyAndOrderFront: nil];
  }
  return self;
}

- (void)dealloc
{
  [mPluginEditor grtManager]->get_plugin_manager()->forget_gui_plugin_handle(self);
  
  [mPluginEditor release];
  [super dealloc];
}


- (void)windowWillClose:(NSNotification *)notification
{
  if ([mPluginEditor respondsToSelector:@selector(pluginWillClose:)])
    [mPluginEditor pluginWillClose:self];  
}


- (IBAction)buttonClicked:(id)sender
{
  switch ([sender tag])
  {
    case 10: // Close
      [window close];
      break;
      
    case 11: // Revert
      
      break;
      
    case 12: // Apply
      [mPluginEditor applyLiveChanges];
      break;
  }
}


@end
