//
//  WBToolbarManager.h
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 14/Oct/08.
//  Copyright 2008 Sun Microsystems Inc. All rights reserved.
//

#import "sigobjc++.h"
#import <Cocoa/Cocoa.h>
#include "workbench/wb_context_ui.h"

@class WBMiniToolbar;

@interface WBToolbarManager : NSObject 
{
  wb::WBContextUI *_wbui;
  NSToolbar *_toolbar;
  NSString *_lastSearchString;
  NSTextField *_searchField;
  
  NSMutableDictionary *_mainToolbarItems;
}

+ (WBToolbarManager*)defaultManager;

- (id)initWithToolbar:(NSToolbar*)toolbar
            WBContext:(wb::WBContextUI*)wbui;

- (void)refreshMainToolbar;
- (void)refreshToolsToolbar:(NSView*)toolsToolbar;
- (BOOL)refreshToolOptionsToolbar:(WBMiniToolbar*)toolbar;

- (void)focusSearchField:(id)sender;
- (NSString*)lastSearchString;


+ (void)setupToolbar:(NSView*)toolbar
           withItems:(const bec::ToolbarItemList&)items
              target:(id)target
              action:(SEL)selector;

@end
