using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Aga.Controls.Tree;

using MySQL.Grt;
using MySQL.Workbench;
using MySQL.Controls;

namespace MySQL.GUI.Workbench
{
  public partial class ModelLayerForm : TabDocument
  {
    private ModelDiagramForm model;
    private MySQL.Grt.TreeModel layerTreeBE;
    private SimpleGrtTreeModel layerTreeModel;
    private bool doubleClickedItem = false;

    private ModelLayerForm()
    {
      InitializeComponent();
    }

    public ModelLayerForm(ModelDiagramForm model)
      : this()
    {
      this.model = model;

      layerTreeBE = model.View.get_layer_tree();
      layerTreeModel = new SimpleGrtTreeModel(layerTreeView, layerTreeBE,
                  nodeStateIcon, false);
      layerTreeModel.AddColumn(nameNodeControl, 0, true);
      layerTreeModel.AddColumn(selectedNodeControl, 11, true);
      layerTreeModel.EnableRowColor(10);
      layerTreeView.Model = layerTreeModel;

      layerTreeBE.add_tree_refresh_handler(invokeRefresh);

      layerTreeView.Expanded+=new EventHandler<TreeViewAdvEventArgs>(layerTreeView_Expanded);
      layerTreeView.Collapsed+=new EventHandler<TreeViewAdvEventArgs>(layerTreeView_Collapsed);
    }

    public void UpdateLayerTree()
    {
      layerTreeView.BeginUpdate();

      layerTreeModel.RefreshModel();

      expandImportantNodes();

      layerTreeView.EndUpdate();
    }

    delegate void RefreshCallback();

    private void invokeRefresh(NodeId node, int oldCount)
    {
      if (InvokeRequired)
      {
        RefreshCallback f = delegate
        {
          UpdateLayerTree();
        };
        BeginInvoke(f);
      }
      else
        UpdateLayerTree();
    }

    private void expandImportantNodes()
    {
      layerTreeView.Root.Expand();
			foreach (TreeNodeAdv node in layerTreeView.Root.Children)
      {
        node.Expand();

        foreach (TreeNodeAdv node2 in node.Children)
          node2.Expand();
      }
    }


    void layerTreeView_Expanded(object sender, TreeViewAdvEventArgs e)
    {
      if (doubleClickedItem)
      {
        doubleClickedItem = false;
        e.Node.Collapse();
      }
    }

    void layerTreeView_Collapsed(object sender, TreeViewAdvEventArgs e)
    {
      if (doubleClickedItem)
      {
        doubleClickedItem = false;
        e.Node.Expand();
      }
    }

    private void layerTreeView_DoubleClick(object sender, EventArgs e)
    {
			if (layerTreeView.SelectedNode != null)
			{
				GrtTreeNode node = layerTreeView.SelectedNode.Tag as GrtTreeNode;
				if (node != null)
					layerTreeBE.activate_node(node.NodeId);
			}
		}

    public void updateContextMenu(List<NodeId> nodes)
    {
      layerMenuStrip.Items.Clear();

      List<MySQL.Grt.MenuItem> items = layerTreeModel.GrtTree.get_popup_items_for_nodes(nodes);
      foreach (MySQL.Grt.MenuItem grtMenuItem in items)
      {
        ToolStripMenuItem item = new ToolStripMenuItem(grtMenuItem.get_caption());
        item.Enabled = grtMenuItem.get_enabled();
        item.Tag = grtMenuItem.get_name();
        item.Click += new EventHandler(contextMenuClick);
        layerMenuStrip.Items.Add(item);
      }
    }

    private void layerMenuStrip_Opening(object sender, CancelEventArgs e)
    {
      List<NodeId> nodes = new List<NodeId>();
      foreach (TreeNodeAdv node in layerTreeView.SelectedNodes)
      {
        GrtTreeNode treeNode = node.Tag as GrtTreeNode;
        nodes.Add(treeNode.NodeId);
      }
      updateContextMenu(nodes);
    }

    void contextMenuClick(object sender, EventArgs e)
    {
      ToolStripMenuItem menuItem = sender as ToolStripMenuItem;

      List<NodeId> nodes = new List<NodeId>();
      GrtTreeNode treeNode = layerTreeView.SelectedNode.Tag as GrtTreeNode;
      nodes.Add(treeNode.NodeId);
      string command = menuItem.Tag as string;

      if (!layerTreeModel.GrtTree.activate_popup_item_for_nodes(command, nodes))
      {
        // The backend could not handle the menu command. See if we can make sense of it here.
        // Currently there is no command defined that could not be handled by the backend.
      }
    }
  }
}