using System;
using System.Windows.Forms;

using Aga.Controls.Tree;
using MySQL.Grt;
using MySQL.Workbench;
using MySQL.Controls;

namespace MySQL.GUI.Workbench
{
  public partial class UndoHistoryForm : TabDocument
  {
    private WbContext wbContext;
    private GrtManager grtManager;
    private MySQL.Grt.TreeModel historyTreeBE;
    private SimpleGrtListModel historyTreeModel;

    private UndoHistoryForm()
    {
      InitializeComponent();
    }

    public UndoHistoryForm(WbContext WbContext)
      : this()
    {
      wbContext = WbContext;
      grtManager = wbContext.get_grt_manager();

      historyTreeView.NodeControls.Remove(nodeStateIcon);
      historyTreeBE= wbContext.get_history_tree();
      historyTreeModel = new SimpleGrtListModel(historyTreeView, historyTreeBE, false);
      historyTreeModel.AddColumn(nameNodeControl, 0, false);
      historyTreeView.Model = historyTreeModel;

      historyTreeBE.add_tree_refresh_handler(invokeRefresh);
    }

    public void UpdateHistoryTree()
    {
      if (historyTreeModel != null)
      {
        historyTreeModel.RefreshModel();

        // Scroll to end
        if (historyTreeView.Root.Children.Count > 0)
          historyTreeView.ScrollTo(historyTreeView.Root.Children[historyTreeView.Root.Children.Count - 1]);
      }
    }

    delegate void RefreshCallback();

    private void invokeRefresh(NodeId node, int oldCount)
    {
      if (InvokeRequired)
      {
        RefreshCallback f = delegate
        {
          UpdateHistoryTree();
        };
        BeginInvoke(new RefreshCallback(UpdateHistoryTree));
      }
      else
        UpdateHistoryTree();
    }

    private void historyTreeView_DoubleClick(object sender, EventArgs e)
    {
      if (historyTreeView.SelectedNode != null)
      {
        GrtListNode node = historyTreeView.SelectedNode.Tag as GrtListNode;

        if (node != null)
        {
          historyTreeBE.activate_node(node.NodeId);
        }
      }
    }

    private void copyHistoryEntriesToClipboardToolStripMenuItem_Click(object sender, EventArgs e)
    {
      String messages = "";

      if (historyTreeView.SelectedNodes.Count > 0)
        foreach (TreeNodeAdv treeNode in historyTreeView.SelectedNodes)
          messages += historyTreeModel.GetRowAsText(treeNode) + Environment.NewLine;
      else
        foreach (TreeNodeAdv treeNode in historyTreeView.AllNodes)
          messages += historyTreeModel.GetRowAsText(treeNode) + Environment.NewLine;

      Clipboard.Clear();
      Clipboard.SetDataObject(messages, true);
    }
  }
}