using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using MySQL.Grt;
using MySQL.Workbench;
using MySQL.Utilities;
using MySQL.GUI.Workbench.Properties;


namespace MySQL.GUI.Workbench
{
  class WorkbenchMenuManager
  {
    #region Member Variables
    
    // The Workbench context
    private WbContext wbContext;

    #endregion

    #region Constructors

    public WorkbenchMenuManager(WbContext WbContext)
    {
      wbContext = WbContext;
    }

    #endregion

    public void RefreshMainEditMenu(System.Windows.Forms.MenuStrip menuStrip)
    {
      foreach (System.Windows.Forms.ToolStripMenuItem item in menuStrip.Items)
      {
        if (item.Name == "edit")
        {
          buildSubmenu(item, null, "edit", new EventHandler(menuItem_Click));
          break;
        }
      }
    }

    public void ConstructMainMenu(System.Windows.Forms.MenuStrip menuStrip)
    {
      List<MySQL.Grt.MenuItem> items = wbContext.get_main_menus();

      menuStrip.Items.Clear();

      foreach (MySQL.Grt.MenuItem item in items)
      {
        System.Windows.Forms.ToolStripMenuItem tsitem;

        tsitem = new System.Windows.Forms.ToolStripMenuItem();
        tsitem.Name = item.get_name();
        tsitem.Text = item.get_caption();

        if (item.get_name() == "edit")
          tsitem.DropDownOpening += new EventHandler(tsitem_DropDownOpening);
        buildSubmenu(tsitem, item, item.get_name(), new EventHandler(menuItem_Click));

        menuStrip.Items.Add(tsitem);
      }
    }

    void tsitem_DropDownOpening(object sender, EventArgs e)
    {
      System.Windows.Forms.ToolStripMenuItem tsitem = sender as ToolStripMenuItem;

      buildSubmenu(tsitem, null, tsitem.Name, new EventHandler(menuItem_Click));
    }

    public System.Windows.Forms.ContextMenuStrip PopUpContextMenu(System.Windows.Forms.Control parent, List<MySQL.Grt.MenuItem> items, int x, int y)
    {
      System.Windows.Forms.ContextMenuStrip menu = new System.Windows.Forms.ContextMenuStrip();
      System.Windows.Forms.ToolStripItem[] itemlist;

      itemlist = buildMenu(items, new EventHandler(menuItem_Click));
      menu.Items.AddRange(itemlist);

      menu.Show(parent, new System.Drawing.Point(x, y), ToolStripDropDownDirection.BelowRight);

      return menu;
    }

    public System.Windows.Forms.ContextMenuStrip PopUpObjectContextMenu(System.Windows.Forms.Control parent, List<MySQL.Grt.MenuItem> items, int x, int y,
       EventHandler handler)
    {
      System.Windows.Forms.ContextMenuStrip menu = new System.Windows.Forms.ContextMenuStrip();
      System.Windows.Forms.ToolStripItem[] itemlist;

      itemlist = buildMenu(items, handler);
      menu.Items.AddRange(itemlist);

      menu.Show(parent, new System.Drawing.Point(x, y), ToolStripDropDownDirection.BelowRight);

      return menu;
    }

    void buildSubmenu(System.Windows.Forms.ToolStripMenuItem tsitem, MySQL.Grt.MenuItem item, String name, EventHandler handler)
    {
      List<MySQL.Grt.MenuItem> menuItems = null;
      if (null != item)
        menuItems = item.get_subitems();
      if ((null == menuItems) || (0 == menuItems.Count))
        menuItems = wbContext.get_items_for_menu(name);
      System.Windows.Forms.ToolStripItem[] itemlist;

      itemlist = buildMenu(menuItems, handler);

      tsitem.DropDownItems.Clear();
      tsitem.DropDownItems.AddRange(itemlist);
    }

    System.Windows.Forms.ToolStripItem[] buildMenu(List<MySQL.Grt.MenuItem> menuItems, System.EventHandler handler)
    {
      System.Windows.Forms.ToolStripItem[] itemlist = new System.Windows.Forms.ToolStripItem[menuItems.Count];
      int i = 0;

      // rebuild the menu
      foreach (MySQL.Grt.MenuItem subitem in menuItems)
      {
        Keys shortcut = Keys.None;

        String skeys = subitem.get_shortcut();
        if (skeys != "")
        {
          foreach (String k in skeys.Split(new char[]{'+'}))
          {
            int x;

            // Convert the platform neutral keywords to such used on Windows.
            String shortcutString = k;
            if (k.Equals("Modifier"))
              shortcutString = "Control";
            if (k.Equals("Alternate"))
              shortcutString = "Alt";
            if (k.Length == 1 && int.TryParse(k, out x))
              shortcut |= (Keys)Enum.Parse(typeof(Keys), "D" + shortcutString);
            else
              shortcut |= (Keys)Enum.Parse(typeof(Keys), shortcutString, true);
          }
        }

        switch (subitem.get_type())
        {
          case MenuItemType.MenuAction:
          case MenuItemType.MenuUnavailable:
            {
              System.Windows.Forms.ToolStripMenuItem smitem;

              smitem = new System.Windows.Forms.ToolStripMenuItem();
              smitem.Name = subitem.get_name();
              smitem.Text = subitem.get_caption();
              smitem.ShortcutKeys = shortcut;
              smitem.Enabled = subitem.get_enabled();
              if (subitem.get_type() == MenuItemType.MenuUnavailable)
              {
                smitem.Image = Resources.menu_se;
                smitem.Enabled = false;
              }
              smitem.Click += handler;
              itemlist[i++] = smitem;
              break;
            }
            
          case MenuItemType.MenuCheck:
          case MenuItemType.MenuRadio:
            {
              System.Windows.Forms.ToolStripMenuItem smitem;

              smitem = new System.Windows.Forms.ToolStripMenuItem();
              smitem.Name = subitem.get_name();
              smitem.Text = subitem.get_caption();
              smitem.ShortcutKeys = shortcut;
              smitem.Enabled = subitem.get_enabled();
              smitem.Checked = subitem.get_checked();
              smitem.Click += handler;
              itemlist[i++] = smitem;
              break;
            }

          case MenuItemType.MenuSeparator:
            itemlist[i++] = new System.Windows.Forms.ToolStripSeparator();
            break;

          case MenuItemType.MenuCascade:
            {
              System.Windows.Forms.ToolStripMenuItem smitem;

              smitem = new System.Windows.Forms.ToolStripMenuItem();
              smitem.Name = subitem.get_name();
              smitem.Text = subitem.get_caption();
              smitem.ShortcutKeys = shortcut;
              smitem.Enabled = subitem.get_enabled();
              buildSubmenu(smitem, subitem, subitem.get_name(), handler);
              itemlist[i++] = smitem;
              break;
            }

          default:
            throw new Exception("bad item type");
        }
      }
      return itemlist;
    }


    void menuItem_Click(object sender, EventArgs e)
    {
      System.Windows.Forms.ToolStripMenuItem item = sender as System.Windows.Forms.ToolStripMenuItem;

      if (item != null)
      {
        wbContext.activate_command(item.Name);
      }
    }
  }
}
