using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using MySQL.Utilities;
using MySQL.GUI.Workbench.Properties;

namespace MySQL.GUI.Workbench
{
  public partial class WorkbenchSplashScreen : Form, ISplashScreen
  {
    protected bool closeOnClick = false;
    private const int CS_DROPSHADOW = 0x00020000;

    public WorkbenchSplashScreen()
    {
      InitializeComponent();
      
      versionLabel.Text = String.Format("{0} {1} Beta",
        Program.GetApplicationMetaInfo(Program.ApplicationMetaInfo.Version),
        Program.GetApplicationMetaInfo(Program.ApplicationMetaInfo.Configuration));
      revisionLabel.Text = String.Format("Revision {0}",
        Program.GetApplicationMetaInfo(Program.ApplicationMetaInfo.Revision));

#if EDITION_SE
      BackgroundImage = Resources.wb_splashscreen_se;
#elif EDITION_OSS
      BackgroundImage = Resources.wb_splashscreen_oss;
#else
#error Check your build configuration (must be x86)!
#endif
    }

    public WorkbenchSplashScreen(bool CloseOnClick) : this()
    {
      closeOnClick = CloseOnClick;
    }

    public void SetSplashScreenStatusInfo(string NewStatusInfo)
    {
      //
    }

    private void WorkbenchSplashScreen_Click(object sender, EventArgs e)
    {
      if (closeOnClick)
        Close();
    }

    private void WorkbenchSplashScreen_KeyPress(object sender, KeyPressEventArgs e)
    {
      if (e.KeyChar == 3)
      {
        // Ctrl+C pressed.
        Clipboard.SetText(
          String.Format("{0} ({1})", versionLabel.Text, revisionLabel.Text));
        e.Handled = true;
      }
    }

    protected override CreateParams CreateParams
    {
      get
      {
        CreateParams p = base.CreateParams;
        p.ClassStyle |= CS_DROPSHADOW;
        return p;
      }
    }
  }
}
