using System;
using System.Windows.Forms;

using MySQL.Grt;
using MySQL.Workbench;

namespace MySQL.GUI.Workbench.Plugins
{
  public partial class ObjectEditorView : DockablePlugin, IWorkbenchDocument
  {
    private ObjectEditorPlugin editorPlugin;
    public ObjectEditorPlugin EditorPlugin
    {
      get { return editorPlugin; }
    }
    protected void SetEditorPlugin(ObjectEditorPlugin value)
    {
      editorPlugin = value;
      Controls.Clear();

      if (null != editorPlugin)
      {
        // That's quite an ugly hack. Relocate all controls from one DockablePlugin to the other.
        while (editorPlugin.Controls.Count > 0)
          editorPlugin.Controls[0].Parent = this;
      }
    }

    public ObjectEditorView(ObjectEditorPlugin EditorPlugin)
      : base(EditorPlugin.GrtManager, EditorPlugin.GrtList)
    {
      InitializeComponent();

      EditorPlugin.ContainerForm = this;
      Text = EditorPlugin.Text;
      TabText = EditorPlugin.TabText;
      SetEditorPlugin(EditorPlugin);
    }

    protected override void OnFormClosing(FormClosingEventArgs e)
    {
      EditorPlugin.RunOnFormClosing(e);
      base.OnFormClosing(e);
    }

    protected override void OnFormClosed(FormClosedEventArgs e)
    {
      EditorPlugin.RunOnFormClosed(e);
      base.OnFormClosed(e);
    }

    #region IWorkbenchDocument implementation

    public WorkbenchDocumentClosing OnWorkbenchDocumentClosing
    {
      get { return editorPlugin.OnWorkbenchDocumentClosing; }
      set { editorPlugin.OnWorkbenchDocumentClosing = value; }
    }

    public override UIForm UIForm
    {
      get { return editorPlugin.UIForm; }
    }

    public void RefreshGUI(RefreshType refresh, String str, IntPtr ptr)
    {
    }

    public void PerformCommand(String command)
    {
    }

    public DockablePlugin FindPluginOfType(Type type)
    {
      if (EditorPlugin.GetType() == type)
        return this;
      return null;
    }

    public bool ClosePluginOfType(Type type)
    {
      if (EditorPlugin.GetType() == type)
      {
        Close();
        return true;
      }
      return false;
    }

    #endregion

    // Function that returns a pointer to the backend used
    public virtual UIForm BackendClass
    {
      get { return editorPlugin.BackendClass; }
    }

    public override IntPtr GetFixedPtr()
    {
      return editorPlugin.GetFixedPtr();
    }

    public override void ReleaseHandle()
    {
      editorPlugin.ReleaseHandle();
      base.ReleaseHandle();
    }

    public void Close(bool force)
    {
      Close();
    }
  }
}
