#ifndef __grts_structs_db_h__
#define __grts_structs_db_h__

#include <grtpp.h>

#ifdef _WIN32
  #pragma warning(disable: 4355) // 'this' : used in base member initizalizer list
  #ifdef GRT_STRUCTS_DB_EXPORT
  #define GRT_STRUCTS_DB_PUBLIC __declspec(dllexport)
#else
  #define GRT_STRUCTS_DB_PUBLIC __declspec(dllimport)
#endif
#else
  #define GRT_STRUCTS_DB_PUBLIC
#endif

#include <grts/structs.h>


class db_DatabaseSyncObject;
typedef grt::Ref<db_DatabaseSyncObject> db_DatabaseSyncObjectRef;
class db_DatabaseSync;
typedef grt::Ref<db_DatabaseSync> db_DatabaseSyncRef;
class db_Script;
typedef grt::Ref<db_Script> db_ScriptRef;
class db_CharacterSet;
typedef grt::Ref<db_CharacterSet> db_CharacterSetRef;
class db_ForeignKey;
typedef grt::Ref<db_ForeignKey> db_ForeignKeyRef;
class db_IndexColumn;
typedef grt::Ref<db_IndexColumn> db_IndexColumnRef;
class db_Index;
typedef grt::Ref<db_Index> db_IndexRef;
class db_CheckConstraint;
typedef grt::Ref<db_CheckConstraint> db_CheckConstraintRef;
class db_UserDatatype;
typedef grt::Ref<db_UserDatatype> db_UserDatatypeRef;
class db_SimpleDatatype;
typedef grt::Ref<db_SimpleDatatype> db_SimpleDatatypeRef;
class db_DatatypeGroup;
typedef grt::Ref<db_DatatypeGroup> db_DatatypeGroupRef;
class db_Column;
typedef grt::Ref<db_Column> db_ColumnRef;
class db_Tablespace;
typedef grt::Ref<db_Tablespace> db_TablespaceRef;
class db_LogFileGroup;
typedef grt::Ref<db_LogFileGroup> db_LogFileGroupRef;
class db_RolePrivilege;
typedef grt::Ref<db_RolePrivilege> db_RolePrivilegeRef;
class db_Catalog;
typedef grt::Ref<db_Catalog> db_CatalogRef;
class db_DatabaseObject;
typedef grt::Ref<db_DatabaseObject> db_DatabaseObjectRef;
class db_Sequence;
typedef grt::Ref<db_Sequence> db_SequenceRef;
class db_Synonym;
typedef grt::Ref<db_Synonym> db_SynonymRef;
class db_RoutineGroup;
typedef grt::Ref<db_RoutineGroup> db_RoutineGroupRef;
class db_StructuredDatatype;
typedef grt::Ref<db_StructuredDatatype> db_StructuredDatatypeRef;
class db_Table;
typedef grt::Ref<db_Table> db_TableRef;
class db_ServerLink;
typedef grt::Ref<db_ServerLink> db_ServerLinkRef;
class db_Schema;
typedef grt::Ref<db_Schema> db_SchemaRef;
class db_User;
typedef grt::Ref<db_User> db_UserRef;
class db_Role;
typedef grt::Ref<db_Role> db_RoleRef;
class db_DatabaseDdlObject;
typedef grt::Ref<db_DatabaseDdlObject> db_DatabaseDdlObjectRef;
class db_Trigger;
typedef grt::Ref<db_Trigger> db_TriggerRef;
class db_Routine;
typedef grt::Ref<db_Routine> db_RoutineRef;
class db_View;
typedef grt::Ref<db_View> db_ViewRef;


class  db_DatabaseSyncObject : public GrtObject
{
  typedef GrtObject super;
public:
  db_DatabaseSyncObject(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _alterDirection(0),
     _changed(0),
    _children(grt, this, false),
    _syncLog(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.DatabaseSyncObject"; }

  grt::IntegerRef alterDirection() const { return _alterDirection; }
  virtual void alterDirection(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_alterDirection);
   _alterDirection= value;
    member_changed("alterDirection", ovalue, value);
  }

  grt::IntegerRef changed() const { return _changed; }
  virtual void changed(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_changed);
   _changed= value;
    member_changed("changed", ovalue, value);
  }

  // children is owned by db_DatabaseSyncObject
  grt::ListRef<db_DatabaseSyncObject> children() const { return _children; }
private: // the next attribute is read-only
  virtual void children(const grt::ListRef<db_DatabaseSyncObject> &value)
  {
    grt::ValueRef ovalue(_children);

    _children= value;
    owned_member_changed("children", ovalue, value);
  }
public:

  GrtNamedObjectRef dbObject() const { return _dbObject; }
  virtual void dbObject(const GrtNamedObjectRef &value)
  {
    grt::ValueRef ovalue(_dbObject);
   _dbObject= value;
    member_changed("dbObject", ovalue, value);
  }

  GrtNamedObjectRef modelObject() const { return _modelObject; }
  virtual void modelObject(const GrtNamedObjectRef &value)
  {
    grt::ValueRef ovalue(_modelObject);
   _modelObject= value;
    member_changed("modelObject", ovalue, value);
  }

  // syncLog is owned by db_DatabaseSyncObject
  grt::ListRef<GrtLogObject> syncLog() const { return _syncLog; }
private: // the next attribute is read-only
  virtual void syncLog(const grt::ListRef<GrtLogObject> &value)
  {
    grt::ValueRef ovalue(_syncLog);

    _syncLog= value;
    owned_member_changed("syncLog", ovalue, value);
  }
public:

protected:

  grt::IntegerRef _alterDirection;
  grt::IntegerRef _changed;
  grt::ListRef<db_DatabaseSyncObject> _children;// owned
  GrtNamedObjectRef _dbObject;
  GrtNamedObjectRef _modelObject;
  grt::ListRef<GrtLogObject> _syncLog;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_DatabaseSyncObject(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_DatabaseSyncObject::create);
    {
      void (db_DatabaseSyncObject::*setter)(const grt::IntegerRef &)= &db_DatabaseSyncObject::alterDirection;
      grt::IntegerRef (db_DatabaseSyncObject::*getter)() const= &db_DatabaseSyncObject::alterDirection;
      meta->bind_member("alterDirection", new grt::MetaClass::Property<db_DatabaseSyncObject,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_DatabaseSyncObject::*setter)(const grt::IntegerRef &)= &db_DatabaseSyncObject::changed;
      grt::IntegerRef (db_DatabaseSyncObject::*getter)() const= &db_DatabaseSyncObject::changed;
      meta->bind_member("changed", new grt::MetaClass::Property<db_DatabaseSyncObject,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_DatabaseSyncObject::*setter)(const grt::ListRef<db_DatabaseSyncObject> &)= &db_DatabaseSyncObject::children;
      grt::ListRef<db_DatabaseSyncObject> (db_DatabaseSyncObject::*getter)() const= &db_DatabaseSyncObject::children;
      meta->bind_member("children", new grt::MetaClass::Property<db_DatabaseSyncObject,grt::ListRef<db_DatabaseSyncObject> >(getter,setter));
    }
    {
      void (db_DatabaseSyncObject::*setter)(const GrtNamedObjectRef &)= &db_DatabaseSyncObject::dbObject;
      GrtNamedObjectRef (db_DatabaseSyncObject::*getter)() const= &db_DatabaseSyncObject::dbObject;
      meta->bind_member("dbObject", new grt::MetaClass::Property<db_DatabaseSyncObject,GrtNamedObjectRef >(getter,setter));
    }
    {
      void (db_DatabaseSyncObject::*setter)(const GrtNamedObjectRef &)= &db_DatabaseSyncObject::modelObject;
      GrtNamedObjectRef (db_DatabaseSyncObject::*getter)() const= &db_DatabaseSyncObject::modelObject;
      meta->bind_member("modelObject", new grt::MetaClass::Property<db_DatabaseSyncObject,GrtNamedObjectRef >(getter,setter));
    }
    {
      void (db_DatabaseSyncObject::*setter)(const grt::ListRef<GrtLogObject> &)= &db_DatabaseSyncObject::syncLog;
      grt::ListRef<GrtLogObject> (db_DatabaseSyncObject::*getter)() const= &db_DatabaseSyncObject::syncLog;
      meta->bind_member("syncLog", new grt::MetaClass::Property<db_DatabaseSyncObject,grt::ListRef<GrtLogObject> >(getter,setter));
    }
  }
};


class  db_DatabaseSync : public GrtObject
{
  typedef GrtObject super;
public:
  db_DatabaseSync(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
  }

  static std::string static_class_name() { return "db.DatabaseSync"; }

  // changeTree is owned by db_DatabaseSync
  db_DatabaseSyncObjectRef changeTree() const { return _changeTree; }
  virtual void changeTree(const db_DatabaseSyncObjectRef &value)
  {
    grt::ValueRef ovalue(_changeTree);

    _changeTree= value;
    owned_member_changed("changeTree", ovalue, value);
  }

  // dbCatalog is owned by db_DatabaseSync
  db_CatalogRef dbCatalog() const { return _dbCatalog; }
  virtual void dbCatalog(const db_CatalogRef &value)
  {
    grt::ValueRef ovalue(_dbCatalog);

    _dbCatalog= value;
    owned_member_changed("dbCatalog", ovalue, value);
  }

protected:

  db_DatabaseSyncObjectRef _changeTree;// owned
  db_CatalogRef _dbCatalog;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_DatabaseSync(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_DatabaseSync::create);
    {
      void (db_DatabaseSync::*setter)(const db_DatabaseSyncObjectRef &)= &db_DatabaseSync::changeTree;
      db_DatabaseSyncObjectRef (db_DatabaseSync::*getter)() const= &db_DatabaseSync::changeTree;
      meta->bind_member("changeTree", new grt::MetaClass::Property<db_DatabaseSync,db_DatabaseSyncObjectRef >(getter,setter));
    }
    {
      void (db_DatabaseSync::*setter)(const db_CatalogRef &)= &db_DatabaseSync::dbCatalog;
      db_CatalogRef (db_DatabaseSync::*getter)() const= &db_DatabaseSync::dbCatalog;
      meta->bind_member("dbCatalog", new grt::MetaClass::Property<db_DatabaseSync,db_CatalogRef >(getter,setter));
    }
  }
};


class  db_Script : public GrtStoredNote
{
  typedef GrtStoredNote super;
public:
  db_Script(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtStoredNote(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
  }

  static std::string static_class_name() { return "db.Script"; }

protected:

private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Script(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Script::create);
  }
};


class  db_CharacterSet : public GrtObject
{
  typedef GrtObject super;
public:
  db_CharacterSet(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _collations(grt, this, false),
     _defaultCollation(""),
     _description("")

  {
  }

  static std::string static_class_name() { return "db.CharacterSet"; }

  grt::StringListRef collations() const { return _collations; }
private: // the next attribute is read-only
  virtual void collations(const grt::StringListRef &value)
  {
    grt::ValueRef ovalue(_collations);
   _collations= value;
    member_changed("collations", ovalue, value);
  }
public:

  grt::StringRef defaultCollation() const { return _defaultCollation; }
  virtual void defaultCollation(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_defaultCollation);
   _defaultCollation= value;
    member_changed("defaultCollation", ovalue, value);
  }

  grt::StringRef description() const { return _description; }
  virtual void description(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_description);
   _description= value;
    member_changed("description", ovalue, value);
  }

protected:

  grt::StringListRef _collations;
  grt::StringRef _defaultCollation;
  grt::StringRef _description;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_CharacterSet(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_CharacterSet::create);
    {
      void (db_CharacterSet::*setter)(const grt::StringListRef &)= &db_CharacterSet::collations;
      grt::StringListRef (db_CharacterSet::*getter)() const= &db_CharacterSet::collations;
      meta->bind_member("collations", new grt::MetaClass::Property<db_CharacterSet,grt::StringListRef >(getter,setter));
    }
    {
      void (db_CharacterSet::*setter)(const grt::StringRef &)= &db_CharacterSet::defaultCollation;
      grt::StringRef (db_CharacterSet::*getter)() const= &db_CharacterSet::defaultCollation;
      meta->bind_member("defaultCollation", new grt::MetaClass::Property<db_CharacterSet,grt::StringRef >(getter,setter));
    }
    {
      void (db_CharacterSet::*setter)(const grt::StringRef &)= &db_CharacterSet::description;
      grt::StringRef (db_CharacterSet::*getter)() const= &db_CharacterSet::description;
      meta->bind_member("description", new grt::MetaClass::Property<db_CharacterSet,grt::StringRef >(getter,setter));
    }
  }
};


class GRT_STRUCTS_DB_PUBLIC db_ForeignKey : public GrtNamedObject
{
  typedef GrtNamedObject super;
public:
  db_ForeignKey(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtNamedObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _columns(grt, this, false),
     _deferability(0),
     _deleteRule(""),
     _mandatory(1),
     _many(1),
     _modelOnly(0),
    _referencedColumns(grt, this, false),
     _referencedMandatory(1),
     _updateRule("")

  {
  }

  virtual ~db_ForeignKey();

  static std::string static_class_name() { return "db.ForeignKey"; }

  grt::ListRef<db_Column> columns() const { return _columns; }
private: // the next attribute is read-only
  virtual void columns(const grt::ListRef<db_Column> &value)
  {
    grt::ValueRef ovalue(_columns);
   _columns= value;
    member_changed("columns", ovalue, value);
  }
public:

  grt::IntegerRef deferability() const { return _deferability; }
  virtual void deferability(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_deferability);
   _deferability= value;
    member_changed("deferability", ovalue, value);
  }

  grt::StringRef deleteRule() const { return _deleteRule; }
  virtual void deleteRule(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_deleteRule);
   _deleteRule= value;
    member_changed("deleteRule", ovalue, value);
  }

  grt::IntegerRef mandatory() const { return _mandatory; }
  virtual void mandatory(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_mandatory);
   _mandatory= value;
    member_changed("mandatory", ovalue, value);
  }

  grt::IntegerRef many() const { return _many; }
  virtual void many(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_many);
   _many= value;
    member_changed("many", ovalue, value);
  }

  grt::IntegerRef modelOnly() const { return _modelOnly; }
  virtual void modelOnly(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_modelOnly);
   _modelOnly= value;
    member_changed("modelOnly", ovalue, value);
  }

  db_TableRef owner() const { return db_TableRef::cast_from(_owner); }
  virtual void owner(const db_TableRef &value);

  grt::ListRef<db_Column> referencedColumns() const { return _referencedColumns; }
private: // the next attribute is read-only
  virtual void referencedColumns(const grt::ListRef<db_Column> &value)
  {
    grt::ValueRef ovalue(_referencedColumns);
   _referencedColumns= value;
    member_changed("referencedColumns", ovalue, value);
  }
public:

  grt::IntegerRef referencedMandatory() const { return _referencedMandatory; }
  virtual void referencedMandatory(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_referencedMandatory);
   _referencedMandatory= value;
    member_changed("referencedMandatory", ovalue, value);
  }

  db_TableRef referencedTable() const { return _referencedTable; }
  virtual void referencedTable(const db_TableRef &value);

  grt::StringRef updateRule() const { return _updateRule; }
  virtual void updateRule(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_updateRule);
   _updateRule= value;
    member_changed("updateRule", ovalue, value);
  }

  virtual grt::IntegerRef checkCompleteness();
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:
  virtual void owned_list_item_added(grt::internal::OwnedList *list, const grt::ValueRef &value);
  virtual void owned_list_item_removed(grt::internal::OwnedList *list, const grt::ValueRef &value);

  grt::ListRef<db_Column> _columns;
  grt::IntegerRef _deferability;
  grt::StringRef _deleteRule;
  grt::IntegerRef _mandatory;
  grt::IntegerRef _many;
  grt::IntegerRef _modelOnly;
  grt::ListRef<db_Column> _referencedColumns;
  grt::IntegerRef _referencedMandatory;
  db_TableRef _referencedTable;
  grt::StringRef _updateRule;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_ForeignKey(grt));
  }

  static grt::ValueRef call_checkCompleteness(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_ForeignKey*>(self)->checkCompleteness(); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_ForeignKey::create);
    {
      void (db_ForeignKey::*setter)(const grt::ListRef<db_Column> &)= &db_ForeignKey::columns;
      grt::ListRef<db_Column> (db_ForeignKey::*getter)() const= &db_ForeignKey::columns;
      meta->bind_member("columns", new grt::MetaClass::Property<db_ForeignKey,grt::ListRef<db_Column> >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const grt::IntegerRef &)= &db_ForeignKey::deferability;
      grt::IntegerRef (db_ForeignKey::*getter)() const= &db_ForeignKey::deferability;
      meta->bind_member("deferability", new grt::MetaClass::Property<db_ForeignKey,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const grt::StringRef &)= &db_ForeignKey::deleteRule;
      grt::StringRef (db_ForeignKey::*getter)() const= &db_ForeignKey::deleteRule;
      meta->bind_member("deleteRule", new grt::MetaClass::Property<db_ForeignKey,grt::StringRef >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const grt::IntegerRef &)= &db_ForeignKey::mandatory;
      grt::IntegerRef (db_ForeignKey::*getter)() const= &db_ForeignKey::mandatory;
      meta->bind_member("mandatory", new grt::MetaClass::Property<db_ForeignKey,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const grt::IntegerRef &)= &db_ForeignKey::many;
      grt::IntegerRef (db_ForeignKey::*getter)() const= &db_ForeignKey::many;
      meta->bind_member("many", new grt::MetaClass::Property<db_ForeignKey,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const grt::IntegerRef &)= &db_ForeignKey::modelOnly;
      grt::IntegerRef (db_ForeignKey::*getter)() const= &db_ForeignKey::modelOnly;
      meta->bind_member("modelOnly", new grt::MetaClass::Property<db_ForeignKey,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const db_TableRef &)= &db_ForeignKey::owner;
      db_TableRef (db_ForeignKey::*getter)() const= 0;
      meta->bind_member("owner", new grt::MetaClass::Property<db_ForeignKey,db_TableRef >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const grt::ListRef<db_Column> &)= &db_ForeignKey::referencedColumns;
      grt::ListRef<db_Column> (db_ForeignKey::*getter)() const= &db_ForeignKey::referencedColumns;
      meta->bind_member("referencedColumns", new grt::MetaClass::Property<db_ForeignKey,grt::ListRef<db_Column> >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const grt::IntegerRef &)= &db_ForeignKey::referencedMandatory;
      grt::IntegerRef (db_ForeignKey::*getter)() const= &db_ForeignKey::referencedMandatory;
      meta->bind_member("referencedMandatory", new grt::MetaClass::Property<db_ForeignKey,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const db_TableRef &)= &db_ForeignKey::referencedTable;
      db_TableRef (db_ForeignKey::*getter)() const= &db_ForeignKey::referencedTable;
      meta->bind_member("referencedTable", new grt::MetaClass::Property<db_ForeignKey,db_TableRef >(getter,setter));
    }
    {
      void (db_ForeignKey::*setter)(const grt::StringRef &)= &db_ForeignKey::updateRule;
      grt::StringRef (db_ForeignKey::*getter)() const= &db_ForeignKey::updateRule;
      meta->bind_member("updateRule", new grt::MetaClass::Property<db_ForeignKey,grt::StringRef >(getter,setter));
    }
    meta->bind_method("checkCompleteness", &db_ForeignKey::call_checkCompleteness);
  }
};


class  db_IndexColumn : public GrtObject
{
  typedef GrtObject super;
public:
  db_IndexColumn(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _columnLength(0),
     _comment(""),
     _descend(0)

  {
  }

  static std::string static_class_name() { return "db.IndexColumn"; }

  grt::IntegerRef columnLength() const { return _columnLength; }
  virtual void columnLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_columnLength);
   _columnLength= value;
    member_changed("columnLength", ovalue, value);
  }

  grt::StringRef comment() const { return _comment; }
  virtual void comment(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_comment);
   _comment= value;
    member_changed("comment", ovalue, value);
  }

  grt::IntegerRef descend() const { return _descend; }
  virtual void descend(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_descend);
   _descend= value;
    member_changed("descend", ovalue, value);
  }

  db_ColumnRef referencedColumn() const { return _referencedColumn; }
  virtual void referencedColumn(const db_ColumnRef &value)
  {
    grt::ValueRef ovalue(_referencedColumn);
   _referencedColumn= value;
    member_changed("referencedColumn", ovalue, value);
  }

protected:

  grt::IntegerRef _columnLength;
  grt::StringRef _comment;
  grt::IntegerRef _descend;
  db_ColumnRef _referencedColumn;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_IndexColumn(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_IndexColumn::create);
    {
      void (db_IndexColumn::*setter)(const grt::IntegerRef &)= &db_IndexColumn::columnLength;
      grt::IntegerRef (db_IndexColumn::*getter)() const= &db_IndexColumn::columnLength;
      meta->bind_member("columnLength", new grt::MetaClass::Property<db_IndexColumn,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_IndexColumn::*setter)(const grt::StringRef &)= &db_IndexColumn::comment;
      grt::StringRef (db_IndexColumn::*getter)() const= &db_IndexColumn::comment;
      meta->bind_member("comment", new grt::MetaClass::Property<db_IndexColumn,grt::StringRef >(getter,setter));
    }
    {
      void (db_IndexColumn::*setter)(const grt::IntegerRef &)= &db_IndexColumn::descend;
      grt::IntegerRef (db_IndexColumn::*getter)() const= &db_IndexColumn::descend;
      meta->bind_member("descend", new grt::MetaClass::Property<db_IndexColumn,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_IndexColumn::*setter)(const db_ColumnRef &)= &db_IndexColumn::referencedColumn;
      db_ColumnRef (db_IndexColumn::*getter)() const= &db_IndexColumn::referencedColumn;
      meta->bind_member("referencedColumn", new grt::MetaClass::Property<db_IndexColumn,db_ColumnRef >(getter,setter));
    }
  }
};


class GRT_STRUCTS_DB_PUBLIC db_Index : public GrtNamedObject
{
  typedef GrtNamedObject super;
public:
  db_Index(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtNamedObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _columns(grt, this, false),
     _deferability(0),
     _indexType(""),
     _isPrimary(0),
     _unique(0)

  {
  }

  virtual ~db_Index();

  static std::string static_class_name() { return "db.Index"; }

  // columns is owned by db_Index
  grt::ListRef<db_IndexColumn> columns() const { return _columns; }
private: // the next attribute is read-only
  virtual void columns(const grt::ListRef<db_IndexColumn> &value)
  {
    grt::ValueRef ovalue(_columns);

    _columns= value;
    owned_member_changed("columns", ovalue, value);
  }
public:


  grt::IntegerRef deferability() const { return _deferability; }
  virtual void deferability(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_deferability);
   _deferability= value;
    member_changed("deferability", ovalue, value);
  }

  grt::StringRef indexType() const { return _indexType; }
  virtual void indexType(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_indexType);
   _indexType= value;
    member_changed("indexType", ovalue, value);
  }

  grt::IntegerRef isPrimary() const { return _isPrimary; }
  virtual void isPrimary(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isPrimary);
   _isPrimary= value;
    member_changed("isPrimary", ovalue, value);
  }

  grt::StringRef name() const { return super::name(); }
  virtual void name(const grt::StringRef &value);

  grt::IntegerRef unique() const { return _unique; }
  virtual void unique(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_unique);
   _unique= value;
    member_changed("unique", ovalue, value);
  }

  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:

  grt::ListRef<db_IndexColumn> _columns;// owned
  grt::IntegerRef _deferability;
  grt::StringRef _indexType;
  grt::IntegerRef _isPrimary;
  grt::IntegerRef _unique;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Index(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Index::create);
    {
      void (db_Index::*setter)(const grt::ListRef<db_IndexColumn> &)= &db_Index::columns;
      grt::ListRef<db_IndexColumn> (db_Index::*getter)() const= &db_Index::columns;
      meta->bind_member("columns", new grt::MetaClass::Property<db_Index,grt::ListRef<db_IndexColumn> >(getter,setter));
    }
    {
      void (db_Index::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_Index::*getter)() const= 0;
      meta->bind_member("comment", new grt::MetaClass::Property<db_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_Index::*setter)(const grt::IntegerRef &)= &db_Index::deferability;
      grt::IntegerRef (db_Index::*getter)() const= &db_Index::deferability;
      meta->bind_member("deferability", new grt::MetaClass::Property<db_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Index::*setter)(const grt::StringRef &)= &db_Index::indexType;
      grt::StringRef (db_Index::*getter)() const= &db_Index::indexType;
      meta->bind_member("indexType", new grt::MetaClass::Property<db_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_Index::*setter)(const grt::IntegerRef &)= &db_Index::isPrimary;
      grt::IntegerRef (db_Index::*getter)() const= &db_Index::isPrimary;
      meta->bind_member("isPrimary", new grt::MetaClass::Property<db_Index,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Index::*setter)(const grt::StringRef &)= &db_Index::name;
      grt::StringRef (db_Index::*getter)() const= 0;
      meta->bind_member("name", new grt::MetaClass::Property<db_Index,grt::StringRef >(getter,setter));
    }
    {
      void (db_Index::*setter)(const grt::IntegerRef &)= &db_Index::unique;
      grt::IntegerRef (db_Index::*getter)() const= &db_Index::unique;
      meta->bind_member("unique", new grt::MetaClass::Property<db_Index,grt::IntegerRef >(getter,setter));
    }
  }
};


class  db_CheckConstraint : public GrtNamedObject
{
  typedef GrtNamedObject super;
public:
  db_CheckConstraint(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtNamedObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _searchCondition("")

  {
  }

  static std::string static_class_name() { return "db.CheckConstraint"; }

  grt::StringRef searchCondition() const { return _searchCondition; }
  virtual void searchCondition(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_searchCondition);
   _searchCondition= value;
    member_changed("searchCondition", ovalue, value);
  }

protected:

  grt::StringRef _searchCondition;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_CheckConstraint(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_CheckConstraint::create);
    {
      void (db_CheckConstraint::*setter)(const grt::StringRef &)= &db_CheckConstraint::searchCondition;
      grt::StringRef (db_CheckConstraint::*getter)() const= &db_CheckConstraint::searchCondition;
      meta->bind_member("searchCondition", new grt::MetaClass::Property<db_CheckConstraint,grt::StringRef >(getter,setter));
    }
  }
};


class  db_UserDatatype : public GrtObject
{
  typedef GrtObject super;
public:
  db_UserDatatype(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _flags(""),
     _sqlDefinition("")

  {
  }

  static std::string static_class_name() { return "db.UserDatatype"; }

  db_SimpleDatatypeRef actualType() const { return _actualType; }
  virtual void actualType(const db_SimpleDatatypeRef &value)
  {
    grt::ValueRef ovalue(_actualType);
   _actualType= value;
    member_changed("actualType", ovalue, value);
  }

  grt::StringRef flags() const { return _flags; }
  virtual void flags(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_flags);
   _flags= value;
    member_changed("flags", ovalue, value);
  }

  grt::StringRef sqlDefinition() const { return _sqlDefinition; }
  virtual void sqlDefinition(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_sqlDefinition);
   _sqlDefinition= value;
    member_changed("sqlDefinition", ovalue, value);
  }

protected:

  db_SimpleDatatypeRef _actualType;
  grt::StringRef _flags;
  grt::StringRef _sqlDefinition;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_UserDatatype(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_UserDatatype::create);
    {
      void (db_UserDatatype::*setter)(const db_SimpleDatatypeRef &)= &db_UserDatatype::actualType;
      db_SimpleDatatypeRef (db_UserDatatype::*getter)() const= &db_UserDatatype::actualType;
      meta->bind_member("actualType", new grt::MetaClass::Property<db_UserDatatype,db_SimpleDatatypeRef >(getter,setter));
    }
    {
      void (db_UserDatatype::*setter)(const grt::StringRef &)= &db_UserDatatype::flags;
      grt::StringRef (db_UserDatatype::*getter)() const= &db_UserDatatype::flags;
      meta->bind_member("flags", new grt::MetaClass::Property<db_UserDatatype,grt::StringRef >(getter,setter));
    }
    {
      void (db_UserDatatype::*setter)(const grt::StringRef &)= &db_UserDatatype::sqlDefinition;
      grt::StringRef (db_UserDatatype::*getter)() const= &db_UserDatatype::sqlDefinition;
      meta->bind_member("sqlDefinition", new grt::MetaClass::Property<db_UserDatatype,grt::StringRef >(getter,setter));
    }
  }
};


class  db_SimpleDatatype : public GrtObject
{
  typedef GrtObject super;
public:
  db_SimpleDatatype(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _characterMaximumLength(0),
     _characterOctetLength(0),
     _dateTimePrecision(0),
    _flags(grt, this, false),
     _needsQuotes(0),
     _numericPrecision(0),
     _numericPrecisionRadix(0),
     _numericScale(0),
     _parameterFormatType(0)

  {
  }

  static std::string static_class_name() { return "db.SimpleDatatype"; }

  grt::IntegerRef characterMaximumLength() const { return _characterMaximumLength; }
  virtual void characterMaximumLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_characterMaximumLength);
   _characterMaximumLength= value;
    member_changed("characterMaximumLength", ovalue, value);
  }

  grt::IntegerRef characterOctetLength() const { return _characterOctetLength; }
  virtual void characterOctetLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_characterOctetLength);
   _characterOctetLength= value;
    member_changed("characterOctetLength", ovalue, value);
  }

  grt::IntegerRef dateTimePrecision() const { return _dateTimePrecision; }
  virtual void dateTimePrecision(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_dateTimePrecision);
   _dateTimePrecision= value;
    member_changed("dateTimePrecision", ovalue, value);
  }

  grt::StringListRef flags() const { return _flags; }
private: // the next attribute is read-only
  virtual void flags(const grt::StringListRef &value)
  {
    grt::ValueRef ovalue(_flags);
   _flags= value;
    member_changed("flags", ovalue, value);
  }
public:

  db_DatatypeGroupRef group() const { return _group; }
  virtual void group(const db_DatatypeGroupRef &value)
  {
    grt::ValueRef ovalue(_group);
   _group= value;
    member_changed("group", ovalue, value);
  }

  grt::IntegerRef needsQuotes() const { return _needsQuotes; }
  virtual void needsQuotes(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_needsQuotes);
   _needsQuotes= value;
    member_changed("needsQuotes", ovalue, value);
  }

  grt::IntegerRef numericPrecision() const { return _numericPrecision; }
  virtual void numericPrecision(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_numericPrecision);
   _numericPrecision= value;
    member_changed("numericPrecision", ovalue, value);
  }

  grt::IntegerRef numericPrecisionRadix() const { return _numericPrecisionRadix; }
  virtual void numericPrecisionRadix(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_numericPrecisionRadix);
   _numericPrecisionRadix= value;
    member_changed("numericPrecisionRadix", ovalue, value);
  }

  grt::IntegerRef numericScale() const { return _numericScale; }
  virtual void numericScale(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_numericScale);
   _numericScale= value;
    member_changed("numericScale", ovalue, value);
  }

  grt::IntegerRef parameterFormatType() const { return _parameterFormatType; }
  virtual void parameterFormatType(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_parameterFormatType);
   _parameterFormatType= value;
    member_changed("parameterFormatType", ovalue, value);
  }

protected:

  grt::IntegerRef _characterMaximumLength;
  grt::IntegerRef _characterOctetLength;
  grt::IntegerRef _dateTimePrecision;
  grt::StringListRef _flags;
  db_DatatypeGroupRef _group;
  grt::IntegerRef _needsQuotes;
  grt::IntegerRef _numericPrecision;
  grt::IntegerRef _numericPrecisionRadix;
  grt::IntegerRef _numericScale;
  grt::IntegerRef _parameterFormatType;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_SimpleDatatype(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_SimpleDatatype::create);
    {
      void (db_SimpleDatatype::*setter)(const grt::IntegerRef &)= &db_SimpleDatatype::characterMaximumLength;
      grt::IntegerRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::characterMaximumLength;
      meta->bind_member("characterMaximumLength", new grt::MetaClass::Property<db_SimpleDatatype,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const grt::IntegerRef &)= &db_SimpleDatatype::characterOctetLength;
      grt::IntegerRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::characterOctetLength;
      meta->bind_member("characterOctetLength", new grt::MetaClass::Property<db_SimpleDatatype,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const grt::IntegerRef &)= &db_SimpleDatatype::dateTimePrecision;
      grt::IntegerRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::dateTimePrecision;
      meta->bind_member("dateTimePrecision", new grt::MetaClass::Property<db_SimpleDatatype,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const grt::StringListRef &)= &db_SimpleDatatype::flags;
      grt::StringListRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::flags;
      meta->bind_member("flags", new grt::MetaClass::Property<db_SimpleDatatype,grt::StringListRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const db_DatatypeGroupRef &)= &db_SimpleDatatype::group;
      db_DatatypeGroupRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::group;
      meta->bind_member("group", new grt::MetaClass::Property<db_SimpleDatatype,db_DatatypeGroupRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const grt::IntegerRef &)= &db_SimpleDatatype::needsQuotes;
      grt::IntegerRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::needsQuotes;
      meta->bind_member("needsQuotes", new grt::MetaClass::Property<db_SimpleDatatype,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const grt::IntegerRef &)= &db_SimpleDatatype::numericPrecision;
      grt::IntegerRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::numericPrecision;
      meta->bind_member("numericPrecision", new grt::MetaClass::Property<db_SimpleDatatype,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const grt::IntegerRef &)= &db_SimpleDatatype::numericPrecisionRadix;
      grt::IntegerRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::numericPrecisionRadix;
      meta->bind_member("numericPrecisionRadix", new grt::MetaClass::Property<db_SimpleDatatype,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const grt::IntegerRef &)= &db_SimpleDatatype::numericScale;
      grt::IntegerRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::numericScale;
      meta->bind_member("numericScale", new grt::MetaClass::Property<db_SimpleDatatype,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_SimpleDatatype::*setter)(const grt::IntegerRef &)= &db_SimpleDatatype::parameterFormatType;
      grt::IntegerRef (db_SimpleDatatype::*getter)() const= &db_SimpleDatatype::parameterFormatType;
      meta->bind_member("parameterFormatType", new grt::MetaClass::Property<db_SimpleDatatype,grt::IntegerRef >(getter,setter));
    }
  }
};


class  db_DatatypeGroup : public GrtObject
{
  typedef GrtObject super;
public:
  db_DatatypeGroup(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _caption(""),
     _description("")

  {
  }

  static std::string static_class_name() { return "db.DatatypeGroup"; }

  grt::StringRef caption() const { return _caption; }
  virtual void caption(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_caption);
   _caption= value;
    member_changed("caption", ovalue, value);
  }

  grt::StringRef description() const { return _description; }
  virtual void description(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_description);
   _description= value;
    member_changed("description", ovalue, value);
  }

protected:

  grt::StringRef _caption;
  grt::StringRef _description;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_DatatypeGroup(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_DatatypeGroup::create);
    {
      void (db_DatatypeGroup::*setter)(const grt::StringRef &)= &db_DatatypeGroup::caption;
      grt::StringRef (db_DatatypeGroup::*getter)() const= &db_DatatypeGroup::caption;
      meta->bind_member("caption", new grt::MetaClass::Property<db_DatatypeGroup,grt::StringRef >(getter,setter));
    }
    {
      void (db_DatatypeGroup::*setter)(const grt::StringRef &)= &db_DatatypeGroup::description;
      grt::StringRef (db_DatatypeGroup::*getter)() const= &db_DatatypeGroup::description;
      meta->bind_member("description", new grt::MetaClass::Property<db_DatatypeGroup,grt::StringRef >(getter,setter));
    }
  }
};


class GRT_STRUCTS_DB_PUBLIC db_Column : public GrtNamedObject
{
  typedef GrtNamedObject super;
public:
  db_Column(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtNamedObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _characterSetName(""),
    _checks(grt, this, false),
     _collationName(""),
     _datatypeExplicitParams(""),
     _defaultValue(""),
     _defaultValueIsNull(0),
    _flags(grt, this, false),
     _isNotNull(0),
     _length(-1),
     _precision(-1),
     _scale(-1)

  {
  }

  virtual ~db_Column();

  static std::string static_class_name() { return "db.Column"; }

  grt::StringRef characterSetName() const { return _characterSetName; }
  virtual void characterSetName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_characterSetName);
   _characterSetName= value;
    member_changed("characterSetName", ovalue, value);
  }

  // checks is owned by db_Column
  grt::ListRef<db_CheckConstraint> checks() const { return _checks; }
private: // the next attribute is read-only
  virtual void checks(const grt::ListRef<db_CheckConstraint> &value)
  {
    grt::ValueRef ovalue(_checks);

    _checks= value;
    owned_member_changed("checks", ovalue, value);
  }
public:

  grt::StringRef collationName() const { return _collationName; }
  virtual void collationName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_collationName);
   _collationName= value;
    member_changed("collationName", ovalue, value);
  }

  grt::StringRef datatypeExplicitParams() const { return _datatypeExplicitParams; }
  virtual void datatypeExplicitParams(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_datatypeExplicitParams);
   _datatypeExplicitParams= value;
    member_changed("datatypeExplicitParams", ovalue, value);
  }

  grt::StringRef defaultValue() const { return _defaultValue; }
  virtual void defaultValue(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_defaultValue);
   _defaultValue= value;
    member_changed("defaultValue", ovalue, value);
  }

  grt::IntegerRef defaultValueIsNull() const { return _defaultValueIsNull; }
  virtual void defaultValueIsNull(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_defaultValueIsNull);
   _defaultValueIsNull= value;
    member_changed("defaultValueIsNull", ovalue, value);
  }

  grt::StringListRef flags() const { return _flags; }
private: // the next attribute is read-only
  virtual void flags(const grt::StringListRef &value)
  {
    grt::ValueRef ovalue(_flags);
   _flags= value;
    member_changed("flags", ovalue, value);
  }
public:

  grt::StringRef formattedRawType() const;
private: // the next attribute is read-only
public:

  grt::StringRef formattedType() const;
  virtual void formattedType(const grt::StringRef &value);

  grt::IntegerRef isNotNull() const { return _isNotNull; }
  virtual void isNotNull(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isNotNull);
   _isNotNull= value;
    member_changed("isNotNull", ovalue, value);
  }

  grt::IntegerRef length() const { return _length; }
  virtual void length(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_length);
   _length= value;
    member_changed("length", ovalue, value);
  }

  grt::StringRef name() const { return super::name(); }
  virtual void name(const grt::StringRef &value);

  grt::IntegerRef precision() const { return _precision; }
  virtual void precision(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_precision);
   _precision= value;
    member_changed("precision", ovalue, value);
  }

  grt::IntegerRef scale() const { return _scale; }
  virtual void scale(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_scale);
   _scale= value;
    member_changed("scale", ovalue, value);
  }

  db_SimpleDatatypeRef simpleType() const { return _simpleType; }
  virtual void simpleType(const db_SimpleDatatypeRef &value)
  {
    grt::ValueRef ovalue(_simpleType);
   _simpleType= value;
    member_changed("simpleType", ovalue, value);
  }

  db_StructuredDatatypeRef structuredType() const { return _structuredType; }
  virtual void structuredType(const db_StructuredDatatypeRef &value)
  {
    grt::ValueRef ovalue(_structuredType);
   _structuredType= value;
    member_changed("structuredType", ovalue, value);
  }

  db_UserDatatypeRef userType() const { return _userType; }
  virtual void userType(const db_UserDatatypeRef &value)
  {
    grt::ValueRef ovalue(_userType);
   _userType= value;
    member_changed("userType", ovalue, value);
  }

  virtual grt::IntegerRef setParseType(const std::string &type, const grt::ListRef<db_SimpleDatatype> &typeList);
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:

  grt::StringRef _characterSetName;
  grt::ListRef<db_CheckConstraint> _checks;// owned
  grt::StringRef _collationName;
  grt::StringRef _datatypeExplicitParams;
  grt::StringRef _defaultValue;
  grt::IntegerRef _defaultValueIsNull;
  grt::StringListRef _flags;
  grt::IntegerRef _isNotNull;
  grt::IntegerRef _length;
  grt::IntegerRef _precision;
  grt::IntegerRef _scale;
  db_SimpleDatatypeRef _simpleType;
  db_StructuredDatatypeRef _structuredType;
  db_UserDatatypeRef _userType;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Column(grt));
  }

  static grt::ValueRef call_setParseType(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Column*>(self)->setParseType(grt::StringRef::cast_from(args[0]), grt::ListRef<db_SimpleDatatype>::cast_from(args[1])); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Column::create);
    {
      void (db_Column::*setter)(const grt::StringRef &)= &db_Column::characterSetName;
      grt::StringRef (db_Column::*getter)() const= &db_Column::characterSetName;
      meta->bind_member("characterSetName", new grt::MetaClass::Property<db_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::ListRef<db_CheckConstraint> &)= &db_Column::checks;
      grt::ListRef<db_CheckConstraint> (db_Column::*getter)() const= &db_Column::checks;
      meta->bind_member("checks", new grt::MetaClass::Property<db_Column,grt::ListRef<db_CheckConstraint> >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::StringRef &)= &db_Column::collationName;
      grt::StringRef (db_Column::*getter)() const= &db_Column::collationName;
      meta->bind_member("collationName", new grt::MetaClass::Property<db_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::StringRef &)= &db_Column::datatypeExplicitParams;
      grt::StringRef (db_Column::*getter)() const= &db_Column::datatypeExplicitParams;
      meta->bind_member("datatypeExplicitParams", new grt::MetaClass::Property<db_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::StringRef &)= &db_Column::defaultValue;
      grt::StringRef (db_Column::*getter)() const= &db_Column::defaultValue;
      meta->bind_member("defaultValue", new grt::MetaClass::Property<db_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::IntegerRef &)= &db_Column::defaultValueIsNull;
      grt::IntegerRef (db_Column::*getter)() const= &db_Column::defaultValueIsNull;
      meta->bind_member("defaultValueIsNull", new grt::MetaClass::Property<db_Column,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::StringListRef &)= &db_Column::flags;
      grt::StringListRef (db_Column::*getter)() const= &db_Column::flags;
      meta->bind_member("flags", new grt::MetaClass::Property<db_Column,grt::StringListRef >(getter,setter));
    }
    meta->bind_member("formattedRawType", new grt::MetaClass::Property<db_Column,grt::StringRef >(&db_Column::formattedRawType));
    meta->bind_member("formattedType", new grt::MetaClass::Property<db_Column,grt::StringRef >(&db_Column::formattedType));
    {
      void (db_Column::*setter)(const grt::IntegerRef &)= &db_Column::isNotNull;
      grt::IntegerRef (db_Column::*getter)() const= &db_Column::isNotNull;
      meta->bind_member("isNotNull", new grt::MetaClass::Property<db_Column,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::IntegerRef &)= &db_Column::length;
      grt::IntegerRef (db_Column::*getter)() const= &db_Column::length;
      meta->bind_member("length", new grt::MetaClass::Property<db_Column,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::StringRef &)= &db_Column::name;
      grt::StringRef (db_Column::*getter)() const= 0;
      meta->bind_member("name", new grt::MetaClass::Property<db_Column,grt::StringRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::IntegerRef &)= &db_Column::precision;
      grt::IntegerRef (db_Column::*getter)() const= &db_Column::precision;
      meta->bind_member("precision", new grt::MetaClass::Property<db_Column,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const grt::IntegerRef &)= &db_Column::scale;
      grt::IntegerRef (db_Column::*getter)() const= &db_Column::scale;
      meta->bind_member("scale", new grt::MetaClass::Property<db_Column,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const db_SimpleDatatypeRef &)= &db_Column::simpleType;
      db_SimpleDatatypeRef (db_Column::*getter)() const= &db_Column::simpleType;
      meta->bind_member("simpleType", new grt::MetaClass::Property<db_Column,db_SimpleDatatypeRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const db_StructuredDatatypeRef &)= &db_Column::structuredType;
      db_StructuredDatatypeRef (db_Column::*getter)() const= &db_Column::structuredType;
      meta->bind_member("structuredType", new grt::MetaClass::Property<db_Column,db_StructuredDatatypeRef >(getter,setter));
    }
    {
      void (db_Column::*setter)(const db_UserDatatypeRef &)= &db_Column::userType;
      db_UserDatatypeRef (db_Column::*getter)() const= &db_Column::userType;
      meta->bind_member("userType", new grt::MetaClass::Property<db_Column,db_UserDatatypeRef >(getter,setter));
    }
    meta->bind_method("setParseType", &db_Column::call_setParseType);
  }
};


class  db_Tablespace : public GrtNamedObject
{
  typedef GrtNamedObject super;
public:
  db_Tablespace(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtNamedObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _dataFile(""),
     _extendSize(0),
     _initialSize(0)

  {
  }

  static std::string static_class_name() { return "db.Tablespace"; }

  grt::StringRef dataFile() const { return _dataFile; }
  virtual void dataFile(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_dataFile);
   _dataFile= value;
    member_changed("dataFile", ovalue, value);
  }

  grt::IntegerRef extendSize() const { return _extendSize; }
  virtual void extendSize(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_extendSize);
   _extendSize= value;
    member_changed("extendSize", ovalue, value);
  }

  grt::IntegerRef initialSize() const { return _initialSize; }
  virtual void initialSize(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_initialSize);
   _initialSize= value;
    member_changed("initialSize", ovalue, value);
  }

  // logFileGroup is owned by db_Tablespace
  db_LogFileGroupRef logFileGroup() const { return _logFileGroup; }
  virtual void logFileGroup(const db_LogFileGroupRef &value)
  {
    grt::ValueRef ovalue(_logFileGroup);

    _logFileGroup= value;
    owned_member_changed("logFileGroup", ovalue, value);
  }

protected:

  grt::StringRef _dataFile;
  grt::IntegerRef _extendSize;
  grt::IntegerRef _initialSize;
  db_LogFileGroupRef _logFileGroup;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Tablespace(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Tablespace::create);
    {
      void (db_Tablespace::*setter)(const grt::StringRef &)= &db_Tablespace::dataFile;
      grt::StringRef (db_Tablespace::*getter)() const= &db_Tablespace::dataFile;
      meta->bind_member("dataFile", new grt::MetaClass::Property<db_Tablespace,grt::StringRef >(getter,setter));
    }
    {
      void (db_Tablespace::*setter)(const grt::IntegerRef &)= &db_Tablespace::extendSize;
      grt::IntegerRef (db_Tablespace::*getter)() const= &db_Tablespace::extendSize;
      meta->bind_member("extendSize", new grt::MetaClass::Property<db_Tablespace,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Tablespace::*setter)(const grt::IntegerRef &)= &db_Tablespace::initialSize;
      grt::IntegerRef (db_Tablespace::*getter)() const= &db_Tablespace::initialSize;
      meta->bind_member("initialSize", new grt::MetaClass::Property<db_Tablespace,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Tablespace::*setter)(const db_LogFileGroupRef &)= &db_Tablespace::logFileGroup;
      db_LogFileGroupRef (db_Tablespace::*getter)() const= &db_Tablespace::logFileGroup;
      meta->bind_member("logFileGroup", new grt::MetaClass::Property<db_Tablespace,db_LogFileGroupRef >(getter,setter));
    }
  }
};


class  db_LogFileGroup : public GrtNamedObject
{
  typedef GrtNamedObject super;
public:
  db_LogFileGroup(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtNamedObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _initialSize(0),
     _undoBufferSize(0),
     _undoFile("")

  {
  }

  static std::string static_class_name() { return "db.LogFileGroup"; }

  grt::IntegerRef initialSize() const { return _initialSize; }
  virtual void initialSize(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_initialSize);
   _initialSize= value;
    member_changed("initialSize", ovalue, value);
  }

  grt::IntegerRef undoBufferSize() const { return _undoBufferSize; }
  virtual void undoBufferSize(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_undoBufferSize);
   _undoBufferSize= value;
    member_changed("undoBufferSize", ovalue, value);
  }

  grt::StringRef undoFile() const { return _undoFile; }
  virtual void undoFile(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_undoFile);
   _undoFile= value;
    member_changed("undoFile", ovalue, value);
  }

protected:

  grt::IntegerRef _initialSize;
  grt::IntegerRef _undoBufferSize;
  grt::StringRef _undoFile;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_LogFileGroup(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_LogFileGroup::create);
    {
      void (db_LogFileGroup::*setter)(const grt::IntegerRef &)= &db_LogFileGroup::initialSize;
      grt::IntegerRef (db_LogFileGroup::*getter)() const= &db_LogFileGroup::initialSize;
      meta->bind_member("initialSize", new grt::MetaClass::Property<db_LogFileGroup,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_LogFileGroup::*setter)(const grt::IntegerRef &)= &db_LogFileGroup::undoBufferSize;
      grt::IntegerRef (db_LogFileGroup::*getter)() const= &db_LogFileGroup::undoBufferSize;
      meta->bind_member("undoBufferSize", new grt::MetaClass::Property<db_LogFileGroup,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_LogFileGroup::*setter)(const grt::StringRef &)= &db_LogFileGroup::undoFile;
      grt::StringRef (db_LogFileGroup::*getter)() const= &db_LogFileGroup::undoFile;
      meta->bind_member("undoFile", new grt::MetaClass::Property<db_LogFileGroup,grt::StringRef >(getter,setter));
    }
  }
};


class  db_RolePrivilege : public GrtObject
{
  typedef GrtObject super;
public:
  db_RolePrivilege(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _databaseObjectName(""),
     _databaseObjectType(""),
    _privileges(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.RolePrivilege"; }

  db_DatabaseObjectRef databaseObject() const { return _databaseObject; }
  virtual void databaseObject(const db_DatabaseObjectRef &value)
  {
    grt::ValueRef ovalue(_databaseObject);
   _databaseObject= value;
    member_changed("databaseObject", ovalue, value);
  }

  grt::StringRef databaseObjectName() const { return _databaseObjectName; }
  virtual void databaseObjectName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_databaseObjectName);
   _databaseObjectName= value;
    member_changed("databaseObjectName", ovalue, value);
  }

  grt::StringRef databaseObjectType() const { return _databaseObjectType; }
  virtual void databaseObjectType(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_databaseObjectType);
   _databaseObjectType= value;
    member_changed("databaseObjectType", ovalue, value);
  }

  grt::StringListRef privileges() const { return _privileges; }
private: // the next attribute is read-only
  virtual void privileges(const grt::StringListRef &value)
  {
    grt::ValueRef ovalue(_privileges);
   _privileges= value;
    member_changed("privileges", ovalue, value);
  }
public:

protected:

  db_DatabaseObjectRef _databaseObject;
  grt::StringRef _databaseObjectName;
  grt::StringRef _databaseObjectType;
  grt::StringListRef _privileges;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_RolePrivilege(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_RolePrivilege::create);
    {
      void (db_RolePrivilege::*setter)(const db_DatabaseObjectRef &)= &db_RolePrivilege::databaseObject;
      db_DatabaseObjectRef (db_RolePrivilege::*getter)() const= &db_RolePrivilege::databaseObject;
      meta->bind_member("databaseObject", new grt::MetaClass::Property<db_RolePrivilege,db_DatabaseObjectRef >(getter,setter));
    }
    {
      void (db_RolePrivilege::*setter)(const grt::StringRef &)= &db_RolePrivilege::databaseObjectName;
      grt::StringRef (db_RolePrivilege::*getter)() const= &db_RolePrivilege::databaseObjectName;
      meta->bind_member("databaseObjectName", new grt::MetaClass::Property<db_RolePrivilege,grt::StringRef >(getter,setter));
    }
    {
      void (db_RolePrivilege::*setter)(const grt::StringRef &)= &db_RolePrivilege::databaseObjectType;
      grt::StringRef (db_RolePrivilege::*getter)() const= &db_RolePrivilege::databaseObjectType;
      meta->bind_member("databaseObjectType", new grt::MetaClass::Property<db_RolePrivilege,grt::StringRef >(getter,setter));
    }
    {
      void (db_RolePrivilege::*setter)(const grt::StringListRef &)= &db_RolePrivilege::privileges;
      grt::StringListRef (db_RolePrivilege::*getter)() const= &db_RolePrivilege::privileges;
      meta->bind_member("privileges", new grt::MetaClass::Property<db_RolePrivilege,grt::StringListRef >(getter,setter));
    }
  }
};


class  db_Catalog : public GrtNamedObject
{
  typedef GrtNamedObject super;
public:
  db_Catalog(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtNamedObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _characterSets(grt, this, false),
    _customData(grt, this, false),
     _defaultCharacterSetName(""),
     _defaultCollationName(""),
    _logFileGroups(grt, this, false),
    _roles(grt, this, false),
    _schemata(grt, this, false),
    _serverLinks(grt, this, false),
    _simpleDatatypes(grt, this, false),
    _tablespaces(grt, this, false),
    _userDatatypes(grt, this, false),
    _users(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.Catalog"; }

  grt::ListRef<db_CharacterSet> characterSets() const { return _characterSets; }
private: // the next attribute is read-only
  virtual void characterSets(const grt::ListRef<db_CharacterSet> &value)
  {
    grt::ValueRef ovalue(_characterSets);
   _characterSets= value;
    member_changed("characterSets", ovalue, value);
  }
public:

  grt::DictRef customData() const { return _customData; }
private: // the next attribute is read-only
  virtual void customData(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_customData);
   _customData= value;
    member_changed("customData", ovalue, value);
  }
public:

  grt::StringRef defaultCharacterSetName() const { return _defaultCharacterSetName; }
  virtual void defaultCharacterSetName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_defaultCharacterSetName);
   _defaultCharacterSetName= value;
    member_changed("defaultCharacterSetName", ovalue, value);
  }

  grt::StringRef defaultCollationName() const { return _defaultCollationName; }
  virtual void defaultCollationName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_defaultCollationName);
   _defaultCollationName= value;
    member_changed("defaultCollationName", ovalue, value);
  }

  db_SchemaRef defaultSchema() const { return _defaultSchema; }
  virtual void defaultSchema(const db_SchemaRef &value)
  {
    grt::ValueRef ovalue(_defaultSchema);
   _defaultSchema= value;
    member_changed("defaultSchema", ovalue, value);
  }

  // logFileGroups is owned by db_Catalog
  grt::ListRef<db_LogFileGroup> logFileGroups() const { return _logFileGroups; }
private: // the next attribute is read-only
  virtual void logFileGroups(const grt::ListRef<db_LogFileGroup> &value)
  {
    grt::ValueRef ovalue(_logFileGroups);

    _logFileGroups= value;
    owned_member_changed("logFileGroups", ovalue, value);
  }
public:

  // roles is owned by db_Catalog
  grt::ListRef<db_Role> roles() const { return _roles; }
private: // the next attribute is read-only
  virtual void roles(const grt::ListRef<db_Role> &value)
  {
    grt::ValueRef ovalue(_roles);

    _roles= value;
    owned_member_changed("roles", ovalue, value);
  }
public:

  // schemata is owned by db_Catalog
  grt::ListRef<db_Schema> schemata() const { return _schemata; }
private: // the next attribute is read-only
  virtual void schemata(const grt::ListRef<db_Schema> &value)
  {
    grt::ValueRef ovalue(_schemata);

    _schemata= value;
    owned_member_changed("schemata", ovalue, value);
  }
public:

  // serverLinks is owned by db_Catalog
  grt::ListRef<db_ServerLink> serverLinks() const { return _serverLinks; }
private: // the next attribute is read-only
  virtual void serverLinks(const grt::ListRef<db_ServerLink> &value)
  {
    grt::ValueRef ovalue(_serverLinks);

    _serverLinks= value;
    owned_member_changed("serverLinks", ovalue, value);
  }
public:

  grt::ListRef<db_SimpleDatatype> simpleDatatypes() const { return _simpleDatatypes; }
private: // the next attribute is read-only
  virtual void simpleDatatypes(const grt::ListRef<db_SimpleDatatype> &value)
  {
    grt::ValueRef ovalue(_simpleDatatypes);
   _simpleDatatypes= value;
    member_changed("simpleDatatypes", ovalue, value);
  }
public:

  // tablespaces is owned by db_Catalog
  grt::ListRef<db_Tablespace> tablespaces() const { return _tablespaces; }
private: // the next attribute is read-only
  virtual void tablespaces(const grt::ListRef<db_Tablespace> &value)
  {
    grt::ValueRef ovalue(_tablespaces);

    _tablespaces= value;
    owned_member_changed("tablespaces", ovalue, value);
  }
public:

  // userDatatypes is owned by db_Catalog
  grt::ListRef<db_UserDatatype> userDatatypes() const { return _userDatatypes; }
private: // the next attribute is read-only
  virtual void userDatatypes(const grt::ListRef<db_UserDatatype> &value)
  {
    grt::ValueRef ovalue(_userDatatypes);

    _userDatatypes= value;
    owned_member_changed("userDatatypes", ovalue, value);
  }
public:

  // users is owned by db_Catalog
  grt::ListRef<db_User> users() const { return _users; }
private: // the next attribute is read-only
  virtual void users(const grt::ListRef<db_User> &value)
  {
    grt::ValueRef ovalue(_users);

    _users= value;
    owned_member_changed("users", ovalue, value);
  }
public:

  // version is owned by db_Catalog
  GrtVersionRef version() const { return _version; }
  virtual void version(const GrtVersionRef &value)
  {
    grt::ValueRef ovalue(_version);

    _version= value;
    owned_member_changed("version", ovalue, value);
  }

protected:

  grt::ListRef<db_CharacterSet> _characterSets;
  grt::DictRef _customData;
  grt::StringRef _defaultCharacterSetName;
  grt::StringRef _defaultCollationName;
  db_SchemaRef _defaultSchema;
  grt::ListRef<db_LogFileGroup> _logFileGroups;// owned
  grt::ListRef<db_Role> _roles;// owned
  grt::ListRef<db_Schema> _schemata;// owned
  grt::ListRef<db_ServerLink> _serverLinks;// owned
  grt::ListRef<db_SimpleDatatype> _simpleDatatypes;
  grt::ListRef<db_Tablespace> _tablespaces;// owned
  grt::ListRef<db_UserDatatype> _userDatatypes;// owned
  grt::ListRef<db_User> _users;// owned
  GrtVersionRef _version;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Catalog(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Catalog::create);
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_CharacterSet> &)= &db_Catalog::characterSets;
      grt::ListRef<db_CharacterSet> (db_Catalog::*getter)() const= &db_Catalog::characterSets;
      meta->bind_member("characterSets", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_CharacterSet> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::DictRef &)= &db_Catalog::customData;
      grt::DictRef (db_Catalog::*getter)() const= &db_Catalog::customData;
      meta->bind_member("customData", new grt::MetaClass::Property<db_Catalog,grt::DictRef >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::StringRef &)= &db_Catalog::defaultCharacterSetName;
      grt::StringRef (db_Catalog::*getter)() const= &db_Catalog::defaultCharacterSetName;
      meta->bind_member("defaultCharacterSetName", new grt::MetaClass::Property<db_Catalog,grt::StringRef >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::StringRef &)= &db_Catalog::defaultCollationName;
      grt::StringRef (db_Catalog::*getter)() const= &db_Catalog::defaultCollationName;
      meta->bind_member("defaultCollationName", new grt::MetaClass::Property<db_Catalog,grt::StringRef >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const db_SchemaRef &)= &db_Catalog::defaultSchema;
      db_SchemaRef (db_Catalog::*getter)() const= &db_Catalog::defaultSchema;
      meta->bind_member("defaultSchema", new grt::MetaClass::Property<db_Catalog,db_SchemaRef >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_LogFileGroup> &)= &db_Catalog::logFileGroups;
      grt::ListRef<db_LogFileGroup> (db_Catalog::*getter)() const= &db_Catalog::logFileGroups;
      meta->bind_member("logFileGroups", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_LogFileGroup> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_Role> &)= &db_Catalog::roles;
      grt::ListRef<db_Role> (db_Catalog::*getter)() const= &db_Catalog::roles;
      meta->bind_member("roles", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_Role> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_Schema> &)= &db_Catalog::schemata;
      grt::ListRef<db_Schema> (db_Catalog::*getter)() const= &db_Catalog::schemata;
      meta->bind_member("schemata", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_Schema> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_ServerLink> &)= &db_Catalog::serverLinks;
      grt::ListRef<db_ServerLink> (db_Catalog::*getter)() const= &db_Catalog::serverLinks;
      meta->bind_member("serverLinks", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_ServerLink> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_SimpleDatatype> &)= &db_Catalog::simpleDatatypes;
      grt::ListRef<db_SimpleDatatype> (db_Catalog::*getter)() const= &db_Catalog::simpleDatatypes;
      meta->bind_member("simpleDatatypes", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_SimpleDatatype> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_Tablespace> &)= &db_Catalog::tablespaces;
      grt::ListRef<db_Tablespace> (db_Catalog::*getter)() const= &db_Catalog::tablespaces;
      meta->bind_member("tablespaces", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_Tablespace> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_UserDatatype> &)= &db_Catalog::userDatatypes;
      grt::ListRef<db_UserDatatype> (db_Catalog::*getter)() const= &db_Catalog::userDatatypes;
      meta->bind_member("userDatatypes", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_UserDatatype> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const grt::ListRef<db_User> &)= &db_Catalog::users;
      grt::ListRef<db_User> (db_Catalog::*getter)() const= &db_Catalog::users;
      meta->bind_member("users", new grt::MetaClass::Property<db_Catalog,grt::ListRef<db_User> >(getter,setter));
    }
    {
      void (db_Catalog::*setter)(const GrtVersionRef &)= &db_Catalog::version;
      GrtVersionRef (db_Catalog::*getter)() const= &db_Catalog::version;
      meta->bind_member("version", new grt::MetaClass::Property<db_Catalog,GrtVersionRef >(getter,setter));
    }
  }
};


class GRT_STRUCTS_DB_PUBLIC db_DatabaseObject : public GrtNamedObject
{
  typedef GrtNamedObject super;
public:
  db_DatabaseObject(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtNamedObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _commentedOut(0),
     _createDate(""),
    _customData(grt, this, false),
     _lastChangeDate(""),
     _modelOnly(0),
     _temp_sql("")

  {
  }

  virtual ~db_DatabaseObject();

  static std::string static_class_name() { return "db.DatabaseObject"; }

  grt::IntegerRef commentedOut() const { return _commentedOut; }
  virtual void commentedOut(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_commentedOut);
   _commentedOut= value;
    member_changed("commentedOut", ovalue, value);
  }

  grt::StringRef createDate() const { return _createDate; }
  virtual void createDate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_createDate);
   _createDate= value;
    member_changed("createDate", ovalue, value);
  }

  grt::DictRef customData() const { return _customData; }
private: // the next attribute is read-only
  virtual void customData(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_customData);
   _customData= value;
    member_changed("customData", ovalue, value);
  }
public:

  grt::StringRef lastChangeDate() const { return _lastChangeDate; }
  virtual void lastChangeDate(const grt::StringRef &value);

  grt::IntegerRef modelOnly() const { return _modelOnly; }
  virtual void modelOnly(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_modelOnly);
   _modelOnly= value;
    member_changed("modelOnly", ovalue, value);
  }

  grt::StringRef name() const { return super::name(); }
  virtual void name(const grt::StringRef &value);

  grt::StringRef temp_sql() const { return _temp_sql; }
  virtual void temp_sql(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_temp_sql);
   _temp_sql= value;
    member_changed("temp_sql", ovalue, value);
  }

  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:

  grt::IntegerRef _commentedOut;
  grt::StringRef _createDate;
  grt::DictRef _customData;
  grt::StringRef _lastChangeDate;
  grt::IntegerRef _modelOnly;
  grt::StringRef _temp_sql;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_DatabaseObject(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_DatabaseObject::create);
    {
      void (db_DatabaseObject::*setter)(const grt::IntegerRef &)= &db_DatabaseObject::commentedOut;
      grt::IntegerRef (db_DatabaseObject::*getter)() const= &db_DatabaseObject::commentedOut;
      meta->bind_member("commentedOut", new grt::MetaClass::Property<db_DatabaseObject,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_DatabaseObject::*setter)(const grt::StringRef &)= &db_DatabaseObject::createDate;
      grt::StringRef (db_DatabaseObject::*getter)() const= &db_DatabaseObject::createDate;
      meta->bind_member("createDate", new grt::MetaClass::Property<db_DatabaseObject,grt::StringRef >(getter,setter));
    }
    {
      void (db_DatabaseObject::*setter)(const grt::DictRef &)= &db_DatabaseObject::customData;
      grt::DictRef (db_DatabaseObject::*getter)() const= &db_DatabaseObject::customData;
      meta->bind_member("customData", new grt::MetaClass::Property<db_DatabaseObject,grt::DictRef >(getter,setter));
    }
    {
      void (db_DatabaseObject::*setter)(const grt::StringRef &)= &db_DatabaseObject::lastChangeDate;
      grt::StringRef (db_DatabaseObject::*getter)() const= &db_DatabaseObject::lastChangeDate;
      meta->bind_member("lastChangeDate", new grt::MetaClass::Property<db_DatabaseObject,grt::StringRef >(getter,setter));
    }
    {
      void (db_DatabaseObject::*setter)(const grt::IntegerRef &)= &db_DatabaseObject::modelOnly;
      grt::IntegerRef (db_DatabaseObject::*getter)() const= &db_DatabaseObject::modelOnly;
      meta->bind_member("modelOnly", new grt::MetaClass::Property<db_DatabaseObject,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_DatabaseObject::*setter)(const grt::StringRef &)= &db_DatabaseObject::name;
      grt::StringRef (db_DatabaseObject::*getter)() const= 0;
      meta->bind_member("name", new grt::MetaClass::Property<db_DatabaseObject,grt::StringRef >(getter,setter));
    }
    {
      void (db_DatabaseObject::*setter)(const grt::StringRef &)= &db_DatabaseObject::temp_sql;
      grt::StringRef (db_DatabaseObject::*getter)() const= &db_DatabaseObject::temp_sql;
      meta->bind_member("temp_sql", new grt::MetaClass::Property<db_DatabaseObject,grt::StringRef >(getter,setter));
    }
  }
};


class  db_Sequence : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_Sequence(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _cacheSize(""),
     _cycleFlag(0),
     _incrementBy(""),
     _lastNumber(""),
     _maxValue(""),
     _minValue(""),
     _orderFlag(0)

  {
  }

  static std::string static_class_name() { return "db.Sequence"; }

  grt::StringRef cacheSize() const { return _cacheSize; }
  virtual void cacheSize(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_cacheSize);
   _cacheSize= value;
    member_changed("cacheSize", ovalue, value);
  }

  grt::IntegerRef cycleFlag() const { return _cycleFlag; }
  virtual void cycleFlag(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_cycleFlag);
   _cycleFlag= value;
    member_changed("cycleFlag", ovalue, value);
  }

  grt::StringRef incrementBy() const { return _incrementBy; }
  virtual void incrementBy(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_incrementBy);
   _incrementBy= value;
    member_changed("incrementBy", ovalue, value);
  }

  grt::StringRef lastNumber() const { return _lastNumber; }
  virtual void lastNumber(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_lastNumber);
   _lastNumber= value;
    member_changed("lastNumber", ovalue, value);
  }

  grt::StringRef maxValue() const { return _maxValue; }
  virtual void maxValue(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_maxValue);
   _maxValue= value;
    member_changed("maxValue", ovalue, value);
  }

  grt::StringRef minValue() const { return _minValue; }
  virtual void minValue(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_minValue);
   _minValue= value;
    member_changed("minValue", ovalue, value);
  }

  grt::IntegerRef orderFlag() const { return _orderFlag; }
  virtual void orderFlag(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_orderFlag);
   _orderFlag= value;
    member_changed("orderFlag", ovalue, value);
  }

protected:

  grt::StringRef _cacheSize;
  grt::IntegerRef _cycleFlag;
  grt::StringRef _incrementBy;
  grt::StringRef _lastNumber;
  grt::StringRef _maxValue;
  grt::StringRef _minValue;
  grt::IntegerRef _orderFlag;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Sequence(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Sequence::create);
    {
      void (db_Sequence::*setter)(const grt::StringRef &)= &db_Sequence::cacheSize;
      grt::StringRef (db_Sequence::*getter)() const= &db_Sequence::cacheSize;
      meta->bind_member("cacheSize", new grt::MetaClass::Property<db_Sequence,grt::StringRef >(getter,setter));
    }
    {
      void (db_Sequence::*setter)(const grt::IntegerRef &)= &db_Sequence::cycleFlag;
      grt::IntegerRef (db_Sequence::*getter)() const= &db_Sequence::cycleFlag;
      meta->bind_member("cycleFlag", new grt::MetaClass::Property<db_Sequence,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Sequence::*setter)(const grt::StringRef &)= &db_Sequence::incrementBy;
      grt::StringRef (db_Sequence::*getter)() const= &db_Sequence::incrementBy;
      meta->bind_member("incrementBy", new grt::MetaClass::Property<db_Sequence,grt::StringRef >(getter,setter));
    }
    {
      void (db_Sequence::*setter)(const grt::StringRef &)= &db_Sequence::lastNumber;
      grt::StringRef (db_Sequence::*getter)() const= &db_Sequence::lastNumber;
      meta->bind_member("lastNumber", new grt::MetaClass::Property<db_Sequence,grt::StringRef >(getter,setter));
    }
    {
      void (db_Sequence::*setter)(const grt::StringRef &)= &db_Sequence::maxValue;
      grt::StringRef (db_Sequence::*getter)() const= &db_Sequence::maxValue;
      meta->bind_member("maxValue", new grt::MetaClass::Property<db_Sequence,grt::StringRef >(getter,setter));
    }
    {
      void (db_Sequence::*setter)(const grt::StringRef &)= &db_Sequence::minValue;
      grt::StringRef (db_Sequence::*getter)() const= &db_Sequence::minValue;
      meta->bind_member("minValue", new grt::MetaClass::Property<db_Sequence,grt::StringRef >(getter,setter));
    }
    {
      void (db_Sequence::*setter)(const grt::IntegerRef &)= &db_Sequence::orderFlag;
      grt::IntegerRef (db_Sequence::*getter)() const= &db_Sequence::orderFlag;
      meta->bind_member("orderFlag", new grt::MetaClass::Property<db_Sequence,grt::IntegerRef >(getter,setter));
    }
  }
};


class  db_Synonym : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_Synonym(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _isPublic(0),
     _referencedObjectName(""),
     _referencedSchemaName("")

  {
  }

  static std::string static_class_name() { return "db.Synonym"; }

  grt::IntegerRef isPublic() const { return _isPublic; }
  virtual void isPublic(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isPublic);
   _isPublic= value;
    member_changed("isPublic", ovalue, value);
  }

  db_DatabaseObjectRef referencedObject() const { return _referencedObject; }
  virtual void referencedObject(const db_DatabaseObjectRef &value)
  {
    grt::ValueRef ovalue(_referencedObject);
   _referencedObject= value;
    member_changed("referencedObject", ovalue, value);
  }

  grt::StringRef referencedObjectName() const { return _referencedObjectName; }
  virtual void referencedObjectName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_referencedObjectName);
   _referencedObjectName= value;
    member_changed("referencedObjectName", ovalue, value);
  }

  grt::StringRef referencedSchemaName() const { return _referencedSchemaName; }
  virtual void referencedSchemaName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_referencedSchemaName);
   _referencedSchemaName= value;
    member_changed("referencedSchemaName", ovalue, value);
  }

protected:

  grt::IntegerRef _isPublic;
  db_DatabaseObjectRef _referencedObject;
  grt::StringRef _referencedObjectName;
  grt::StringRef _referencedSchemaName;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Synonym(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Synonym::create);
    {
      void (db_Synonym::*setter)(const grt::IntegerRef &)= &db_Synonym::isPublic;
      grt::IntegerRef (db_Synonym::*getter)() const= &db_Synonym::isPublic;
      meta->bind_member("isPublic", new grt::MetaClass::Property<db_Synonym,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Synonym::*setter)(const db_DatabaseObjectRef &)= &db_Synonym::referencedObject;
      db_DatabaseObjectRef (db_Synonym::*getter)() const= &db_Synonym::referencedObject;
      meta->bind_member("referencedObject", new grt::MetaClass::Property<db_Synonym,db_DatabaseObjectRef >(getter,setter));
    }
    {
      void (db_Synonym::*setter)(const grt::StringRef &)= &db_Synonym::referencedObjectName;
      grt::StringRef (db_Synonym::*getter)() const= &db_Synonym::referencedObjectName;
      meta->bind_member("referencedObjectName", new grt::MetaClass::Property<db_Synonym,grt::StringRef >(getter,setter));
    }
    {
      void (db_Synonym::*setter)(const grt::StringRef &)= &db_Synonym::referencedSchemaName;
      grt::StringRef (db_Synonym::*getter)() const= &db_Synonym::referencedSchemaName;
      meta->bind_member("referencedSchemaName", new grt::MetaClass::Property<db_Synonym,grt::StringRef >(getter,setter));
    }
  }
};


class  db_RoutineGroup : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_RoutineGroup(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _routineExpandedHeights(grt, this, false),
    _routineExpandedStates(grt, this, false),
    _routines(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.RoutineGroup"; }

  // args: 
  sigc::signal<void > signal_contentChanged() { return _signal_contentChanged; }
  grt::IntegerListRef routineExpandedHeights() const { return _routineExpandedHeights; }
private: // the next attribute is read-only
  virtual void routineExpandedHeights(const grt::IntegerListRef &value)
  {
    grt::ValueRef ovalue(_routineExpandedHeights);
   _routineExpandedHeights= value;
    member_changed("routineExpandedHeights", ovalue, value);
  }
public:

  grt::IntegerListRef routineExpandedStates() const { return _routineExpandedStates; }
private: // the next attribute is read-only
  virtual void routineExpandedStates(const grt::IntegerListRef &value)
  {
    grt::ValueRef ovalue(_routineExpandedStates);
   _routineExpandedStates= value;
    member_changed("routineExpandedStates", ovalue, value);
  }
public:

  // routines is owned by db_RoutineGroup
  grt::ListRef<db_Routine> routines() const { return _routines; }
private: // the next attribute is read-only
  virtual void routines(const grt::ListRef<db_Routine> &value)
  {
    grt::ValueRef ovalue(_routines);

    _routines= value;
    owned_member_changed("routines", ovalue, value);
  }
public:

protected:
  sigc::signal<void > _signal_contentChanged;

  grt::IntegerListRef _routineExpandedHeights;
  grt::IntegerListRef _routineExpandedStates;
  grt::ListRef<db_Routine> _routines;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_RoutineGroup(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_RoutineGroup::create);
    {
      void (db_RoutineGroup::*setter)(const grt::IntegerListRef &)= &db_RoutineGroup::routineExpandedHeights;
      grt::IntegerListRef (db_RoutineGroup::*getter)() const= &db_RoutineGroup::routineExpandedHeights;
      meta->bind_member("routineExpandedHeights", new grt::MetaClass::Property<db_RoutineGroup,grt::IntegerListRef >(getter,setter));
    }
    {
      void (db_RoutineGroup::*setter)(const grt::IntegerListRef &)= &db_RoutineGroup::routineExpandedStates;
      grt::IntegerListRef (db_RoutineGroup::*getter)() const= &db_RoutineGroup::routineExpandedStates;
      meta->bind_member("routineExpandedStates", new grt::MetaClass::Property<db_RoutineGroup,grt::IntegerListRef >(getter,setter));
    }
    {
      void (db_RoutineGroup::*setter)(const grt::ListRef<db_Routine> &)= &db_RoutineGroup::routines;
      grt::ListRef<db_Routine> (db_RoutineGroup::*getter)() const= &db_RoutineGroup::routines;
      meta->bind_member("routines", new grt::MetaClass::Property<db_RoutineGroup,grt::ListRef<db_Routine> >(getter,setter));
    }
  }
};


class  db_StructuredDatatype : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_StructuredDatatype(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _distinctTypes(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.StructuredDatatype"; }

  // distinctTypes is owned by db_StructuredDatatype
  grt::ListRef<db_Column> distinctTypes() const { return _distinctTypes; }
private: // the next attribute is read-only
  virtual void distinctTypes(const grt::ListRef<db_Column> &value)
  {
    grt::ValueRef ovalue(_distinctTypes);

    _distinctTypes= value;
    owned_member_changed("distinctTypes", ovalue, value);
  }
public:

  db_StructuredDatatypeRef parentType() const { return _parentType; }
  virtual void parentType(const db_StructuredDatatypeRef &value)
  {
    grt::ValueRef ovalue(_parentType);
   _parentType= value;
    member_changed("parentType", ovalue, value);
  }

protected:

  grt::ListRef<db_Column> _distinctTypes;// owned
  db_StructuredDatatypeRef _parentType;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_StructuredDatatype(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_StructuredDatatype::create);
    {
      void (db_StructuredDatatype::*setter)(const grt::ListRef<db_Column> &)= &db_StructuredDatatype::distinctTypes;
      grt::ListRef<db_Column> (db_StructuredDatatype::*getter)() const= &db_StructuredDatatype::distinctTypes;
      meta->bind_member("distinctTypes", new grt::MetaClass::Property<db_StructuredDatatype,grt::ListRef<db_Column> >(getter,setter));
    }
    {
      void (db_StructuredDatatype::*setter)(const db_StructuredDatatypeRef &)= &db_StructuredDatatype::parentType;
      db_StructuredDatatypeRef (db_StructuredDatatype::*getter)() const= &db_StructuredDatatype::parentType;
      meta->bind_member("parentType", new grt::MetaClass::Property<db_StructuredDatatype,db_StructuredDatatypeRef >(getter,setter));
    }
  }
};


class GRT_STRUCTS_DB_PUBLIC db_Table : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_Table(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _columns(grt, this, false),
    _foreignKeys(grt, this, false),
    _indices(grt, this, false),
     _isStub(0),
     _isSystem(0),
     _isTemporary(0),
     _temporaryScope(""),
    _triggers(grt, this, false)

  {
  }

  virtual ~db_Table();

  static std::string static_class_name() { return "db.Table"; }

  // args: 
  sigc::signal<void, std::string > signal_refreshDisplay() { return _signal_refreshDisplay; }
  // args: 
  sigc::signal<void, grt::Ref<db_ForeignKey> > signal_foreignKeyChanged() { return _signal_foreignKeyChanged; }
  // columns is owned by db_Table
  grt::ListRef<db_Column> columns() const { return _columns; }
private: // the next attribute is read-only
  virtual void columns(const grt::ListRef<db_Column> &value)
  {
    grt::ValueRef ovalue(_columns);

    _columns= value;
    owned_member_changed("columns", ovalue, value);
  }
public:

  // foreignKeys is owned by db_Table
  grt::ListRef<db_ForeignKey> foreignKeys() const { return _foreignKeys; }
private: // the next attribute is read-only
  virtual void foreignKeys(const grt::ListRef<db_ForeignKey> &value)
  {
    grt::ValueRef ovalue(_foreignKeys);

    _foreignKeys= value;
    owned_member_changed("foreignKeys", ovalue, value);
  }
public:

  // indices is owned by db_Table
  grt::ListRef<db_Index> indices() const { return _indices; }
private: // the next attribute is read-only
  virtual void indices(const grt::ListRef<db_Index> &value)
  {
    grt::ValueRef ovalue(_indices);

    _indices= value;
    owned_member_changed("indices", ovalue, value);
  }
public:

  grt::IntegerRef isStub() const { return _isStub; }
  virtual void isStub(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isStub);
   _isStub= value;
    member_changed("isStub", ovalue, value);
  }

  grt::IntegerRef isSystem() const { return _isSystem; }
  virtual void isSystem(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isSystem);
   _isSystem= value;
    member_changed("isSystem", ovalue, value);
  }

  grt::IntegerRef isTemporary() const { return _isTemporary; }
  virtual void isTemporary(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isTemporary);
   _isTemporary= value;
    member_changed("isTemporary", ovalue, value);
  }

  db_IndexRef primaryKey() const { return _primaryKey; }
  virtual void primaryKey(const db_IndexRef &value)
  {
    grt::ValueRef ovalue(_primaryKey);
   _primaryKey= value;
    member_changed("primaryKey", ovalue, value);
  }

  grt::StringRef temporaryScope() const { return _temporaryScope; }
  virtual void temporaryScope(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_temporaryScope);
   _temporaryScope= value;
    member_changed("temporaryScope", ovalue, value);
  }

  // triggers is owned by db_Table
  grt::ListRef<db_Trigger> triggers() const { return _triggers; }
private: // the next attribute is read-only
  virtual void triggers(const grt::ListRef<db_Trigger> &value)
  {
    grt::ValueRef ovalue(_triggers);

    _triggers= value;
    owned_member_changed("triggers", ovalue, value);
  }
public:

  virtual void addColumn(const db_ColumnRef &column);
  virtual void addIndex(const db_IndexRef &index);
  virtual void addPrimaryKeyColumn(const db_ColumnRef &column);
  virtual db_ForeignKeyRef createForeignKey(const std::string &name);
  virtual grt::StringRef inserts();
  virtual grt::IntegerRef isDependantTable();
  virtual grt::IntegerRef isForeignKeyColumn(const db_ColumnRef &column);
  virtual grt::IntegerRef isPrimaryKeyColumn(const db_ColumnRef &column);
  virtual void removeColumn(const db_ColumnRef &column);
  virtual void removeForeignKey(const db_ForeignKeyRef &fk, long removeColumns);
  virtual void removeIndex(const db_IndexRef &index);
  virtual void removePrimaryKeyColumn(const db_ColumnRef &column);
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:
  sigc::signal<void, std::string > _signal_refreshDisplay;
  sigc::signal<void, grt::Ref<db_ForeignKey> > _signal_foreignKeyChanged;

  grt::ListRef<db_Column> _columns;// owned
  grt::ListRef<db_ForeignKey> _foreignKeys;// owned
  grt::ListRef<db_Index> _indices;// owned
  grt::IntegerRef _isStub;
  grt::IntegerRef _isSystem;
  grt::IntegerRef _isTemporary;
  db_IndexRef _primaryKey;
  grt::StringRef _temporaryScope;
  grt::ListRef<db_Trigger> _triggers;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Table(grt));
  }

  static grt::ValueRef call_addColumn(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<db_Table*>(self)->addColumn(db_ColumnRef::cast_from(args[0])); return grt::ValueRef(); }

  static grt::ValueRef call_addIndex(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<db_Table*>(self)->addIndex(db_IndexRef::cast_from(args[0])); return grt::ValueRef(); }

  static grt::ValueRef call_addPrimaryKeyColumn(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<db_Table*>(self)->addPrimaryKeyColumn(db_ColumnRef::cast_from(args[0])); return grt::ValueRef(); }

  static grt::ValueRef call_createForeignKey(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Table*>(self)->createForeignKey(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_inserts(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Table*>(self)->inserts(); }

  static grt::ValueRef call_isDependantTable(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Table*>(self)->isDependantTable(); }

  static grt::ValueRef call_isForeignKeyColumn(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Table*>(self)->isForeignKeyColumn(db_ColumnRef::cast_from(args[0])); }

  static grt::ValueRef call_isPrimaryKeyColumn(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Table*>(self)->isPrimaryKeyColumn(db_ColumnRef::cast_from(args[0])); }

  static grt::ValueRef call_removeColumn(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<db_Table*>(self)->removeColumn(db_ColumnRef::cast_from(args[0])); return grt::ValueRef(); }

  static grt::ValueRef call_removeForeignKey(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<db_Table*>(self)->removeForeignKey(db_ForeignKeyRef::cast_from(args[0]), grt::IntegerRef::cast_from(args[1])); return grt::ValueRef(); }

  static grt::ValueRef call_removeIndex(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<db_Table*>(self)->removeIndex(db_IndexRef::cast_from(args[0])); return grt::ValueRef(); }

  static grt::ValueRef call_removePrimaryKeyColumn(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<db_Table*>(self)->removePrimaryKeyColumn(db_ColumnRef::cast_from(args[0])); return grt::ValueRef(); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Table::create);
    {
      void (db_Table::*setter)(const grt::ListRef<db_Column> &)= &db_Table::columns;
      grt::ListRef<db_Column> (db_Table::*getter)() const= &db_Table::columns;
      meta->bind_member("columns", new grt::MetaClass::Property<db_Table,grt::ListRef<db_Column> >(getter,setter));
    }
    {
      void (db_Table::*setter)(const grt::ListRef<db_ForeignKey> &)= &db_Table::foreignKeys;
      grt::ListRef<db_ForeignKey> (db_Table::*getter)() const= &db_Table::foreignKeys;
      meta->bind_member("foreignKeys", new grt::MetaClass::Property<db_Table,grt::ListRef<db_ForeignKey> >(getter,setter));
    }
    {
      void (db_Table::*setter)(const grt::ListRef<db_Index> &)= &db_Table::indices;
      grt::ListRef<db_Index> (db_Table::*getter)() const= &db_Table::indices;
      meta->bind_member("indices", new grt::MetaClass::Property<db_Table,grt::ListRef<db_Index> >(getter,setter));
    }
    {
      void (db_Table::*setter)(const grt::IntegerRef &)= &db_Table::isStub;
      grt::IntegerRef (db_Table::*getter)() const= &db_Table::isStub;
      meta->bind_member("isStub", new grt::MetaClass::Property<db_Table,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Table::*setter)(const grt::IntegerRef &)= &db_Table::isSystem;
      grt::IntegerRef (db_Table::*getter)() const= &db_Table::isSystem;
      meta->bind_member("isSystem", new grt::MetaClass::Property<db_Table,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Table::*setter)(const grt::IntegerRef &)= &db_Table::isTemporary;
      grt::IntegerRef (db_Table::*getter)() const= &db_Table::isTemporary;
      meta->bind_member("isTemporary", new grt::MetaClass::Property<db_Table,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Table::*setter)(const db_IndexRef &)= &db_Table::primaryKey;
      db_IndexRef (db_Table::*getter)() const= &db_Table::primaryKey;
      meta->bind_member("primaryKey", new grt::MetaClass::Property<db_Table,db_IndexRef >(getter,setter));
    }
    {
      void (db_Table::*setter)(const grt::StringRef &)= &db_Table::temporaryScope;
      grt::StringRef (db_Table::*getter)() const= &db_Table::temporaryScope;
      meta->bind_member("temporaryScope", new grt::MetaClass::Property<db_Table,grt::StringRef >(getter,setter));
    }
    {
      void (db_Table::*setter)(const grt::ListRef<db_Trigger> &)= &db_Table::triggers;
      grt::ListRef<db_Trigger> (db_Table::*getter)() const= &db_Table::triggers;
      meta->bind_member("triggers", new grt::MetaClass::Property<db_Table,grt::ListRef<db_Trigger> >(getter,setter));
    }
    meta->bind_method("addColumn", &db_Table::call_addColumn);
    meta->bind_method("addIndex", &db_Table::call_addIndex);
    meta->bind_method("addPrimaryKeyColumn", &db_Table::call_addPrimaryKeyColumn);
    meta->bind_method("createForeignKey", &db_Table::call_createForeignKey);
    meta->bind_method("inserts", &db_Table::call_inserts);
    meta->bind_method("isDependantTable", &db_Table::call_isDependantTable);
    meta->bind_method("isForeignKeyColumn", &db_Table::call_isForeignKeyColumn);
    meta->bind_method("isPrimaryKeyColumn", &db_Table::call_isPrimaryKeyColumn);
    meta->bind_method("removeColumn", &db_Table::call_removeColumn);
    meta->bind_method("removeForeignKey", &db_Table::call_removeForeignKey);
    meta->bind_method("removeIndex", &db_Table::call_removeIndex);
    meta->bind_method("removePrimaryKeyColumn", &db_Table::call_removePrimaryKeyColumn);
  }
};


class  db_ServerLink : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_ServerLink(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _host(""),
     _ownerUser(""),
     _password(""),
     _port(""),
     _schema(""),
     _socket(""),
     _user(""),
     _wrapperName("")

  {
  }

  static std::string static_class_name() { return "db.ServerLink"; }

  grt::StringRef host() const { return _host; }
  virtual void host(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_host);
   _host= value;
    member_changed("host", ovalue, value);
  }

  grt::StringRef ownerUser() const { return _ownerUser; }
  virtual void ownerUser(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_ownerUser);
   _ownerUser= value;
    member_changed("ownerUser", ovalue, value);
  }

  grt::StringRef password() const { return _password; }
  virtual void password(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_password);
   _password= value;
    member_changed("password", ovalue, value);
  }

  grt::StringRef port() const { return _port; }
  virtual void port(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_port);
   _port= value;
    member_changed("port", ovalue, value);
  }

  grt::StringRef schema() const { return _schema; }
  virtual void schema(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_schema);
   _schema= value;
    member_changed("schema", ovalue, value);
  }

  grt::StringRef socket() const { return _socket; }
  virtual void socket(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_socket);
   _socket= value;
    member_changed("socket", ovalue, value);
  }

  grt::StringRef user() const { return _user; }
  virtual void user(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_user);
   _user= value;
    member_changed("user", ovalue, value);
  }

  grt::StringRef wrapperName() const { return _wrapperName; }
  virtual void wrapperName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_wrapperName);
   _wrapperName= value;
    member_changed("wrapperName", ovalue, value);
  }

protected:

  grt::StringRef _host;
  grt::StringRef _ownerUser;
  grt::StringRef _password;
  grt::StringRef _port;
  grt::StringRef _schema;
  grt::StringRef _socket;
  grt::StringRef _user;
  grt::StringRef _wrapperName;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_ServerLink(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_ServerLink::create);
    {
      void (db_ServerLink::*setter)(const grt::StringRef &)= &db_ServerLink::host;
      grt::StringRef (db_ServerLink::*getter)() const= &db_ServerLink::host;
      meta->bind_member("host", new grt::MetaClass::Property<db_ServerLink,grt::StringRef >(getter,setter));
    }
    {
      void (db_ServerLink::*setter)(const grt::StringRef &)= &db_ServerLink::ownerUser;
      grt::StringRef (db_ServerLink::*getter)() const= &db_ServerLink::ownerUser;
      meta->bind_member("ownerUser", new grt::MetaClass::Property<db_ServerLink,grt::StringRef >(getter,setter));
    }
    {
      void (db_ServerLink::*setter)(const grt::StringRef &)= &db_ServerLink::password;
      grt::StringRef (db_ServerLink::*getter)() const= &db_ServerLink::password;
      meta->bind_member("password", new grt::MetaClass::Property<db_ServerLink,grt::StringRef >(getter,setter));
    }
    {
      void (db_ServerLink::*setter)(const grt::StringRef &)= &db_ServerLink::port;
      grt::StringRef (db_ServerLink::*getter)() const= &db_ServerLink::port;
      meta->bind_member("port", new grt::MetaClass::Property<db_ServerLink,grt::StringRef >(getter,setter));
    }
    {
      void (db_ServerLink::*setter)(const grt::StringRef &)= &db_ServerLink::schema;
      grt::StringRef (db_ServerLink::*getter)() const= &db_ServerLink::schema;
      meta->bind_member("schema", new grt::MetaClass::Property<db_ServerLink,grt::StringRef >(getter,setter));
    }
    {
      void (db_ServerLink::*setter)(const grt::StringRef &)= &db_ServerLink::socket;
      grt::StringRef (db_ServerLink::*getter)() const= &db_ServerLink::socket;
      meta->bind_member("socket", new grt::MetaClass::Property<db_ServerLink,grt::StringRef >(getter,setter));
    }
    {
      void (db_ServerLink::*setter)(const grt::StringRef &)= &db_ServerLink::user;
      grt::StringRef (db_ServerLink::*getter)() const= &db_ServerLink::user;
      meta->bind_member("user", new grt::MetaClass::Property<db_ServerLink,grt::StringRef >(getter,setter));
    }
    {
      void (db_ServerLink::*setter)(const grt::StringRef &)= &db_ServerLink::wrapperName;
      grt::StringRef (db_ServerLink::*getter)() const= &db_ServerLink::wrapperName;
      meta->bind_member("wrapperName", new grt::MetaClass::Property<db_ServerLink,grt::StringRef >(getter,setter));
    }
  }
};


class GRT_STRUCTS_DB_PUBLIC db_Schema : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_Schema(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _defaultCharacterSetName(""),
     _defaultCollationName(""),
    _routineGroups(grt, this, false),
    _routines(grt, this, false),
    _sequences(grt, this, false),
    _structuredTypes(grt, this, false),
    _synonyms(grt, this, false),
    _tables(grt, this, false),
    _views(grt, this, false)

  {
  }

  virtual ~db_Schema();

  static std::string static_class_name() { return "db.Schema"; }

  // args: 
  sigc::signal<void, grt::Ref<db_DatabaseObject> > signal_refreshDisplay() { return _signal_refreshDisplay; }
  grt::StringRef defaultCharacterSetName() const { return _defaultCharacterSetName; }
  virtual void defaultCharacterSetName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_defaultCharacterSetName);
   _defaultCharacterSetName= value;
    member_changed("defaultCharacterSetName", ovalue, value);
  }

  grt::StringRef defaultCollationName() const { return _defaultCollationName; }
  virtual void defaultCollationName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_defaultCollationName);
   _defaultCollationName= value;
    member_changed("defaultCollationName", ovalue, value);
  }

  // routineGroups is owned by db_Schema
  grt::ListRef<db_RoutineGroup> routineGroups() const { return _routineGroups; }
private: // the next attribute is read-only
  virtual void routineGroups(const grt::ListRef<db_RoutineGroup> &value)
  {
    grt::ValueRef ovalue(_routineGroups);

    _routineGroups= value;
    owned_member_changed("routineGroups", ovalue, value);
  }
public:

  // routines is owned by db_Schema
  grt::ListRef<db_Routine> routines() const { return _routines; }
private: // the next attribute is read-only
  virtual void routines(const grt::ListRef<db_Routine> &value)
  {
    grt::ValueRef ovalue(_routines);

    _routines= value;
    owned_member_changed("routines", ovalue, value);
  }
public:

  // sequences is owned by db_Schema
  grt::ListRef<db_Sequence> sequences() const { return _sequences; }
private: // the next attribute is read-only
  virtual void sequences(const grt::ListRef<db_Sequence> &value)
  {
    grt::ValueRef ovalue(_sequences);

    _sequences= value;
    owned_member_changed("sequences", ovalue, value);
  }
public:

  // structuredTypes is owned by db_Schema
  grt::ListRef<db_StructuredDatatype> structuredTypes() const { return _structuredTypes; }
private: // the next attribute is read-only
  virtual void structuredTypes(const grt::ListRef<db_StructuredDatatype> &value)
  {
    grt::ValueRef ovalue(_structuredTypes);

    _structuredTypes= value;
    owned_member_changed("structuredTypes", ovalue, value);
  }
public:

  // synonyms is owned by db_Schema
  grt::ListRef<db_Synonym> synonyms() const { return _synonyms; }
private: // the next attribute is read-only
  virtual void synonyms(const grt::ListRef<db_Synonym> &value)
  {
    grt::ValueRef ovalue(_synonyms);

    _synonyms= value;
    owned_member_changed("synonyms", ovalue, value);
  }
public:

  // tables is owned by db_Schema
  grt::ListRef<db_Table> tables() const { return _tables; }
private: // the next attribute is read-only
  virtual void tables(const grt::ListRef<db_Table> &value)
  {
    grt::ValueRef ovalue(_tables);

    _tables= value;
    owned_member_changed("tables", ovalue, value);
  }
public:

  // views is owned by db_Schema
  grt::ListRef<db_View> views() const { return _views; }
private: // the next attribute is read-only
  virtual void views(const grt::ListRef<db_View> &value)
  {
    grt::ValueRef ovalue(_views);

    _views= value;
    owned_member_changed("views", ovalue, value);
  }
public:

  virtual db_RoutineRef addNewRoutine(const std::string &dbpackage);
  virtual db_RoutineGroupRef addNewRoutineGroup(const std::string &dbpackage);
  virtual db_TableRef addNewTable(const std::string &dbpackage);
  virtual db_ViewRef addNewView(const std::string &dbpackage);
  virtual grt::ListRef<db_ForeignKey> getForeignKeysReferencingTable(const db_TableRef &table);
  virtual void removeTable(const db_TableRef &table);
  // default initialization function. auto-called by Ref<Object> constructor
  virtual void init();

protected:
  sigc::signal<void, grt::Ref<db_DatabaseObject> > _signal_refreshDisplay;

  grt::StringRef _defaultCharacterSetName;
  grt::StringRef _defaultCollationName;
  grt::ListRef<db_RoutineGroup> _routineGroups;// owned
  grt::ListRef<db_Routine> _routines;// owned
  grt::ListRef<db_Sequence> _sequences;// owned
  grt::ListRef<db_StructuredDatatype> _structuredTypes;// owned
  grt::ListRef<db_Synonym> _synonyms;// owned
  grt::ListRef<db_Table> _tables;// owned
  grt::ListRef<db_View> _views;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Schema(grt));
  }

  static grt::ValueRef call_addNewRoutine(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Schema*>(self)->addNewRoutine(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_addNewRoutineGroup(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Schema*>(self)->addNewRoutineGroup(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_addNewTable(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Schema*>(self)->addNewTable(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_addNewView(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Schema*>(self)->addNewView(grt::StringRef::cast_from(args[0])); }

  static grt::ValueRef call_getForeignKeysReferencingTable(grt::internal::Object *self, const grt::BaseListRef &args){ return dynamic_cast<db_Schema*>(self)->getForeignKeysReferencingTable(db_TableRef::cast_from(args[0])); }

  static grt::ValueRef call_removeTable(grt::internal::Object *self, const grt::BaseListRef &args){ dynamic_cast<db_Schema*>(self)->removeTable(db_TableRef::cast_from(args[0])); return grt::ValueRef(); }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Schema::create);
    {
      void (db_Schema::*setter)(const grt::StringRef &)= &db_Schema::defaultCharacterSetName;
      grt::StringRef (db_Schema::*getter)() const= &db_Schema::defaultCharacterSetName;
      meta->bind_member("defaultCharacterSetName", new grt::MetaClass::Property<db_Schema,grt::StringRef >(getter,setter));
    }
    {
      void (db_Schema::*setter)(const grt::StringRef &)= &db_Schema::defaultCollationName;
      grt::StringRef (db_Schema::*getter)() const= &db_Schema::defaultCollationName;
      meta->bind_member("defaultCollationName", new grt::MetaClass::Property<db_Schema,grt::StringRef >(getter,setter));
    }
    {
      void (db_Schema::*setter)(const grt::ListRef<db_RoutineGroup> &)= &db_Schema::routineGroups;
      grt::ListRef<db_RoutineGroup> (db_Schema::*getter)() const= &db_Schema::routineGroups;
      meta->bind_member("routineGroups", new grt::MetaClass::Property<db_Schema,grt::ListRef<db_RoutineGroup> >(getter,setter));
    }
    {
      void (db_Schema::*setter)(const grt::ListRef<db_Routine> &)= &db_Schema::routines;
      grt::ListRef<db_Routine> (db_Schema::*getter)() const= &db_Schema::routines;
      meta->bind_member("routines", new grt::MetaClass::Property<db_Schema,grt::ListRef<db_Routine> >(getter,setter));
    }
    {
      void (db_Schema::*setter)(const grt::ListRef<db_Sequence> &)= &db_Schema::sequences;
      grt::ListRef<db_Sequence> (db_Schema::*getter)() const= &db_Schema::sequences;
      meta->bind_member("sequences", new grt::MetaClass::Property<db_Schema,grt::ListRef<db_Sequence> >(getter,setter));
    }
    {
      void (db_Schema::*setter)(const grt::ListRef<db_StructuredDatatype> &)= &db_Schema::structuredTypes;
      grt::ListRef<db_StructuredDatatype> (db_Schema::*getter)() const= &db_Schema::structuredTypes;
      meta->bind_member("structuredTypes", new grt::MetaClass::Property<db_Schema,grt::ListRef<db_StructuredDatatype> >(getter,setter));
    }
    {
      void (db_Schema::*setter)(const grt::ListRef<db_Synonym> &)= &db_Schema::synonyms;
      grt::ListRef<db_Synonym> (db_Schema::*getter)() const= &db_Schema::synonyms;
      meta->bind_member("synonyms", new grt::MetaClass::Property<db_Schema,grt::ListRef<db_Synonym> >(getter,setter));
    }
    {
      void (db_Schema::*setter)(const grt::ListRef<db_Table> &)= &db_Schema::tables;
      grt::ListRef<db_Table> (db_Schema::*getter)() const= &db_Schema::tables;
      meta->bind_member("tables", new grt::MetaClass::Property<db_Schema,grt::ListRef<db_Table> >(getter,setter));
    }
    {
      void (db_Schema::*setter)(const grt::ListRef<db_View> &)= &db_Schema::views;
      grt::ListRef<db_View> (db_Schema::*getter)() const= &db_Schema::views;
      meta->bind_member("views", new grt::MetaClass::Property<db_Schema,grt::ListRef<db_View> >(getter,setter));
    }
    meta->bind_method("addNewRoutine", &db_Schema::call_addNewRoutine);
    meta->bind_method("addNewRoutineGroup", &db_Schema::call_addNewRoutineGroup);
    meta->bind_method("addNewTable", &db_Schema::call_addNewTable);
    meta->bind_method("addNewView", &db_Schema::call_addNewView);
    meta->bind_method("getForeignKeysReferencingTable", &db_Schema::call_getForeignKeysReferencingTable);
    meta->bind_method("removeTable", &db_Schema::call_removeTable);
  }
};


class  db_User : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_User(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _password(""),
    _roles(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.User"; }

  grt::StringRef password() const { return _password; }
  virtual void password(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_password);
   _password= value;
    member_changed("password", ovalue, value);
  }

  grt::ListRef<db_Role> roles() const { return _roles; }
private: // the next attribute is read-only
  virtual void roles(const grt::ListRef<db_Role> &value)
  {
    grt::ValueRef ovalue(_roles);
   _roles= value;
    member_changed("roles", ovalue, value);
  }
public:

protected:

  grt::StringRef _password;
  grt::ListRef<db_Role> _roles;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_User(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_User::create);
    {
      void (db_User::*setter)(const grt::StringRef &)= &db_User::password;
      grt::StringRef (db_User::*getter)() const= &db_User::password;
      meta->bind_member("password", new grt::MetaClass::Property<db_User,grt::StringRef >(getter,setter));
    }
    {
      void (db_User::*setter)(const grt::ListRef<db_Role> &)= &db_User::roles;
      grt::ListRef<db_Role> (db_User::*getter)() const= &db_User::roles;
      meta->bind_member("roles", new grt::MetaClass::Property<db_User,grt::ListRef<db_Role> >(getter,setter));
    }
  }
};


class  db_Role : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_Role(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _childRoles(grt, this, false),
    _privileges(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.Role"; }

  grt::ListRef<db_Role> childRoles() const { return _childRoles; }
private: // the next attribute is read-only
  virtual void childRoles(const grt::ListRef<db_Role> &value)
  {
    grt::ValueRef ovalue(_childRoles);
   _childRoles= value;
    member_changed("childRoles", ovalue, value);
  }
public:

  db_RoleRef parentRole() const { return _parentRole; }
  virtual void parentRole(const db_RoleRef &value)
  {
    grt::ValueRef ovalue(_parentRole);
   _parentRole= value;
    member_changed("parentRole", ovalue, value);
  }

  // privileges is owned by db_Role
  grt::ListRef<db_RolePrivilege> privileges() const { return _privileges; }
private: // the next attribute is read-only
  virtual void privileges(const grt::ListRef<db_RolePrivilege> &value)
  {
    grt::ValueRef ovalue(_privileges);

    _privileges= value;
    owned_member_changed("privileges", ovalue, value);
  }
public:

protected:

  grt::ListRef<db_Role> _childRoles;
  db_RoleRef _parentRole;
  grt::ListRef<db_RolePrivilege> _privileges;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Role(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Role::create);
    {
      void (db_Role::*setter)(const grt::ListRef<db_Role> &)= &db_Role::childRoles;
      grt::ListRef<db_Role> (db_Role::*getter)() const= &db_Role::childRoles;
      meta->bind_member("childRoles", new grt::MetaClass::Property<db_Role,grt::ListRef<db_Role> >(getter,setter));
    }
    {
      void (db_Role::*setter)(const db_RoleRef &)= &db_Role::parentRole;
      db_RoleRef (db_Role::*getter)() const= &db_Role::parentRole;
      meta->bind_member("parentRole", new grt::MetaClass::Property<db_Role,db_RoleRef >(getter,setter));
    }
    {
      void (db_Role::*setter)(const grt::ListRef<db_RolePrivilege> &)= &db_Role::privileges;
      grt::ListRef<db_RolePrivilege> (db_Role::*getter)() const= &db_Role::privileges;
      meta->bind_member("privileges", new grt::MetaClass::Property<db_Role,grt::ListRef<db_RolePrivilege> >(getter,setter));
    }
  }
};


class  db_DatabaseDdlObject : public db_DatabaseObject
{
  typedef db_DatabaseObject super;
public:
  db_DatabaseDdlObject(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _oldModelSqlDefinition(""),
     _oldServerSqlDefinition(""),
     _sqlDefinition("")

  {
  }

  static std::string static_class_name() { return "db.DatabaseDdlObject"; }

  grt::StringRef oldModelSqlDefinition() const { return _oldModelSqlDefinition; }
  virtual void oldModelSqlDefinition(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_oldModelSqlDefinition);
   _oldModelSqlDefinition= value;
    member_changed("oldModelSqlDefinition", ovalue, value);
  }

  grt::StringRef oldServerSqlDefinition() const { return _oldServerSqlDefinition; }
  virtual void oldServerSqlDefinition(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_oldServerSqlDefinition);
   _oldServerSqlDefinition= value;
    member_changed("oldServerSqlDefinition", ovalue, value);
  }

  grt::StringRef sqlDefinition() const { return _sqlDefinition; }
  virtual void sqlDefinition(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_sqlDefinition);
   _sqlDefinition= value;
    member_changed("sqlDefinition", ovalue, value);
  }

protected:

  grt::StringRef _oldModelSqlDefinition;
  grt::StringRef _oldServerSqlDefinition;
  grt::StringRef _sqlDefinition;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_DatabaseDdlObject(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_DatabaseDdlObject::create);
    {
      void (db_DatabaseDdlObject::*setter)(const grt::StringRef &)= &db_DatabaseDdlObject::oldModelSqlDefinition;
      grt::StringRef (db_DatabaseDdlObject::*getter)() const= &db_DatabaseDdlObject::oldModelSqlDefinition;
      meta->bind_member("oldModelSqlDefinition", new grt::MetaClass::Property<db_DatabaseDdlObject,grt::StringRef >(getter,setter));
    }
    {
      void (db_DatabaseDdlObject::*setter)(const grt::StringRef &)= &db_DatabaseDdlObject::oldServerSqlDefinition;
      grt::StringRef (db_DatabaseDdlObject::*getter)() const= &db_DatabaseDdlObject::oldServerSqlDefinition;
      meta->bind_member("oldServerSqlDefinition", new grt::MetaClass::Property<db_DatabaseDdlObject,grt::StringRef >(getter,setter));
    }
    {
      void (db_DatabaseDdlObject::*setter)(const grt::StringRef &)= &db_DatabaseDdlObject::sqlDefinition;
      grt::StringRef (db_DatabaseDdlObject::*getter)() const= &db_DatabaseDdlObject::sqlDefinition;
      meta->bind_member("sqlDefinition", new grt::MetaClass::Property<db_DatabaseDdlObject,grt::StringRef >(getter,setter));
    }
  }
};


class  db_Trigger : public db_DatabaseDdlObject
{
  typedef db_DatabaseDdlObject super;
public:
  db_Trigger(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseDdlObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _condition(""),
     _definer(""),
     _enabled(0),
     _event(""),
     _order(0),
     _orientation(""),
     _referenceNewRow(""),
     _referenceNewTable(""),
     _referenceOldRow(""),
     _referenceOldTable(""),
     _sequenceNumber(0),
     _timing("")

  {
  }

  static std::string static_class_name() { return "db.Trigger"; }

  grt::StringRef condition() const { return _condition; }
  virtual void condition(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_condition);
   _condition= value;
    member_changed("condition", ovalue, value);
  }

  grt::StringRef definer() const { return _definer; }
  virtual void definer(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_definer);
   _definer= value;
    member_changed("definer", ovalue, value);
  }

  grt::IntegerRef enabled() const { return _enabled; }
  virtual void enabled(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_enabled);
   _enabled= value;
    member_changed("enabled", ovalue, value);
  }

  grt::StringRef event() const { return _event; }
  virtual void event(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_event);
   _event= value;
    member_changed("event", ovalue, value);
  }

  grt::IntegerRef order() const { return _order; }
  virtual void order(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_order);
   _order= value;
    member_changed("order", ovalue, value);
  }

  grt::StringRef orientation() const { return _orientation; }
  virtual void orientation(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_orientation);
   _orientation= value;
    member_changed("orientation", ovalue, value);
  }

  grt::StringRef referenceNewRow() const { return _referenceNewRow; }
  virtual void referenceNewRow(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_referenceNewRow);
   _referenceNewRow= value;
    member_changed("referenceNewRow", ovalue, value);
  }

  grt::StringRef referenceNewTable() const { return _referenceNewTable; }
  virtual void referenceNewTable(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_referenceNewTable);
   _referenceNewTable= value;
    member_changed("referenceNewTable", ovalue, value);
  }

  grt::StringRef referenceOldRow() const { return _referenceOldRow; }
  virtual void referenceOldRow(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_referenceOldRow);
   _referenceOldRow= value;
    member_changed("referenceOldRow", ovalue, value);
  }

  grt::StringRef referenceOldTable() const { return _referenceOldTable; }
  virtual void referenceOldTable(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_referenceOldTable);
   _referenceOldTable= value;
    member_changed("referenceOldTable", ovalue, value);
  }

  grt::IntegerRef sequenceNumber() const { return _sequenceNumber; }
  virtual void sequenceNumber(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_sequenceNumber);
   _sequenceNumber= value;
    member_changed("sequenceNumber", ovalue, value);
  }

  grt::StringRef timing() const { return _timing; }
  virtual void timing(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_timing);
   _timing= value;
    member_changed("timing", ovalue, value);
  }

protected:

  grt::StringRef _condition;
  grt::StringRef _definer;
  grt::IntegerRef _enabled;
  grt::StringRef _event;
  grt::IntegerRef _order;
  grt::StringRef _orientation;
  grt::StringRef _referenceNewRow;
  grt::StringRef _referenceNewTable;
  grt::StringRef _referenceOldRow;
  grt::StringRef _referenceOldTable;
  grt::IntegerRef _sequenceNumber;
  grt::StringRef _timing;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Trigger(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Trigger::create);
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::condition;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::condition;
      meta->bind_member("condition", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::definer;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::definer;
      meta->bind_member("definer", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::IntegerRef &)= &db_Trigger::enabled;
      grt::IntegerRef (db_Trigger::*getter)() const= &db_Trigger::enabled;
      meta->bind_member("enabled", new grt::MetaClass::Property<db_Trigger,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::event;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::event;
      meta->bind_member("event", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::IntegerRef &)= &db_Trigger::order;
      grt::IntegerRef (db_Trigger::*getter)() const= &db_Trigger::order;
      meta->bind_member("order", new grt::MetaClass::Property<db_Trigger,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::orientation;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::orientation;
      meta->bind_member("orientation", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::referenceNewRow;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::referenceNewRow;
      meta->bind_member("referenceNewRow", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::referenceNewTable;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::referenceNewTable;
      meta->bind_member("referenceNewTable", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::referenceOldRow;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::referenceOldRow;
      meta->bind_member("referenceOldRow", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::referenceOldTable;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::referenceOldTable;
      meta->bind_member("referenceOldTable", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::IntegerRef &)= &db_Trigger::sequenceNumber;
      grt::IntegerRef (db_Trigger::*getter)() const= &db_Trigger::sequenceNumber;
      meta->bind_member("sequenceNumber", new grt::MetaClass::Property<db_Trigger,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_Trigger::*setter)(const grt::StringRef &)= &db_Trigger::timing;
      grt::StringRef (db_Trigger::*getter)() const= &db_Trigger::timing;
      meta->bind_member("timing", new grt::MetaClass::Property<db_Trigger,grt::StringRef >(getter,setter));
    }
  }
};


class  db_Routine : public db_DatabaseDdlObject
{
  typedef db_DatabaseDdlObject super;
public:
  db_Routine(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseDdlObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _routineType(""),
     _sequenceNumber(0)

  {
  }

  static std::string static_class_name() { return "db.Routine"; }

private: // the next attribute is read-only
public:

  grt::StringRef routineType() const { return _routineType; }
  virtual void routineType(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_routineType);
   _routineType= value;
    member_changed("routineType", ovalue, value);
  }

  grt::IntegerRef sequenceNumber() const { return _sequenceNumber; }
  virtual void sequenceNumber(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_sequenceNumber);
   _sequenceNumber= value;
    member_changed("sequenceNumber", ovalue, value);
  }

protected:

  grt::StringRef _routineType;
  grt::IntegerRef _sequenceNumber;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_Routine(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_Routine::create);
    {
      void (db_Routine::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_Routine::*getter)() const= 0;
      meta->bind_member("name", new grt::MetaClass::Property<db_Routine,grt::StringRef >(getter,setter));
    }
    {
      void (db_Routine::*setter)(const grt::StringRef &)= &db_Routine::routineType;
      grt::StringRef (db_Routine::*getter)() const= &db_Routine::routineType;
      meta->bind_member("routineType", new grt::MetaClass::Property<db_Routine,grt::StringRef >(getter,setter));
    }
    {
      void (db_Routine::*setter)(const grt::IntegerRef &)= &db_Routine::sequenceNumber;
      grt::IntegerRef (db_Routine::*getter)() const= &db_Routine::sequenceNumber;
      meta->bind_member("sequenceNumber", new grt::MetaClass::Property<db_Routine,grt::IntegerRef >(getter,setter));
    }
  }
};


class  db_View : public db_DatabaseDdlObject
{
  typedef db_DatabaseDdlObject super;
public:
  db_View(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_DatabaseDdlObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _columns(grt, this, false),
     _isReadOnly(0),
     _withCheckCondition(0)

  {
  }

  static std::string static_class_name() { return "db.View"; }

  grt::StringListRef columns() const { return _columns; }
private: // the next attribute is read-only
  virtual void columns(const grt::StringListRef &value)
  {
    grt::ValueRef ovalue(_columns);
   _columns= value;
    member_changed("columns", ovalue, value);
  }
public:

  grt::IntegerRef isReadOnly() const { return _isReadOnly; }
  virtual void isReadOnly(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isReadOnly);
   _isReadOnly= value;
    member_changed("isReadOnly", ovalue, value);
  }

private: // the next attribute is read-only
public:

  grt::IntegerRef withCheckCondition() const { return _withCheckCondition; }
  virtual void withCheckCondition(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_withCheckCondition);
   _withCheckCondition= value;
    member_changed("withCheckCondition", ovalue, value);
  }

protected:

  grt::StringListRef _columns;
  grt::IntegerRef _isReadOnly;
  grt::IntegerRef _withCheckCondition;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_View(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_View::create);
    {
      void (db_View::*setter)(const grt::StringListRef &)= &db_View::columns;
      grt::StringListRef (db_View::*getter)() const= &db_View::columns;
      meta->bind_member("columns", new grt::MetaClass::Property<db_View,grt::StringListRef >(getter,setter));
    }
    {
      void (db_View::*setter)(const grt::IntegerRef &)= &db_View::isReadOnly;
      grt::IntegerRef (db_View::*getter)() const= &db_View::isReadOnly;
      meta->bind_member("isReadOnly", new grt::MetaClass::Property<db_View,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_View::*setter)(const grt::StringRef &)= 0;
      grt::StringRef (db_View::*getter)() const= 0;
      meta->bind_member("name", new grt::MetaClass::Property<db_View,grt::StringRef >(getter,setter));
    }
    {
      void (db_View::*setter)(const grt::IntegerRef &)= &db_View::withCheckCondition;
      grt::IntegerRef (db_View::*getter)() const= &db_View::withCheckCondition;
      meta->bind_member("withCheckCondition", new grt::MetaClass::Property<db_View,grt::IntegerRef >(getter,setter));
    }
  }
};




inline void register_structs_db_xml()
{
  grt::internal::ClassRegistry::register_class<db_DatabaseSyncObject>();
  grt::internal::ClassRegistry::register_class<db_DatabaseSync>();
  grt::internal::ClassRegistry::register_class<db_Script>();
  grt::internal::ClassRegistry::register_class<db_CharacterSet>();
  grt::internal::ClassRegistry::register_class<db_ForeignKey>();
  grt::internal::ClassRegistry::register_class<db_IndexColumn>();
  grt::internal::ClassRegistry::register_class<db_Index>();
  grt::internal::ClassRegistry::register_class<db_CheckConstraint>();
  grt::internal::ClassRegistry::register_class<db_UserDatatype>();
  grt::internal::ClassRegistry::register_class<db_SimpleDatatype>();
  grt::internal::ClassRegistry::register_class<db_DatatypeGroup>();
  grt::internal::ClassRegistry::register_class<db_Column>();
  grt::internal::ClassRegistry::register_class<db_Tablespace>();
  grt::internal::ClassRegistry::register_class<db_LogFileGroup>();
  grt::internal::ClassRegistry::register_class<db_RolePrivilege>();
  grt::internal::ClassRegistry::register_class<db_Catalog>();
  grt::internal::ClassRegistry::register_class<db_DatabaseObject>();
  grt::internal::ClassRegistry::register_class<db_Sequence>();
  grt::internal::ClassRegistry::register_class<db_Synonym>();
  grt::internal::ClassRegistry::register_class<db_RoutineGroup>();
  grt::internal::ClassRegistry::register_class<db_StructuredDatatype>();
  grt::internal::ClassRegistry::register_class<db_Table>();
  grt::internal::ClassRegistry::register_class<db_ServerLink>();
  grt::internal::ClassRegistry::register_class<db_Schema>();
  grt::internal::ClassRegistry::register_class<db_User>();
  grt::internal::ClassRegistry::register_class<db_Role>();
  grt::internal::ClassRegistry::register_class<db_DatabaseDdlObject>();
  grt::internal::ClassRegistry::register_class<db_Trigger>();
  grt::internal::ClassRegistry::register_class<db_Routine>();
  grt::internal::ClassRegistry::register_class<db_View>();
}

#ifdef AUTO_REGISTER_GRT_CLASSES
static struct _autoreg__structs_db_xml { _autoreg__structs_db_xml() { register_structs_db_xml(); } } __autoreg__structs_db_xml;
#endif

#endif
