#ifndef __grts_structs_db_mgmt_h__
#define __grts_structs_db_mgmt_h__

#include <grtpp.h>

#ifdef _WIN32
  #pragma warning(disable: 4355) // 'this' : used in base member initizalizer list
  #ifdef GRT_STRUCTS_DB_MGMT_EXPORT
  #define GRT_STRUCTS_DB_MGMT_PUBLIC __declspec(dllexport)
#else
  #define GRT_STRUCTS_DB_MGMT_PUBLIC __declspec(dllimport)
#endif
#else
  #define GRT_STRUCTS_DB_MGMT_PUBLIC
#endif

#include <grts/structs.h>
#include <grts/structs.db.h>


class db_mgmt_ServerInstance;
typedef grt::Ref<db_mgmt_ServerInstance> db_mgmt_ServerInstanceRef;
class db_mgmt_Connection;
typedef grt::Ref<db_mgmt_Connection> db_mgmt_ConnectionRef;
class db_mgmt_DriverParameter;
typedef grt::Ref<db_mgmt_DriverParameter> db_mgmt_DriverParameterRef;
class db_mgmt_Driver;
typedef grt::Ref<db_mgmt_Driver> db_mgmt_DriverRef;
class db_mgmt_JdbcDriver;
typedef grt::Ref<db_mgmt_JdbcDriver> db_mgmt_JdbcDriverRef;
class db_mgmt_PrivilegeMapping;
typedef grt::Ref<db_mgmt_PrivilegeMapping> db_mgmt_PrivilegeMappingRef;
class db_mgmt_Rdbms;
typedef grt::Ref<db_mgmt_Rdbms> db_mgmt_RdbmsRef;
class db_mgmt_Management;
typedef grt::Ref<db_mgmt_Management> db_mgmt_ManagementRef;


class  db_mgmt_ServerInstance : public GrtObject
{
  typedef GrtObject super;
public:
  db_mgmt_ServerInstance(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _loginInfo(grt, this, false),
    _serverInfo(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.mgmt.ServerInstance"; }

  db_mgmt_ConnectionRef connection() const { return _connection; }
  virtual void connection(const db_mgmt_ConnectionRef &value)
  {
    grt::ValueRef ovalue(_connection);
   _connection= value;
    member_changed("connection", ovalue, value);
  }

  grt::DictRef loginInfo() const { return _loginInfo; }
private: // the next attribute is read-only
  virtual void loginInfo(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_loginInfo);
   _loginInfo= value;
    member_changed("loginInfo", ovalue, value);
  }
public:

  grt::DictRef serverInfo() const { return _serverInfo; }
private: // the next attribute is read-only
  virtual void serverInfo(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_serverInfo);
   _serverInfo= value;
    member_changed("serverInfo", ovalue, value);
  }
public:

protected:

  db_mgmt_ConnectionRef _connection;
  grt::DictRef _loginInfo;
  grt::DictRef _serverInfo;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_mgmt_ServerInstance(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_mgmt_ServerInstance::create);
    {
      void (db_mgmt_ServerInstance::*setter)(const db_mgmt_ConnectionRef &)= &db_mgmt_ServerInstance::connection;
      db_mgmt_ConnectionRef (db_mgmt_ServerInstance::*getter)() const= &db_mgmt_ServerInstance::connection;
      meta->bind_member("connection", new grt::MetaClass::Property<db_mgmt_ServerInstance,db_mgmt_ConnectionRef >(getter,setter));
    }
    {
      void (db_mgmt_ServerInstance::*setter)(const grt::DictRef &)= &db_mgmt_ServerInstance::loginInfo;
      grt::DictRef (db_mgmt_ServerInstance::*getter)() const= &db_mgmt_ServerInstance::loginInfo;
      meta->bind_member("loginInfo", new grt::MetaClass::Property<db_mgmt_ServerInstance,grt::DictRef >(getter,setter));
    }
    {
      void (db_mgmt_ServerInstance::*setter)(const grt::DictRef &)= &db_mgmt_ServerInstance::serverInfo;
      grt::DictRef (db_mgmt_ServerInstance::*getter)() const= &db_mgmt_ServerInstance::serverInfo;
      meta->bind_member("serverInfo", new grt::MetaClass::Property<db_mgmt_ServerInstance,grt::DictRef >(getter,setter));
    }
  }
};


class  db_mgmt_Connection : public GrtObject
{
  typedef GrtObject super;
public:
  db_mgmt_Connection(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _hostIdentifier(""),
    _modules(grt, this, false),
    _parameterValues(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.mgmt.Connection"; }

  db_mgmt_DriverRef driver() const { return _driver; }
  virtual void driver(const db_mgmt_DriverRef &value)
  {
    grt::ValueRef ovalue(_driver);
   _driver= value;
    member_changed("driver", ovalue, value);
  }

  grt::StringRef hostIdentifier() const { return _hostIdentifier; }
  virtual void hostIdentifier(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_hostIdentifier);
   _hostIdentifier= value;
    member_changed("hostIdentifier", ovalue, value);
  }

  grt::DictRef modules() const { return _modules; }
private: // the next attribute is read-only
  virtual void modules(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_modules);
   _modules= value;
    member_changed("modules", ovalue, value);
  }
public:

  grt::DictRef parameterValues() const { return _parameterValues; }
private: // the next attribute is read-only
  virtual void parameterValues(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_parameterValues);
   _parameterValues= value;
    member_changed("parameterValues", ovalue, value);
  }
public:

protected:

  db_mgmt_DriverRef _driver;
  grt::StringRef _hostIdentifier;
  grt::DictRef _modules;
  grt::DictRef _parameterValues;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_mgmt_Connection(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_mgmt_Connection::create);
    {
      void (db_mgmt_Connection::*setter)(const db_mgmt_DriverRef &)= &db_mgmt_Connection::driver;
      db_mgmt_DriverRef (db_mgmt_Connection::*getter)() const= &db_mgmt_Connection::driver;
      meta->bind_member("driver", new grt::MetaClass::Property<db_mgmt_Connection,db_mgmt_DriverRef >(getter,setter));
    }
    {
      void (db_mgmt_Connection::*setter)(const grt::StringRef &)= &db_mgmt_Connection::hostIdentifier;
      grt::StringRef (db_mgmt_Connection::*getter)() const= &db_mgmt_Connection::hostIdentifier;
      meta->bind_member("hostIdentifier", new grt::MetaClass::Property<db_mgmt_Connection,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_Connection::*setter)(const grt::DictRef &)= &db_mgmt_Connection::modules;
      grt::DictRef (db_mgmt_Connection::*getter)() const= &db_mgmt_Connection::modules;
      meta->bind_member("modules", new grt::MetaClass::Property<db_mgmt_Connection,grt::DictRef >(getter,setter));
    }
    {
      void (db_mgmt_Connection::*setter)(const grt::DictRef &)= &db_mgmt_Connection::parameterValues;
      grt::DictRef (db_mgmt_Connection::*getter)() const= &db_mgmt_Connection::parameterValues;
      meta->bind_member("parameterValues", new grt::MetaClass::Property<db_mgmt_Connection,grt::DictRef >(getter,setter));
    }
  }
};


class  db_mgmt_DriverParameter : public GrtObject
{
  typedef GrtObject super;
public:
  db_mgmt_DriverParameter(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _caption(""),
     _defaultValue(""),
     _description(""),
     _layoutAdvanced(0),
     _layoutRow(0),
     _layoutWidth(0),
     _lookupValueMethod(""),
     _lookupValueModule(""),
     _paramType(""),
    _paramTypeDetails(grt, this, false),
     _required(0)

  {
  }

  static std::string static_class_name() { return "db.mgmt.DriverParameter"; }

  grt::StringRef caption() const { return _caption; }
  virtual void caption(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_caption);
   _caption= value;
    member_changed("caption", ovalue, value);
  }

  grt::StringRef defaultValue() const { return _defaultValue; }
  virtual void defaultValue(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_defaultValue);
   _defaultValue= value;
    member_changed("defaultValue", ovalue, value);
  }

  grt::StringRef description() const { return _description; }
  virtual void description(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_description);
   _description= value;
    member_changed("description", ovalue, value);
  }

  grt::IntegerRef layoutAdvanced() const { return _layoutAdvanced; }
  virtual void layoutAdvanced(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_layoutAdvanced);
   _layoutAdvanced= value;
    member_changed("layoutAdvanced", ovalue, value);
  }

  grt::IntegerRef layoutRow() const { return _layoutRow; }
  virtual void layoutRow(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_layoutRow);
   _layoutRow= value;
    member_changed("layoutRow", ovalue, value);
  }

  grt::IntegerRef layoutWidth() const { return _layoutWidth; }
  virtual void layoutWidth(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_layoutWidth);
   _layoutWidth= value;
    member_changed("layoutWidth", ovalue, value);
  }

  grt::StringRef lookupValueMethod() const { return _lookupValueMethod; }
  virtual void lookupValueMethod(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_lookupValueMethod);
   _lookupValueMethod= value;
    member_changed("lookupValueMethod", ovalue, value);
  }

  grt::StringRef lookupValueModule() const { return _lookupValueModule; }
  virtual void lookupValueModule(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_lookupValueModule);
   _lookupValueModule= value;
    member_changed("lookupValueModule", ovalue, value);
  }

  grt::StringRef paramType() const { return _paramType; }
  virtual void paramType(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_paramType);
   _paramType= value;
    member_changed("paramType", ovalue, value);
  }

  grt::DictRef paramTypeDetails() const { return _paramTypeDetails; }
private: // the next attribute is read-only
  virtual void paramTypeDetails(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_paramTypeDetails);
   _paramTypeDetails= value;
    member_changed("paramTypeDetails", ovalue, value);
  }
public:

  grt::IntegerRef required() const { return _required; }
  virtual void required(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_required);
   _required= value;
    member_changed("required", ovalue, value);
  }

protected:

  grt::StringRef _caption;
  grt::StringRef _defaultValue;
  grt::StringRef _description;
  grt::IntegerRef _layoutAdvanced;
  grt::IntegerRef _layoutRow;
  grt::IntegerRef _layoutWidth;
  grt::StringRef _lookupValueMethod;
  grt::StringRef _lookupValueModule;
  grt::StringRef _paramType;
  grt::DictRef _paramTypeDetails;
  grt::IntegerRef _required;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_mgmt_DriverParameter(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_mgmt_DriverParameter::create);
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::StringRef &)= &db_mgmt_DriverParameter::caption;
      grt::StringRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::caption;
      meta->bind_member("caption", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::StringRef &)= &db_mgmt_DriverParameter::defaultValue;
      grt::StringRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::defaultValue;
      meta->bind_member("defaultValue", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::StringRef &)= &db_mgmt_DriverParameter::description;
      grt::StringRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::description;
      meta->bind_member("description", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::IntegerRef &)= &db_mgmt_DriverParameter::layoutAdvanced;
      grt::IntegerRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::layoutAdvanced;
      meta->bind_member("layoutAdvanced", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::IntegerRef &)= &db_mgmt_DriverParameter::layoutRow;
      grt::IntegerRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::layoutRow;
      meta->bind_member("layoutRow", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::IntegerRef &)= &db_mgmt_DriverParameter::layoutWidth;
      grt::IntegerRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::layoutWidth;
      meta->bind_member("layoutWidth", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::StringRef &)= &db_mgmt_DriverParameter::lookupValueMethod;
      grt::StringRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::lookupValueMethod;
      meta->bind_member("lookupValueMethod", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::StringRef &)= &db_mgmt_DriverParameter::lookupValueModule;
      grt::StringRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::lookupValueModule;
      meta->bind_member("lookupValueModule", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::StringRef &)= &db_mgmt_DriverParameter::paramType;
      grt::StringRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::paramType;
      meta->bind_member("paramType", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::DictRef &)= &db_mgmt_DriverParameter::paramTypeDetails;
      grt::DictRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::paramTypeDetails;
      meta->bind_member("paramTypeDetails", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::DictRef >(getter,setter));
    }
    {
      void (db_mgmt_DriverParameter::*setter)(const grt::IntegerRef &)= &db_mgmt_DriverParameter::required;
      grt::IntegerRef (db_mgmt_DriverParameter::*getter)() const= &db_mgmt_DriverParameter::required;
      meta->bind_member("required", new grt::MetaClass::Property<db_mgmt_DriverParameter,grt::IntegerRef >(getter,setter));
    }
  }
};


class  db_mgmt_Driver : public GrtObject
{
  typedef GrtObject super;
public:
  db_mgmt_Driver(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _caption(""),
    _defaultModules(grt, this, false),
     _description(""),
     _downloadUrl(""),
     _driverLibraryName(""),
    _files(grt, this, false),
     _filesTarget(""),
     _isAccessable(0),
     _isInstalled(0),
    _parameters(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.mgmt.Driver"; }

  grt::StringRef caption() const { return _caption; }
  virtual void caption(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_caption);
   _caption= value;
    member_changed("caption", ovalue, value);
  }

  grt::DictRef defaultModules() const { return _defaultModules; }
private: // the next attribute is read-only
  virtual void defaultModules(const grt::DictRef &value)
  {
    grt::ValueRef ovalue(_defaultModules);
   _defaultModules= value;
    member_changed("defaultModules", ovalue, value);
  }
public:

  grt::StringRef description() const { return _description; }
  virtual void description(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_description);
   _description= value;
    member_changed("description", ovalue, value);
  }

  grt::StringRef downloadUrl() const { return _downloadUrl; }
  virtual void downloadUrl(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_downloadUrl);
   _downloadUrl= value;
    member_changed("downloadUrl", ovalue, value);
  }

  grt::StringRef driverLibraryName() const { return _driverLibraryName; }
  virtual void driverLibraryName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_driverLibraryName);
   _driverLibraryName= value;
    member_changed("driverLibraryName", ovalue, value);
  }

  grt::StringListRef files() const { return _files; }
private: // the next attribute is read-only
  virtual void files(const grt::StringListRef &value)
  {
    grt::ValueRef ovalue(_files);
   _files= value;
    member_changed("files", ovalue, value);
  }
public:

  grt::StringRef filesTarget() const { return _filesTarget; }
  virtual void filesTarget(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_filesTarget);
   _filesTarget= value;
    member_changed("filesTarget", ovalue, value);
  }

  grt::IntegerRef isAccessable() const { return _isAccessable; }
  virtual void isAccessable(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isAccessable);
   _isAccessable= value;
    member_changed("isAccessable", ovalue, value);
  }

  grt::IntegerRef isInstalled() const { return _isInstalled; }
  virtual void isInstalled(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isInstalled);
   _isInstalled= value;
    member_changed("isInstalled", ovalue, value);
  }

  // parameters is owned by db_mgmt_Driver
  grt::ListRef<db_mgmt_DriverParameter> parameters() const { return _parameters; }
private: // the next attribute is read-only
  virtual void parameters(const grt::ListRef<db_mgmt_DriverParameter> &value)
  {
    grt::ValueRef ovalue(_parameters);

    _parameters= value;
    owned_member_changed("parameters", ovalue, value);
  }
public:

protected:

  grt::StringRef _caption;
  grt::DictRef _defaultModules;
  grt::StringRef _description;
  grt::StringRef _downloadUrl;
  grt::StringRef _driverLibraryName;
  grt::StringListRef _files;
  grt::StringRef _filesTarget;
  grt::IntegerRef _isAccessable;
  grt::IntegerRef _isInstalled;
  grt::ListRef<db_mgmt_DriverParameter> _parameters;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_mgmt_Driver(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_mgmt_Driver::create);
    {
      void (db_mgmt_Driver::*setter)(const grt::StringRef &)= &db_mgmt_Driver::caption;
      grt::StringRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::caption;
      meta->bind_member("caption", new grt::MetaClass::Property<db_mgmt_Driver,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::DictRef &)= &db_mgmt_Driver::defaultModules;
      grt::DictRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::defaultModules;
      meta->bind_member("defaultModules", new grt::MetaClass::Property<db_mgmt_Driver,grt::DictRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::StringRef &)= &db_mgmt_Driver::description;
      grt::StringRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::description;
      meta->bind_member("description", new grt::MetaClass::Property<db_mgmt_Driver,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::StringRef &)= &db_mgmt_Driver::downloadUrl;
      grt::StringRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::downloadUrl;
      meta->bind_member("downloadUrl", new grt::MetaClass::Property<db_mgmt_Driver,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::StringRef &)= &db_mgmt_Driver::driverLibraryName;
      grt::StringRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::driverLibraryName;
      meta->bind_member("driverLibraryName", new grt::MetaClass::Property<db_mgmt_Driver,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::StringListRef &)= &db_mgmt_Driver::files;
      grt::StringListRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::files;
      meta->bind_member("files", new grt::MetaClass::Property<db_mgmt_Driver,grt::StringListRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::StringRef &)= &db_mgmt_Driver::filesTarget;
      grt::StringRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::filesTarget;
      meta->bind_member("filesTarget", new grt::MetaClass::Property<db_mgmt_Driver,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::IntegerRef &)= &db_mgmt_Driver::isAccessable;
      grt::IntegerRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::isAccessable;
      meta->bind_member("isAccessable", new grt::MetaClass::Property<db_mgmt_Driver,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::IntegerRef &)= &db_mgmt_Driver::isInstalled;
      grt::IntegerRef (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::isInstalled;
      meta->bind_member("isInstalled", new grt::MetaClass::Property<db_mgmt_Driver,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_mgmt_Driver::*setter)(const grt::ListRef<db_mgmt_DriverParameter> &)= &db_mgmt_Driver::parameters;
      grt::ListRef<db_mgmt_DriverParameter> (db_mgmt_Driver::*getter)() const= &db_mgmt_Driver::parameters;
      meta->bind_member("parameters", new grt::MetaClass::Property<db_mgmt_Driver,grt::ListRef<db_mgmt_DriverParameter> >(getter,setter));
    }
  }
};


class  db_mgmt_JdbcDriver : public db_mgmt_Driver
{
  typedef db_mgmt_Driver super;
public:
  db_mgmt_JdbcDriver(grt::GRT *grt, grt::MetaClass *meta=0)
  : db_mgmt_Driver(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _className(""),
     _connectionStringTemplate("")

  {
  }

  static std::string static_class_name() { return "db.mgmt.JdbcDriver"; }

  grt::StringRef className() const { return _className; }
  virtual void className(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_className);
   _className= value;
    member_changed("className", ovalue, value);
  }

  grt::StringRef connectionStringTemplate() const { return _connectionStringTemplate; }
  virtual void connectionStringTemplate(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_connectionStringTemplate);
   _connectionStringTemplate= value;
    member_changed("connectionStringTemplate", ovalue, value);
  }

protected:

  grt::StringRef _className;
  grt::StringRef _connectionStringTemplate;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_mgmt_JdbcDriver(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_mgmt_JdbcDriver::create);
    {
      void (db_mgmt_JdbcDriver::*setter)(const grt::StringRef &)= &db_mgmt_JdbcDriver::className;
      grt::StringRef (db_mgmt_JdbcDriver::*getter)() const= &db_mgmt_JdbcDriver::className;
      meta->bind_member("className", new grt::MetaClass::Property<db_mgmt_JdbcDriver,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_JdbcDriver::*setter)(const grt::StringRef &)= &db_mgmt_JdbcDriver::connectionStringTemplate;
      grt::StringRef (db_mgmt_JdbcDriver::*getter)() const= &db_mgmt_JdbcDriver::connectionStringTemplate;
      meta->bind_member("connectionStringTemplate", new grt::MetaClass::Property<db_mgmt_JdbcDriver,grt::StringRef >(getter,setter));
    }
  }
};


class  db_mgmt_PrivilegeMapping : public GrtObject
{
  typedef GrtObject super;
public:
  db_mgmt_PrivilegeMapping(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _privileges(grt, this, false),
     _structName("")

  {
  }

  static std::string static_class_name() { return "db.mgmt.PrivilegeMapping"; }

  grt::StringListRef privileges() const { return _privileges; }
private: // the next attribute is read-only
  virtual void privileges(const grt::StringListRef &value)
  {
    grt::ValueRef ovalue(_privileges);
   _privileges= value;
    member_changed("privileges", ovalue, value);
  }
public:

  grt::StringRef structName() const { return _structName; }
  virtual void structName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_structName);
   _structName= value;
    member_changed("structName", ovalue, value);
  }

protected:

  grt::StringListRef _privileges;
  grt::StringRef _structName;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_mgmt_PrivilegeMapping(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_mgmt_PrivilegeMapping::create);
    {
      void (db_mgmt_PrivilegeMapping::*setter)(const grt::StringListRef &)= &db_mgmt_PrivilegeMapping::privileges;
      grt::StringListRef (db_mgmt_PrivilegeMapping::*getter)() const= &db_mgmt_PrivilegeMapping::privileges;
      meta->bind_member("privileges", new grt::MetaClass::Property<db_mgmt_PrivilegeMapping,grt::StringListRef >(getter,setter));
    }
    {
      void (db_mgmt_PrivilegeMapping::*setter)(const grt::StringRef &)= &db_mgmt_PrivilegeMapping::structName;
      grt::StringRef (db_mgmt_PrivilegeMapping::*getter)() const= &db_mgmt_PrivilegeMapping::structName;
      meta->bind_member("structName", new grt::MetaClass::Property<db_mgmt_PrivilegeMapping,grt::StringRef >(getter,setter));
    }
  }
};


class  db_mgmt_Rdbms : public GrtObject
{
  typedef GrtObject super;
public:
  db_mgmt_Rdbms(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _caption(""),
    _characterSets(grt, this, false),
     _databaseObjectPackage(""),
    _drivers(grt, this, false),
     _maximumIdentifierLength(0),
    _privilegeNames(grt, this, false),
    _simpleDatatypes(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.mgmt.Rdbms"; }

  grt::StringRef caption() const { return _caption; }
  virtual void caption(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_caption);
   _caption= value;
    member_changed("caption", ovalue, value);
  }

  // characterSets is owned by db_mgmt_Rdbms
  grt::ListRef<db_CharacterSet> characterSets() const { return _characterSets; }
private: // the next attribute is read-only
  virtual void characterSets(const grt::ListRef<db_CharacterSet> &value)
  {
    grt::ValueRef ovalue(_characterSets);

    _characterSets= value;
    owned_member_changed("characterSets", ovalue, value);
  }
public:

  grt::StringRef databaseObjectPackage() const { return _databaseObjectPackage; }
  virtual void databaseObjectPackage(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_databaseObjectPackage);
   _databaseObjectPackage= value;
    member_changed("databaseObjectPackage", ovalue, value);
  }

  db_mgmt_DriverRef defaultDriver() const { return _defaultDriver; }
  virtual void defaultDriver(const db_mgmt_DriverRef &value)
  {
    grt::ValueRef ovalue(_defaultDriver);
   _defaultDriver= value;
    member_changed("defaultDriver", ovalue, value);
  }

  // drivers is owned by db_mgmt_Rdbms
  grt::ListRef<db_mgmt_Driver> drivers() const { return _drivers; }
private: // the next attribute is read-only
  virtual void drivers(const grt::ListRef<db_mgmt_Driver> &value)
  {
    grt::ValueRef ovalue(_drivers);

    _drivers= value;
    owned_member_changed("drivers", ovalue, value);
  }
public:

  grt::IntegerRef maximumIdentifierLength() const { return _maximumIdentifierLength; }
  virtual void maximumIdentifierLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_maximumIdentifierLength);
   _maximumIdentifierLength= value;
    member_changed("maximumIdentifierLength", ovalue, value);
  }

  // privilegeNames is owned by db_mgmt_Rdbms
  grt::ListRef<db_mgmt_PrivilegeMapping> privilegeNames() const { return _privilegeNames; }
private: // the next attribute is read-only
  virtual void privilegeNames(const grt::ListRef<db_mgmt_PrivilegeMapping> &value)
  {
    grt::ValueRef ovalue(_privilegeNames);

    _privilegeNames= value;
    owned_member_changed("privilegeNames", ovalue, value);
  }
public:

  // simpleDatatypes is owned by db_mgmt_Rdbms
  grt::ListRef<db_SimpleDatatype> simpleDatatypes() const { return _simpleDatatypes; }
private: // the next attribute is read-only
  virtual void simpleDatatypes(const grt::ListRef<db_SimpleDatatype> &value)
  {
    grt::ValueRef ovalue(_simpleDatatypes);

    _simpleDatatypes= value;
    owned_member_changed("simpleDatatypes", ovalue, value);
  }
public:

  // version is owned by db_mgmt_Rdbms
  GrtVersionRef version() const { return _version; }
  virtual void version(const GrtVersionRef &value)
  {
    grt::ValueRef ovalue(_version);

    _version= value;
    owned_member_changed("version", ovalue, value);
  }

protected:

  grt::StringRef _caption;
  grt::ListRef<db_CharacterSet> _characterSets;// owned
  grt::StringRef _databaseObjectPackage;
  db_mgmt_DriverRef _defaultDriver;
  grt::ListRef<db_mgmt_Driver> _drivers;// owned
  grt::IntegerRef _maximumIdentifierLength;
  grt::ListRef<db_mgmt_PrivilegeMapping> _privilegeNames;// owned
  grt::ListRef<db_SimpleDatatype> _simpleDatatypes;// owned
  GrtVersionRef _version;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_mgmt_Rdbms(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_mgmt_Rdbms::create);
    {
      void (db_mgmt_Rdbms::*setter)(const grt::StringRef &)= &db_mgmt_Rdbms::caption;
      grt::StringRef (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::caption;
      meta->bind_member("caption", new grt::MetaClass::Property<db_mgmt_Rdbms,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_Rdbms::*setter)(const grt::ListRef<db_CharacterSet> &)= &db_mgmt_Rdbms::characterSets;
      grt::ListRef<db_CharacterSet> (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::characterSets;
      meta->bind_member("characterSets", new grt::MetaClass::Property<db_mgmt_Rdbms,grt::ListRef<db_CharacterSet> >(getter,setter));
    }
    {
      void (db_mgmt_Rdbms::*setter)(const grt::StringRef &)= &db_mgmt_Rdbms::databaseObjectPackage;
      grt::StringRef (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::databaseObjectPackage;
      meta->bind_member("databaseObjectPackage", new grt::MetaClass::Property<db_mgmt_Rdbms,grt::StringRef >(getter,setter));
    }
    {
      void (db_mgmt_Rdbms::*setter)(const db_mgmt_DriverRef &)= &db_mgmt_Rdbms::defaultDriver;
      db_mgmt_DriverRef (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::defaultDriver;
      meta->bind_member("defaultDriver", new grt::MetaClass::Property<db_mgmt_Rdbms,db_mgmt_DriverRef >(getter,setter));
    }
    {
      void (db_mgmt_Rdbms::*setter)(const grt::ListRef<db_mgmt_Driver> &)= &db_mgmt_Rdbms::drivers;
      grt::ListRef<db_mgmt_Driver> (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::drivers;
      meta->bind_member("drivers", new grt::MetaClass::Property<db_mgmt_Rdbms,grt::ListRef<db_mgmt_Driver> >(getter,setter));
    }
    {
      void (db_mgmt_Rdbms::*setter)(const grt::IntegerRef &)= &db_mgmt_Rdbms::maximumIdentifierLength;
      grt::IntegerRef (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::maximumIdentifierLength;
      meta->bind_member("maximumIdentifierLength", new grt::MetaClass::Property<db_mgmt_Rdbms,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_mgmt_Rdbms::*setter)(const grt::ListRef<db_mgmt_PrivilegeMapping> &)= &db_mgmt_Rdbms::privilegeNames;
      grt::ListRef<db_mgmt_PrivilegeMapping> (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::privilegeNames;
      meta->bind_member("privilegeNames", new grt::MetaClass::Property<db_mgmt_Rdbms,grt::ListRef<db_mgmt_PrivilegeMapping> >(getter,setter));
    }
    {
      void (db_mgmt_Rdbms::*setter)(const grt::ListRef<db_SimpleDatatype> &)= &db_mgmt_Rdbms::simpleDatatypes;
      grt::ListRef<db_SimpleDatatype> (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::simpleDatatypes;
      meta->bind_member("simpleDatatypes", new grt::MetaClass::Property<db_mgmt_Rdbms,grt::ListRef<db_SimpleDatatype> >(getter,setter));
    }
    {
      void (db_mgmt_Rdbms::*setter)(const GrtVersionRef &)= &db_mgmt_Rdbms::version;
      GrtVersionRef (db_mgmt_Rdbms::*getter)() const= &db_mgmt_Rdbms::version;
      meta->bind_member("version", new grt::MetaClass::Property<db_mgmt_Rdbms,GrtVersionRef >(getter,setter));
    }
  }
};


class  db_mgmt_Management : public GrtObject
{
  typedef GrtObject super;
public:
  db_mgmt_Management(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _datatypeGroups(grt, this, false),
    _rdbms(grt, this, false),
    _storedConns(grt, this, false),
    _storedInstances(grt, this, false)

  {
  }

  static std::string static_class_name() { return "db.mgmt.Management"; }

  // datatypeGroups is owned by db_mgmt_Management
  grt::ListRef<db_DatatypeGroup> datatypeGroups() const { return _datatypeGroups; }
private: // the next attribute is read-only
  virtual void datatypeGroups(const grt::ListRef<db_DatatypeGroup> &value)
  {
    grt::ValueRef ovalue(_datatypeGroups);

    _datatypeGroups= value;
    owned_member_changed("datatypeGroups", ovalue, value);
  }
public:

  // rdbms is owned by db_mgmt_Management
  grt::ListRef<db_mgmt_Rdbms> rdbms() const { return _rdbms; }
private: // the next attribute is read-only
  virtual void rdbms(const grt::ListRef<db_mgmt_Rdbms> &value)
  {
    grt::ValueRef ovalue(_rdbms);

    _rdbms= value;
    owned_member_changed("rdbms", ovalue, value);
  }
public:

  // storedConns is owned by db_mgmt_Management
  grt::ListRef<db_mgmt_Connection> storedConns() const { return _storedConns; }
private: // the next attribute is read-only
  virtual void storedConns(const grt::ListRef<db_mgmt_Connection> &value)
  {
    grt::ValueRef ovalue(_storedConns);

    _storedConns= value;
    owned_member_changed("storedConns", ovalue, value);
  }
public:

  // storedInstances is owned by db_mgmt_Management
  grt::ListRef<db_mgmt_ServerInstance> storedInstances() const { return _storedInstances; }
private: // the next attribute is read-only
  virtual void storedInstances(const grt::ListRef<db_mgmt_ServerInstance> &value)
  {
    grt::ValueRef ovalue(_storedInstances);

    _storedInstances= value;
    owned_member_changed("storedInstances", ovalue, value);
  }
public:

protected:

  grt::ListRef<db_DatatypeGroup> _datatypeGroups;// owned
  grt::ListRef<db_mgmt_Rdbms> _rdbms;// owned
  grt::ListRef<db_mgmt_Connection> _storedConns;// owned
  grt::ListRef<db_mgmt_ServerInstance> _storedInstances;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_mgmt_Management(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_mgmt_Management::create);
    {
      void (db_mgmt_Management::*setter)(const grt::ListRef<db_DatatypeGroup> &)= &db_mgmt_Management::datatypeGroups;
      grt::ListRef<db_DatatypeGroup> (db_mgmt_Management::*getter)() const= &db_mgmt_Management::datatypeGroups;
      meta->bind_member("datatypeGroups", new grt::MetaClass::Property<db_mgmt_Management,grt::ListRef<db_DatatypeGroup> >(getter,setter));
    }
    {
      void (db_mgmt_Management::*setter)(const grt::ListRef<db_mgmt_Rdbms> &)= &db_mgmt_Management::rdbms;
      grt::ListRef<db_mgmt_Rdbms> (db_mgmt_Management::*getter)() const= &db_mgmt_Management::rdbms;
      meta->bind_member("rdbms", new grt::MetaClass::Property<db_mgmt_Management,grt::ListRef<db_mgmt_Rdbms> >(getter,setter));
    }
    {
      void (db_mgmt_Management::*setter)(const grt::ListRef<db_mgmt_Connection> &)= &db_mgmt_Management::storedConns;
      grt::ListRef<db_mgmt_Connection> (db_mgmt_Management::*getter)() const= &db_mgmt_Management::storedConns;
      meta->bind_member("storedConns", new grt::MetaClass::Property<db_mgmt_Management,grt::ListRef<db_mgmt_Connection> >(getter,setter));
    }
    {
      void (db_mgmt_Management::*setter)(const grt::ListRef<db_mgmt_ServerInstance> &)= &db_mgmt_Management::storedInstances;
      grt::ListRef<db_mgmt_ServerInstance> (db_mgmt_Management::*getter)() const= &db_mgmt_Management::storedInstances;
      meta->bind_member("storedInstances", new grt::MetaClass::Property<db_mgmt_Management,grt::ListRef<db_mgmt_ServerInstance> >(getter,setter));
    }
  }
};




inline void register_structs_db_mgmt_xml()
{
  grt::internal::ClassRegistry::register_class<db_mgmt_ServerInstance>();
  grt::internal::ClassRegistry::register_class<db_mgmt_Connection>();
  grt::internal::ClassRegistry::register_class<db_mgmt_DriverParameter>();
  grt::internal::ClassRegistry::register_class<db_mgmt_Driver>();
  grt::internal::ClassRegistry::register_class<db_mgmt_JdbcDriver>();
  grt::internal::ClassRegistry::register_class<db_mgmt_PrivilegeMapping>();
  grt::internal::ClassRegistry::register_class<db_mgmt_Rdbms>();
  grt::internal::ClassRegistry::register_class<db_mgmt_Management>();
}

#ifdef AUTO_REGISTER_GRT_CLASSES
static struct _autoreg__structs_db_mgmt_xml { _autoreg__structs_db_mgmt_xml() { register_structs_db_mgmt_xml(); } } __autoreg__structs_db_mgmt_xml;
#endif

#endif
