#ifndef __grts_structs_db_query_h__
#define __grts_structs_db_query_h__

#include <grtpp.h>

#ifdef _WIN32
  #pragma warning(disable: 4355) // 'this' : used in base member initizalizer list
  #ifdef GRT_STRUCTS_DB_QUERY_EXPORT
  #define GRT_STRUCTS_DB_QUERY_PUBLIC __declspec(dllexport)
#else
  #define GRT_STRUCTS_DB_QUERY_PUBLIC __declspec(dllimport)
#endif
#else
  #define GRT_STRUCTS_DB_QUERY_PUBLIC
#endif

#include <grts/structs.h>


class db_query_ResultsetColumn;
typedef grt::Ref<db_query_ResultsetColumn> db_query_ResultsetColumnRef;
class db_query_Resultset;
typedef grt::Ref<db_query_Resultset> db_query_ResultsetRef;
class db_query_ResultsetSource;
typedef grt::Ref<db_query_ResultsetSource> db_query_ResultsetSourceRef;
class db_query_QueryParameter;
typedef grt::Ref<db_query_QueryParameter> db_query_QueryParameterRef;
class db_query_Query;
typedef grt::Ref<db_query_Query> db_query_QueryRef;


class  db_query_ResultsetColumn : public GrtObject
{
  typedef GrtObject super;
public:
  db_query_ResultsetColumn(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _columnType(""),
     _displayDecimals(0),
     _displayLength(0),
     _isPrimaryKey(0),
     _length("")

  {
  }

  static std::string static_class_name() { return "db.query.ResultsetColumn"; }

  grt::StringRef columnType() const { return _columnType; }
  virtual void columnType(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_columnType);
   _columnType= value;
    member_changed("columnType", ovalue, value);
  }

  grt::IntegerRef displayDecimals() const { return _displayDecimals; }
  virtual void displayDecimals(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_displayDecimals);
   _displayDecimals= value;
    member_changed("displayDecimals", ovalue, value);
  }

  grt::IntegerRef displayLength() const { return _displayLength; }
  virtual void displayLength(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_displayLength);
   _displayLength= value;
    member_changed("displayLength", ovalue, value);
  }

  grt::IntegerRef isPrimaryKey() const { return _isPrimaryKey; }
  virtual void isPrimaryKey(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_isPrimaryKey);
   _isPrimaryKey= value;
    member_changed("isPrimaryKey", ovalue, value);
  }

  grt::StringRef length() const { return _length; }
  virtual void length(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_length);
   _length= value;
    member_changed("length", ovalue, value);
  }

protected:

  grt::StringRef _columnType;
  grt::IntegerRef _displayDecimals;
  grt::IntegerRef _displayLength;
  grt::IntegerRef _isPrimaryKey;
  grt::StringRef _length;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_ResultsetColumn(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_ResultsetColumn::create);
    {
      void (db_query_ResultsetColumn::*setter)(const grt::StringRef &)= &db_query_ResultsetColumn::columnType;
      grt::StringRef (db_query_ResultsetColumn::*getter)() const= &db_query_ResultsetColumn::columnType;
      meta->bind_member("columnType", new grt::MetaClass::Property<db_query_ResultsetColumn,grt::StringRef >(getter,setter));
    }
    {
      void (db_query_ResultsetColumn::*setter)(const grt::IntegerRef &)= &db_query_ResultsetColumn::displayDecimals;
      grt::IntegerRef (db_query_ResultsetColumn::*getter)() const= &db_query_ResultsetColumn::displayDecimals;
      meta->bind_member("displayDecimals", new grt::MetaClass::Property<db_query_ResultsetColumn,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_query_ResultsetColumn::*setter)(const grt::IntegerRef &)= &db_query_ResultsetColumn::displayLength;
      grt::IntegerRef (db_query_ResultsetColumn::*getter)() const= &db_query_ResultsetColumn::displayLength;
      meta->bind_member("displayLength", new grt::MetaClass::Property<db_query_ResultsetColumn,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_query_ResultsetColumn::*setter)(const grt::IntegerRef &)= &db_query_ResultsetColumn::isPrimaryKey;
      grt::IntegerRef (db_query_ResultsetColumn::*getter)() const= &db_query_ResultsetColumn::isPrimaryKey;
      meta->bind_member("isPrimaryKey", new grt::MetaClass::Property<db_query_ResultsetColumn,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_query_ResultsetColumn::*setter)(const grt::StringRef &)= &db_query_ResultsetColumn::length;
      grt::StringRef (db_query_ResultsetColumn::*getter)() const= &db_query_ResultsetColumn::length;
      meta->bind_member("length", new grt::MetaClass::Property<db_query_ResultsetColumn,grt::StringRef >(getter,setter));
    }
  }
};


class  db_query_Resultset : public GrtObject
{
  typedef GrtObject super;
public:
  db_query_Resultset(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _columns(grt, this, false),
     _nextBlockStartRow(0),
     _rowBlockSize(0),
     _sql("")

  {
  }

  static std::string static_class_name() { return "db.query.Resultset"; }

  // columns is owned by db_query_Resultset
  grt::ListRef<db_query_ResultsetColumn> columns() const { return _columns; }
private: // the next attribute is read-only
  virtual void columns(const grt::ListRef<db_query_ResultsetColumn> &value)
  {
    grt::ValueRef ovalue(_columns);

    _columns= value;
    owned_member_changed("columns", ovalue, value);
  }
public:

  db_mgmt_ConnectionRef connection() const { return _connection; }
  virtual void connection(const db_mgmt_ConnectionRef &value)
  {
    grt::ValueRef ovalue(_connection);
   _connection= value;
    member_changed("connection", ovalue, value);
  }

  grt::IntegerRef nextBlockStartRow() const { return _nextBlockStartRow; }
  virtual void nextBlockStartRow(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_nextBlockStartRow);
   _nextBlockStartRow= value;
    member_changed("nextBlockStartRow", ovalue, value);
  }

  db_query_QueryRef query() const { return _query; }
  virtual void query(const db_query_QueryRef &value)
  {
    grt::ValueRef ovalue(_query);
   _query= value;
    member_changed("query", ovalue, value);
  }

  grt::IntegerRef rowBlockSize() const { return _rowBlockSize; }
  virtual void rowBlockSize(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_rowBlockSize);
   _rowBlockSize= value;
    member_changed("rowBlockSize", ovalue, value);
  }

  grt::StringRef sql() const { return _sql; }
  virtual void sql(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_sql);
   _sql= value;
    member_changed("sql", ovalue, value);
  }

protected:

  grt::ListRef<db_query_ResultsetColumn> _columns;// owned
  db_mgmt_ConnectionRef _connection;
  grt::IntegerRef _nextBlockStartRow;
  db_query_QueryRef _query;
  grt::IntegerRef _rowBlockSize;
  grt::StringRef _sql;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_Resultset(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_Resultset::create);
    {
      void (db_query_Resultset::*setter)(const grt::ListRef<db_query_ResultsetColumn> &)= &db_query_Resultset::columns;
      grt::ListRef<db_query_ResultsetColumn> (db_query_Resultset::*getter)() const= &db_query_Resultset::columns;
      meta->bind_member("columns", new grt::MetaClass::Property<db_query_Resultset,grt::ListRef<db_query_ResultsetColumn> >(getter,setter));
    }
    {
      void (db_query_Resultset::*setter)(const db_mgmt_ConnectionRef &)= &db_query_Resultset::connection;
      db_mgmt_ConnectionRef (db_query_Resultset::*getter)() const= &db_query_Resultset::connection;
      meta->bind_member("connection", new grt::MetaClass::Property<db_query_Resultset,db_mgmt_ConnectionRef >(getter,setter));
    }
    {
      void (db_query_Resultset::*setter)(const grt::IntegerRef &)= &db_query_Resultset::nextBlockStartRow;
      grt::IntegerRef (db_query_Resultset::*getter)() const= &db_query_Resultset::nextBlockStartRow;
      meta->bind_member("nextBlockStartRow", new grt::MetaClass::Property<db_query_Resultset,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_query_Resultset::*setter)(const db_query_QueryRef &)= &db_query_Resultset::query;
      db_query_QueryRef (db_query_Resultset::*getter)() const= &db_query_Resultset::query;
      meta->bind_member("query", new grt::MetaClass::Property<db_query_Resultset,db_query_QueryRef >(getter,setter));
    }
    {
      void (db_query_Resultset::*setter)(const grt::IntegerRef &)= &db_query_Resultset::rowBlockSize;
      grt::IntegerRef (db_query_Resultset::*getter)() const= &db_query_Resultset::rowBlockSize;
      meta->bind_member("rowBlockSize", new grt::MetaClass::Property<db_query_Resultset,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_query_Resultset::*setter)(const grt::StringRef &)= &db_query_Resultset::sql;
      grt::StringRef (db_query_Resultset::*getter)() const= &db_query_Resultset::sql;
      meta->bind_member("sql", new grt::MetaClass::Property<db_query_Resultset,grt::StringRef >(getter,setter));
    }
  }
};


class  db_query_ResultsetSource : public GrtObject
{
  typedef GrtObject super;
public:
  db_query_ResultsetSource(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
  }

  static std::string static_class_name() { return "db.query.ResultsetSource"; }

protected:

private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_ResultsetSource(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_ResultsetSource::create);
  }
};


class  db_query_QueryParameter : public GrtObject
{
  typedef GrtObject super;
public:
  db_query_QueryParameter(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _masterColumnName(""),
     _paramType(""),
     _valueInt(0),
     _valueReal(0.0),
     _valueStr("")

  {
  }

  static std::string static_class_name() { return "db.query.QueryParameter"; }

  grt::StringRef masterColumnName() const { return _masterColumnName; }
  virtual void masterColumnName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_masterColumnName);
   _masterColumnName= value;
    member_changed("masterColumnName", ovalue, value);
  }

  db_query_QueryRef masterQuery() const { return _masterQuery; }
  virtual void masterQuery(const db_query_QueryRef &value)
  {
    grt::ValueRef ovalue(_masterQuery);
   _masterQuery= value;
    member_changed("masterQuery", ovalue, value);
  }

  grt::StringRef paramType() const { return _paramType; }
  virtual void paramType(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_paramType);
   _paramType= value;
    member_changed("paramType", ovalue, value);
  }

  grt::IntegerRef valueInt() const { return _valueInt; }
  virtual void valueInt(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_valueInt);
   _valueInt= value;
    member_changed("valueInt", ovalue, value);
  }

  grt::DoubleRef valueReal() const { return _valueReal; }
  virtual void valueReal(const grt::DoubleRef &value)
  {
    grt::ValueRef ovalue(_valueReal);
   _valueReal= value;
    member_changed("valueReal", ovalue, value);
  }

  grt::StringRef valueStr() const { return _valueStr; }
  virtual void valueStr(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_valueStr);
   _valueStr= value;
    member_changed("valueStr", ovalue, value);
  }

protected:

  grt::StringRef _masterColumnName;
  db_query_QueryRef _masterQuery;
  grt::StringRef _paramType;
  grt::IntegerRef _valueInt;
  grt::DoubleRef _valueReal;
  grt::StringRef _valueStr;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_QueryParameter(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_QueryParameter::create);
    {
      void (db_query_QueryParameter::*setter)(const grt::StringRef &)= &db_query_QueryParameter::masterColumnName;
      grt::StringRef (db_query_QueryParameter::*getter)() const= &db_query_QueryParameter::masterColumnName;
      meta->bind_member("masterColumnName", new grt::MetaClass::Property<db_query_QueryParameter,grt::StringRef >(getter,setter));
    }
    {
      void (db_query_QueryParameter::*setter)(const db_query_QueryRef &)= &db_query_QueryParameter::masterQuery;
      db_query_QueryRef (db_query_QueryParameter::*getter)() const= &db_query_QueryParameter::masterQuery;
      meta->bind_member("masterQuery", new grt::MetaClass::Property<db_query_QueryParameter,db_query_QueryRef >(getter,setter));
    }
    {
      void (db_query_QueryParameter::*setter)(const grt::StringRef &)= &db_query_QueryParameter::paramType;
      grt::StringRef (db_query_QueryParameter::*getter)() const= &db_query_QueryParameter::paramType;
      meta->bind_member("paramType", new grt::MetaClass::Property<db_query_QueryParameter,grt::StringRef >(getter,setter));
    }
    {
      void (db_query_QueryParameter::*setter)(const grt::IntegerRef &)= &db_query_QueryParameter::valueInt;
      grt::IntegerRef (db_query_QueryParameter::*getter)() const= &db_query_QueryParameter::valueInt;
      meta->bind_member("valueInt", new grt::MetaClass::Property<db_query_QueryParameter,grt::IntegerRef >(getter,setter));
    }
    {
      void (db_query_QueryParameter::*setter)(const grt::DoubleRef &)= &db_query_QueryParameter::valueReal;
      grt::DoubleRef (db_query_QueryParameter::*getter)() const= &db_query_QueryParameter::valueReal;
      meta->bind_member("valueReal", new grt::MetaClass::Property<db_query_QueryParameter,grt::DoubleRef >(getter,setter));
    }
    {
      void (db_query_QueryParameter::*setter)(const grt::StringRef &)= &db_query_QueryParameter::valueStr;
      grt::StringRef (db_query_QueryParameter::*getter)() const= &db_query_QueryParameter::valueStr;
      meta->bind_member("valueStr", new grt::MetaClass::Property<db_query_QueryParameter,grt::StringRef >(getter,setter));
    }
  }
};


class  db_query_Query : public GrtObject
{
  typedef GrtObject super;
public:
  db_query_Query(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _moduleName(""),
    _params(grt, this, false),
     _sql("")

  {
  }

  static std::string static_class_name() { return "db.query.Query"; }

  db_mgmt_ConnectionRef connection() const { return _connection; }
  virtual void connection(const db_mgmt_ConnectionRef &value)
  {
    grt::ValueRef ovalue(_connection);
   _connection= value;
    member_changed("connection", ovalue, value);
  }

  grt::StringRef moduleName() const { return _moduleName; }
  virtual void moduleName(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_moduleName);
   _moduleName= value;
    member_changed("moduleName", ovalue, value);
  }

  // params is owned by db_query_Query
  grt::ListRef<db_query_QueryParameter> params() const { return _params; }
private: // the next attribute is read-only
  virtual void params(const grt::ListRef<db_query_QueryParameter> &value)
  {
    grt::ValueRef ovalue(_params);

    _params= value;
    owned_member_changed("params", ovalue, value);
  }
public:

  grt::StringRef sql() const { return _sql; }
  virtual void sql(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_sql);
   _sql= value;
    member_changed("sql", ovalue, value);
  }

protected:

  db_mgmt_ConnectionRef _connection;
  grt::StringRef _moduleName;
  grt::ListRef<db_query_QueryParameter> _params;// owned
  grt::StringRef _sql;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new db_query_Query(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&db_query_Query::create);
    {
      void (db_query_Query::*setter)(const db_mgmt_ConnectionRef &)= &db_query_Query::connection;
      db_mgmt_ConnectionRef (db_query_Query::*getter)() const= &db_query_Query::connection;
      meta->bind_member("connection", new grt::MetaClass::Property<db_query_Query,db_mgmt_ConnectionRef >(getter,setter));
    }
    {
      void (db_query_Query::*setter)(const grt::StringRef &)= &db_query_Query::moduleName;
      grt::StringRef (db_query_Query::*getter)() const= &db_query_Query::moduleName;
      meta->bind_member("moduleName", new grt::MetaClass::Property<db_query_Query,grt::StringRef >(getter,setter));
    }
    {
      void (db_query_Query::*setter)(const grt::ListRef<db_query_QueryParameter> &)= &db_query_Query::params;
      grt::ListRef<db_query_QueryParameter> (db_query_Query::*getter)() const= &db_query_Query::params;
      meta->bind_member("params", new grt::MetaClass::Property<db_query_Query,grt::ListRef<db_query_QueryParameter> >(getter,setter));
    }
    {
      void (db_query_Query::*setter)(const grt::StringRef &)= &db_query_Query::sql;
      grt::StringRef (db_query_Query::*getter)() const= &db_query_Query::sql;
      meta->bind_member("sql", new grt::MetaClass::Property<db_query_Query,grt::StringRef >(getter,setter));
    }
  }
};




inline void register_structs_db_query_xml()
{
  grt::internal::ClassRegistry::register_class<db_query_ResultsetColumn>();
  grt::internal::ClassRegistry::register_class<db_query_Resultset>();
  grt::internal::ClassRegistry::register_class<db_query_ResultsetSource>();
  grt::internal::ClassRegistry::register_class<db_query_QueryParameter>();
  grt::internal::ClassRegistry::register_class<db_query_Query>();
}

#ifdef AUTO_REGISTER_GRT_CLASSES
static struct _autoreg__structs_db_query_xml { _autoreg__structs_db_query_xml() { register_structs_db_query_xml(); } } __autoreg__structs_db_query_xml;
#endif

#endif
