#ifndef __grts_structs_workbench_h__
#define __grts_structs_workbench_h__

#include <grtpp.h>

#ifdef _WIN32
  #pragma warning(disable: 4355) // 'this' : used in base member initizalizer list
  #ifdef GRT_STRUCTS_WORKBENCH_EXPORT
  #define GRT_STRUCTS_WORKBENCH_PUBLIC __declspec(dllexport)
#else
  #define GRT_STRUCTS_WORKBENCH_PUBLIC __declspec(dllimport)
#endif
#else
  #define GRT_STRUCTS_WORKBENCH_PUBLIC
#endif

#include <grts/structs.h>
#include <grts/structs.app.h>
#include <grts/structs.db.h>
#include <grts/structs.db.mgmt.h>
#include <grts/structs.workbench.physical.h>
#include <grts/structs.workbench.logical.h>


class workbench_OverviewPanel;
typedef grt::Ref<workbench_OverviewPanel> workbench_OverviewPanelRef;
class workbench_Document;
typedef grt::Ref<workbench_Document> workbench_DocumentRef;
class workbench_Workbench;
typedef grt::Ref<workbench_Workbench> workbench_WorkbenchRef;


class  workbench_OverviewPanel : public GrtObject
{
  typedef GrtObject super;
public:
  workbench_OverviewPanel(grt::GRT *grt, grt::MetaClass *meta=0)
  : GrtObject(grt, meta ? meta : grt->get_metaclass(static_class_name())),
     _caption(""),
     _expanded(0),
     _expandedHeight(0),
     _hasTabSelection(0),
     _implModule(""),
     _itemActivationFunction(""),
     _itemCountFunction(""),
     _itemDisplayMode(0),
     _itemInfoFunction(""),
     _nodeId(""),
    _selectedItems(grt, this, false),
     _tabActivationFunction(""),
     _tabCountFunction(""),
     _tabInfoFunction("")

  {
  }

  static std::string static_class_name() { return "workbench.OverviewPanel"; }

  grt::StringRef caption() const { return _caption; }
  virtual void caption(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_caption);
   _caption= value;
    member_changed("caption", ovalue, value);
  }

  grt::IntegerRef expanded() const { return _expanded; }
  virtual void expanded(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_expanded);
   _expanded= value;
    member_changed("expanded", ovalue, value);
  }

  grt::IntegerRef expandedHeight() const { return _expandedHeight; }
  virtual void expandedHeight(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_expandedHeight);
   _expandedHeight= value;
    member_changed("expandedHeight", ovalue, value);
  }

  grt::IntegerRef hasTabSelection() const { return _hasTabSelection; }
  virtual void hasTabSelection(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_hasTabSelection);
   _hasTabSelection= value;
    member_changed("hasTabSelection", ovalue, value);
  }

  grt::StringRef implModule() const { return _implModule; }
  virtual void implModule(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_implModule);
   _implModule= value;
    member_changed("implModule", ovalue, value);
  }

  grt::StringRef itemActivationFunction() const { return _itemActivationFunction; }
  virtual void itemActivationFunction(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_itemActivationFunction);
   _itemActivationFunction= value;
    member_changed("itemActivationFunction", ovalue, value);
  }

  grt::StringRef itemCountFunction() const { return _itemCountFunction; }
  virtual void itemCountFunction(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_itemCountFunction);
   _itemCountFunction= value;
    member_changed("itemCountFunction", ovalue, value);
  }

  grt::IntegerRef itemDisplayMode() const { return _itemDisplayMode; }
  virtual void itemDisplayMode(const grt::IntegerRef &value)
  {
    grt::ValueRef ovalue(_itemDisplayMode);
   _itemDisplayMode= value;
    member_changed("itemDisplayMode", ovalue, value);
  }

  grt::StringRef itemInfoFunction() const { return _itemInfoFunction; }
  virtual void itemInfoFunction(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_itemInfoFunction);
   _itemInfoFunction= value;
    member_changed("itemInfoFunction", ovalue, value);
  }

  grt::StringRef nodeId() const { return _nodeId; }
  virtual void nodeId(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_nodeId);
   _nodeId= value;
    member_changed("nodeId", ovalue, value);
  }

  grt::IntegerListRef selectedItems() const { return _selectedItems; }
private: // the next attribute is read-only
  virtual void selectedItems(const grt::IntegerListRef &value)
  {
    grt::ValueRef ovalue(_selectedItems);
   _selectedItems= value;
    member_changed("selectedItems", ovalue, value);
  }
public:

  grt::StringRef tabActivationFunction() const { return _tabActivationFunction; }
  virtual void tabActivationFunction(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_tabActivationFunction);
   _tabActivationFunction= value;
    member_changed("tabActivationFunction", ovalue, value);
  }

  grt::StringRef tabCountFunction() const { return _tabCountFunction; }
  virtual void tabCountFunction(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_tabCountFunction);
   _tabCountFunction= value;
    member_changed("tabCountFunction", ovalue, value);
  }

  grt::StringRef tabInfoFunction() const { return _tabInfoFunction; }
  virtual void tabInfoFunction(const grt::StringRef &value)
  {
    grt::ValueRef ovalue(_tabInfoFunction);
   _tabInfoFunction= value;
    member_changed("tabInfoFunction", ovalue, value);
  }

protected:

  grt::StringRef _caption;
  grt::IntegerRef _expanded;
  grt::IntegerRef _expandedHeight;
  grt::IntegerRef _hasTabSelection;
  grt::StringRef _implModule;
  grt::StringRef _itemActivationFunction;
  grt::StringRef _itemCountFunction;
  grt::IntegerRef _itemDisplayMode;
  grt::StringRef _itemInfoFunction;
  grt::StringRef _nodeId;
  grt::IntegerListRef _selectedItems;
  grt::StringRef _tabActivationFunction;
  grt::StringRef _tabCountFunction;
  grt::StringRef _tabInfoFunction;
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new workbench_OverviewPanel(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&workbench_OverviewPanel::create);
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::caption;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::caption;
      meta->bind_member("caption", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::IntegerRef &)= &workbench_OverviewPanel::expanded;
      grt::IntegerRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::expanded;
      meta->bind_member("expanded", new grt::MetaClass::Property<workbench_OverviewPanel,grt::IntegerRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::IntegerRef &)= &workbench_OverviewPanel::expandedHeight;
      grt::IntegerRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::expandedHeight;
      meta->bind_member("expandedHeight", new grt::MetaClass::Property<workbench_OverviewPanel,grt::IntegerRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::IntegerRef &)= &workbench_OverviewPanel::hasTabSelection;
      grt::IntegerRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::hasTabSelection;
      meta->bind_member("hasTabSelection", new grt::MetaClass::Property<workbench_OverviewPanel,grt::IntegerRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::implModule;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::implModule;
      meta->bind_member("implModule", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::itemActivationFunction;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::itemActivationFunction;
      meta->bind_member("itemActivationFunction", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::itemCountFunction;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::itemCountFunction;
      meta->bind_member("itemCountFunction", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::IntegerRef &)= &workbench_OverviewPanel::itemDisplayMode;
      grt::IntegerRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::itemDisplayMode;
      meta->bind_member("itemDisplayMode", new grt::MetaClass::Property<workbench_OverviewPanel,grt::IntegerRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::itemInfoFunction;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::itemInfoFunction;
      meta->bind_member("itemInfoFunction", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::nodeId;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::nodeId;
      meta->bind_member("nodeId", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::IntegerListRef &)= &workbench_OverviewPanel::selectedItems;
      grt::IntegerListRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::selectedItems;
      meta->bind_member("selectedItems", new grt::MetaClass::Property<workbench_OverviewPanel,grt::IntegerListRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::tabActivationFunction;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::tabActivationFunction;
      meta->bind_member("tabActivationFunction", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::tabCountFunction;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::tabCountFunction;
      meta->bind_member("tabCountFunction", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
    {
      void (workbench_OverviewPanel::*setter)(const grt::StringRef &)= &workbench_OverviewPanel::tabInfoFunction;
      grt::StringRef (workbench_OverviewPanel::*getter)() const= &workbench_OverviewPanel::tabInfoFunction;
      meta->bind_member("tabInfoFunction", new grt::MetaClass::Property<workbench_OverviewPanel,grt::StringRef >(getter,setter));
    }
  }
};


class  workbench_Document : public app_Document
{
  typedef app_Document super;
public:
  workbench_Document(grt::GRT *grt, grt::MetaClass *meta=0)
  : app_Document(grt, meta ? meta : grt->get_metaclass(static_class_name())),
    _overviewPanels(grt, this, false),
    _physicalModels(grt, this, false)

  {
  }

  static std::string static_class_name() { return "workbench.Document"; }

  // logicalModel is owned by workbench_Document
  workbench_logical_ModelRef logicalModel() const { return _logicalModel; }
  virtual void logicalModel(const workbench_logical_ModelRef &value)
  {
    grt::ValueRef ovalue(_logicalModel);

    _logicalModel= value;
    owned_member_changed("logicalModel", ovalue, value);
  }

  model_ModelRef overviewCurrentModelType() const { return _overviewCurrentModelType; }
  virtual void overviewCurrentModelType(const model_ModelRef &value)
  {
    grt::ValueRef ovalue(_overviewCurrentModelType);
   _overviewCurrentModelType= value;
    member_changed("overviewCurrentModelType", ovalue, value);
  }

  // overviewPanels is owned by workbench_Document
  grt::ListRef<workbench_OverviewPanel> overviewPanels() const { return _overviewPanels; }
private: // the next attribute is read-only
  virtual void overviewPanels(const grt::ListRef<workbench_OverviewPanel> &value)
  {
    grt::ValueRef ovalue(_overviewPanels);

    _overviewPanels= value;
    owned_member_changed("overviewPanels", ovalue, value);
  }
public:

  // physicalModels is owned by workbench_Document
  grt::ListRef<workbench_physical_Model> physicalModels() const { return _physicalModels; }
private: // the next attribute is read-only
  virtual void physicalModels(const grt::ListRef<workbench_physical_Model> &value)
  {
    grt::ValueRef ovalue(_physicalModels);

    _physicalModels= value;
    owned_member_changed("physicalModels", ovalue, value);
  }
public:

protected:

  workbench_logical_ModelRef _logicalModel;// owned
  model_ModelRef _overviewCurrentModelType;
  grt::ListRef<workbench_OverviewPanel> _overviewPanels;// owned
  grt::ListRef<workbench_physical_Model> _physicalModels;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new workbench_Document(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&workbench_Document::create);
    {
      void (workbench_Document::*setter)(const workbench_logical_ModelRef &)= &workbench_Document::logicalModel;
      workbench_logical_ModelRef (workbench_Document::*getter)() const= &workbench_Document::logicalModel;
      meta->bind_member("logicalModel", new grt::MetaClass::Property<workbench_Document,workbench_logical_ModelRef >(getter,setter));
    }
    {
      void (workbench_Document::*setter)(const model_ModelRef &)= &workbench_Document::overviewCurrentModelType;
      model_ModelRef (workbench_Document::*getter)() const= &workbench_Document::overviewCurrentModelType;
      meta->bind_member("overviewCurrentModelType", new grt::MetaClass::Property<workbench_Document,model_ModelRef >(getter,setter));
    }
    {
      void (workbench_Document::*setter)(const grt::ListRef<workbench_OverviewPanel> &)= &workbench_Document::overviewPanels;
      grt::ListRef<workbench_OverviewPanel> (workbench_Document::*getter)() const= &workbench_Document::overviewPanels;
      meta->bind_member("overviewPanels", new grt::MetaClass::Property<workbench_Document,grt::ListRef<workbench_OverviewPanel> >(getter,setter));
    }
    {
      void (workbench_Document::*setter)(const grt::ListRef<workbench_physical_Model> &)= &workbench_Document::physicalModels;
      grt::ListRef<workbench_physical_Model> (workbench_Document::*getter)() const= &workbench_Document::physicalModels;
      meta->bind_member("physicalModels", new grt::MetaClass::Property<workbench_Document,grt::ListRef<workbench_physical_Model> >(getter,setter));
    }
  }
};


class  workbench_Workbench : public app_Application
{
  typedef app_Application super;
public:
  workbench_Workbench(grt::GRT *grt, grt::MetaClass *meta=0)
  : app_Application(grt, meta ? meta : grt->get_metaclass(static_class_name()))

  {
  }

  static std::string static_class_name() { return "workbench.Workbench"; }

  // doc is owned by workbench_Workbench
  workbench_DocumentRef doc() const { return workbench_DocumentRef::cast_from(_doc); }
  virtual void doc(const workbench_DocumentRef &value) { super::doc(value); }

  // rdbmsMgmt is owned by workbench_Workbench
  db_mgmt_ManagementRef rdbmsMgmt() const { return _rdbmsMgmt; }
  virtual void rdbmsMgmt(const db_mgmt_ManagementRef &value)
  {
    grt::ValueRef ovalue(_rdbmsMgmt);

    _rdbmsMgmt= value;
    owned_member_changed("rdbmsMgmt", ovalue, value);
  }

protected:

  db_mgmt_ManagementRef _rdbmsMgmt;// owned
private: // wrapper methods for use by grt
  static grt::ObjectRef create(grt::GRT *grt)
  {
    return grt::ObjectRef(new workbench_Workbench(grt));
  }


public:
  static void grt_register(grt::GRT *grt)
  {
    grt::MetaClass *meta= grt->get_metaclass(static_class_name());
    if (!meta) throw std::runtime_error("error initializing grt object class, metaclass not found");
    meta->bind_allocator(&workbench_Workbench::create);
    {
      void (workbench_Workbench::*setter)(const workbench_DocumentRef &)= 0;
      workbench_DocumentRef (workbench_Workbench::*getter)() const= 0;
      meta->bind_member("doc", new grt::MetaClass::Property<workbench_Workbench,workbench_DocumentRef >(getter,setter));
    }
    {
      void (workbench_Workbench::*setter)(const db_mgmt_ManagementRef &)= &workbench_Workbench::rdbmsMgmt;
      db_mgmt_ManagementRef (workbench_Workbench::*getter)() const= &workbench_Workbench::rdbmsMgmt;
      meta->bind_member("rdbmsMgmt", new grt::MetaClass::Property<workbench_Workbench,db_mgmt_ManagementRef >(getter,setter));
    }
  }
};




inline void register_structs_workbench_xml()
{
  grt::internal::ClassRegistry::register_class<workbench_OverviewPanel>();
  grt::internal::ClassRegistry::register_class<workbench_Document>();
  grt::internal::ClassRegistry::register_class<workbench_Workbench>();
}

#ifdef AUTO_REGISTER_GRT_CLASSES
static struct _autoreg__structs_workbench_xml { _autoreg__structs_workbench_xml() { register_structs_workbench_xml(); } } __autoreg__structs_workbench_xml;
#endif

#endif
