/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "geometry.h"

using namespace MySQL::Geometry;

//--------------------------------------------------------------------------------------------------

Rect::Rect()
{
  left= 0;
  top= 0;
  width= 0;
  height= 0;
}

//--------------------------------------------------------------------------------------------------

Rect::Rect(double x, double y, double w, double h)
{
  left= x;
  top= y;
  width= w;
  height= h;
}

//--------------------------------------------------------------------------------------------------

bool Rect::contains(double x, double y)
{
  return (x >= left) && (x <= left + width) &&
    (y >= top) && (y <= top + height);
}

//--------------------------------------------------------------------------------------------------

bool Rect::contains_flipped(double x, double y)
{
  // For cairo text the top is actually the bottom (when using it for hit tests).
  return (x >= left) && (x <= left + width) &&
    (y >= top - height) && (y <= top);
}

//--------------------------------------------------------------------------------------------------

