/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _GEOMETRY_H_
#define _GEOMETRY_H_

/**
 * Definitions and implementations of geometry related types and classes. Defines all the usual base types
 * like point, rectangle and the like.
 */

#include "common.h"

namespace MySQL {
namespace Geometry {

typedef struct BASELIBRARY_PUBLIC_FUNC Rect {
  double left;
  double top;
  double width;
  double height;

  bool contains(double x, double y);
  bool contains_flipped(double x, double y);

  Rect();
  Rect(double x, double y, double w, double h);

} Rect;

}
}

#endif /* _GEOMETRY_H_ */
