/*
 *  mdc_back_layer.h
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/Mar/13.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#ifndef _MDC_BACK_LAYER_H_
#define _MDC_BACK_LAYER_H_

#include "mdc_layer.h"

BEGIN_MDC_DECLS

class MYSQLCANVAS_PUBLIC_FUNC BackLayer : public Layer {  
public:
  BackLayer(CanvasView *view);
  virtual ~BackLayer();

  virtual void repaint(const Rect &bounds);
  
  void set_grid_visible(bool flag);
  void set_paper_visible(bool flag);

  bool get_grid_visible() { return _grid_visible; }
  bool get_paper_visible() { return _paper_visible; }

  void set_color(const Color &color);
  
protected:
  Color _fill_color;
  Color _line1_color;
  Color _line2_color;

  // display lists for caching the grid
  GLint _grid1_dl;
  GLint _grid2_dl;
  // canvas position the display lists were generated
  Point _grid_dl_start;
  Rect _grid_dl_area;
  double _grid_dl_size;

  bool _grid_visible;
  bool _paper_visible;
  
  
  void render_pages(const Rect &aBounds);
  void render_grid(const Rect &aBounds);
};

END_MDC_DECLS


#endif
