/*
 *  mdc_bounds_magnet.cpp
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/3.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#include "stdafx.h"
#include "mdc_bounds_magnet.h"
#include "mdc_algorithms.h"
#include "mdc_canvas_item.h"

using namespace mdc;

BoundsMagnet::BoundsMagnet(CanvasItem *owner)
: Magnet(owner)
{
}



Point BoundsMagnet::get_position_for_connector(Connector *conn, const Point &srcpos) const
{
  return _owner->get_intersection_with_line_to(srcpos);
}


void BoundsMagnet::owner_bounds_changed(const Rect &obounds)
{
  notify_connected();
}
