#ifndef _MDC_CANVAS_VIEW_PRINTING_H_
#define _MDC_CANVAS_VIEW_PRINTING_H_

#include "mdc_canvas_public.h"
#include "mdc_common.h"

//#if !defined(_WIN32) && !defined(__APPLE__)
//#include <gtkmm.h>
//#endif

BEGIN_MDC_DECLS

class CanvasView;

enum PageOrientation {
  Landscape,
  Portrait
};


class MYSQLCANVAS_PUBLIC_FUNC CanvasViewExtras {
public:
  CanvasViewExtras(CanvasView *view);

  void set_progress_callback(const sigc::slot<void, int, int> &progress);

  void enable_custom_layout();
  void set_show_print_guides(bool flag);

  void set_paper_size(double width, double height);

  void set_page_margins(double top, double left, double bottom, double right);
  void set_page_counts(Count xpages, Count ypages);

  void set_orientation(PageOrientation orientation);

  void set_print_border(bool flag);
  void set_print_page_numbers(bool flag);

  void set_scale(double scale);
  void set_scale_to_fit();

  void set_print_area(const Rect &area);

  int print_to_pdf(const std::string &path);
  int print_to_ps(const std::string &path);

#ifdef _WIN32
  int print_native(HDC hdc, int width, int height, int page);
#endif
  int print_page(mdc::CairoCtx *ctx, int width, int height, int page);

  int render_pages(CairoCtx *cr, double render_scale, int page= -1);
  
  // final version
  void render_page(CairoCtx *cr, int x, int y);
  
protected:
  Size get_adjusted_paper_size();
  Rect get_adjusted_printable_area();


  CanvasView *_view;

  sigc::slot<void, int, int> _progress_cb;

  Count _xpages, _ypages;

  double _page_width; // in mm
  double _page_height; // in mm

  double _scale;

  double _margin_left;
  double _margin_right;
  double _margin_top;
  double _margin_bottom;

  PageOrientation _orientation;
  bool _custom_layout;
  bool _print_border;
  bool _print_page_numbers;
};



END_MDC_DECLS


#endif
