/*
 *  mdc_connector.cpp
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/2.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */

#include "stdafx.h"

#include "mdc_connector.h"
#include "mdc_magnet.h"
#include "mdc_canvas_item.h"

using namespace mdc;

Connector::Connector(CanvasItem *owner)
: _owner(owner), _magnet(0), _tag(0)
{
  _draggable= true;
}


void Connector::set_update_handler(const sigc::slot<void, Connector*> &update_handler)
{
  _update_handler= update_handler;
}


Connector::~Connector()
{
  if (_magnet)
    _magnet->remove_connector(this);
}


void Connector::set_draggable(bool flag)
{
  _draggable= flag;
}


void Connector::connect(Magnet *magnet)
{
  if (_magnet)
    throw std::logic_error("connecting an already connected connector");

  magnet->add_connector(this);
  _magnet= magnet;
  magnet_moved(magnet);
}


bool Connector::try_connect(Magnet *magnet)
{
  if (_magnet == magnet)
    return true;

  if (magnet->allows_connection(this))
  {
    connect(magnet);
    return true;
  }
  return false;
}


bool Connector::try_disconnect()
{
  if (_magnet != 0)
  {
    if (_magnet->allows_disconnection(this))
    {
      disconnect();
      return true;
    }
  }
  return false;
}


void Connector::magnet_moved(Magnet *magnet)
{
  _update_handler(this);
}


Point Connector::get_position(const Point &srcpos)
{
  // returns the position that the connector should be
  if (_magnet)
    return _magnet->get_position_for_connector(this, srcpos);
  
  return Point();
}


Point Connector::get_position()
{
  // returns the position that the connector should be
  if (_magnet)
    return _magnet->get_position();
  
  return Point();
}



void Connector::disconnect()
{
  if (_magnet)
  {
    _magnet->remove_connector(this);
    _magnet= 0;
  }
}


mdc::CanvasItem *Connector::get_connected_item()
{
  if (_magnet)
    return _magnet->get_owner();
  return 0;
}

