#ifndef _MDC_DRAW_UTIL_H_
#define _MDC_DRAW_UTIL_H_

#include "mdc_canvas_public.h"
#include "mdc_common.h"

namespace mdc {

  enum CornerMask {
    CNone= 0,
    CTopLeft=     (1<<0),
    CTopRight=    (1<<1),
    CBottomLeft=  (1<<2),
    CBottomRight= (1<<3),
    CTop=         (CTopLeft|CTopRight),
    CBottom=      (CBottomLeft|CBottomRight),
    CAll=         (CTop|CBottom)
  };

  inline CornerMask operator|(CornerMask a, CornerMask b)
  {
    return (CornerMask)((int)a|(int)b);
  }
  

MYSQLCANVAS_PUBLIC_FUNC void draw_shadow(CairoCtx *cr, const Rect &around_rect, const Color &color);

MYSQLCANVAS_PUBLIC_FUNC void draw_glow(CairoCtx *cr, const Rect &around_rect, const Color &color);

MYSQLCANVAS_PUBLIC_FUNC void fill_hollow_rectangle(CairoCtx *cr, const Rect &outer_rect,
                           const Rect &inner_rect);

MYSQLCANVAS_PUBLIC_FUNC void stroke_rounded_rectangle(CairoCtx *cr,
                              const Rect &bounds, CornerMask corners,
                              float corner_radius, float offset= 0);
MYSQLCANVAS_PUBLIC_FUNC void stroke_rounded_rectangle_gl(const Rect &rect, CornerMask corners,
                                                        float corner_radius, float offset);

MYSQLCANVAS_PUBLIC_FUNC void gl_setcolor(const Color &color);
MYSQLCANVAS_PUBLIC_FUNC void gl_rectangle(double x, double y, double w, double h, bool filled);
MYSQLCANVAS_PUBLIC_FUNC void gl_rectangle(const Rect &rect, bool filled);
MYSQLCANVAS_PUBLIC_FUNC void gl_box(const Rect &rect, Color& border_color, Color& fill_color);

};

#endif /* _MDC_DRAW_UTIL_H_ */
