#ifndef _MDC_LAYOUTER_H_
#define _MDC_LAYOUTER_H_

#include "mdc_common.h"
#include "mdc_canvas_item.h"
#include "mdc_draw_util.h"

namespace mdc {

class Figure;
  
class MYSQLCANVAS_PUBLIC_FUNC Layouter : public CanvasItem {
public:
  Layouter(Layer *layer);
  virtual ~Layouter();

  virtual CanvasItem *get_item_at(const Point &pos)= 0;
  virtual void remove(CanvasItem *item)= 0;
  virtual void remove_all();

  virtual void foreach(const sigc::slot<void, CanvasItem*> &slot)= 0;

  virtual void render(CairoCtx *cr);
  virtual void render_gl(CairoCtx *cr);

  virtual CanvasItem *find_item_with_tag(const std::string &tag);

  void set_draw_background(bool flag);
  void set_background_corners(mdc::CornerMask mask, float radius);
  void set_background_color(const mdc::Color &color);
  void set_border_color(const mdc::Color &color);
  
  virtual void stroke_outline(CairoCtx *cr, float offset= 0);
  virtual void stroke_outline_gl(float offset= 0);
  
protected:
  mdc::Color _border_color;
  mdc::Color _background_color;
  mdc::CornerMask _corner_mask;
  float _corner_radius;
  bool _draw_background;
  
};

};

#endif /* _MDC_LAYOUTER_H_ */
