/*
 *  mdc_vertex_handle.h
 *  mdcanvas
 *
 *  Created by Alfredo Kojima on 07/May/1.
 *  Copyright 2007 MySQL AB. All rights reserved.
 *
 */


#ifndef _MDC_VERTEX_HANDLE_H_
#define _MDC_VERTEX_HANDLE_H_

#include "mdc_item_handle.h"

BEGIN_MDC_DECLS

class VertexHandle : public ItemHandle {
public:
  VertexHandle(InteractionLayer *ilayer, CanvasItem *item, const Point &pos,
               bool connectable);
  virtual ~VertexHandle();
  
  virtual mdc::Rect get_bounds() const;
  virtual void repaint(CairoCtx *cr);

  void set_connected(bool flag);
  
protected:
  bool _connectable;
  bool _connected;
};


END_MDC_DECLS

#endif
