/* 
 * (c) 2008-2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "stdafx.h"

#include <stdio.h>
#include <mforms/app.h>
#include <mforms/mforms.h>
#include <stdio.h>

using namespace mforms;


// Implementation of _app_impl for WB is done directly in main_window.cpp in Linux
// and WBMainWindow.mm in Mac
// In Windows, it's done in Wb.h/Wb.cpp wrapper

App *App::get()
{
  static App *singleton= 0;
  if (!singleton)
  {
    singleton= new App();
    singleton->_app_impl= &ControlFactory::get_instance()->_app_impl;
  }
  return singleton;
}


void App::dock_view(AppView *view, const std::string &position)
{
  if (_app_impl->dock_view)
    _app_impl->dock_view(this, view, position);
}


void App::undock_view(AppView *view)
{
  if (_app_impl->undock_view)
    _app_impl->undock_view(this, view);
}


void App::set_view_title(AppView *view, const std::string &title)
{
  if (_app_impl->set_view_title)
    _app_impl->set_view_title(this, view, title);
}

std::string App::get_resource_path(const std::string &file)
{
  std::string ret;
  if (_app_impl->get_resource_path)
    ret = _app_impl->get_resource_path(this, file);
  return ret;
}

void App::set_status_text(const std::string &text)
{
  if (_app_impl->set_status_text)
    _app_impl->set_status_text(this, text);
}

//--------------------------------------------------------------------------------------------------

/**
 * Returns the bounds of the main application window.
 */
void App::get_bounds(int* x, int* y, int* w, int* h)
{
  bool valid= false;
  if (_app_impl->get_bounds)
  {
    std::string bounds= _app_impl->get_bounds(this);
#ifdef _WIN32
    // Use secure std lib.
    if (sscanf_s(bounds.c_str(), "%i %i %i %i", x, y, w, h) == 4)
#else
    if (sscanf(bounds.c_str(), "%i %i %i %i", x, y, w, h) == 4)
#endif
      valid= true;
  }

  if (!valid)
  {
    x= 0;
    y= 0;
    w= 0;
    h= 0;
  }
}

//--------------------------------------------------------------------------------------------------
