/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include <mforms/box.h>
#include <mforms/mforms.h>

using namespace mforms;

Box::Box(bool horiz)
{
  _box_impl= &ControlFactory::get_instance()->_box_impl;

  _box_impl->create(this, horiz);
}


void Box::add(View *subview, bool expand, bool fill)
{
  subview->retain();
  add_subview(subview);
  subview->set_parent(this);
  _box_impl->add(this, subview, expand, fill);
}


void Box::add_end(View *subview, bool expand, bool fill)
{
  subview->retain();
  remove_subview(subview);
  subview->set_parent(this);
  _box_impl->add_end(this, subview, expand, fill);
}


void Box::remove(View *subview)
{
  remove_subview(subview);
  _box_impl->remove(this, subview);
  subview->release();
}


void Box::set_homogeneous(bool flag)
{
  _box_impl->set_homogeneous(this, flag);
}


void Box::set_spacing(int space)
{
  _box_impl->set_spacing(this, space);
}

void Box::set_padding(int padding)
{
  _box_impl->set_padding(this, padding);
}



