/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include <mforms/button.h>
#include <mforms/mforms.h>


using namespace mforms;


Button::Button()
  : _updating(false)
{
  _button_impl= &ControlFactory::get_instance()->_button_impl;

  _button_impl->create(this);
  
  // enable by default
  enable_internal_padding(true);
}


void Button::set_text(const std::string &text)
{
  _button_impl->set_text(this, text);
}


void Button::enable_internal_padding(bool flag)
{
  _button_impl->enable_internal_padding(this, flag);
}


void Button::callback()
{
  if (!_updating)
    _clicked.emit();
}
