//
//  cf_form.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 21/Jan/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "MFForm.h"
#include <mforms/mforms.h>

@implementation MFFormImpl

- (id)initWithObject:(::mforms::Form*)form
               owner:(::mforms::Form*)ownerWindow
{
  self= [super initWithContentRect:NSMakeRect(100, 100, 1,1)
                         styleMask:NSTitledWindowMask|NSClosableWindowMask|NSMiniaturizableWindowMask|NSResizableWindowMask 
                           backing:NSBackingStoreBuffered 
                             defer:YES];
  if (self)
  {
   // [self setAutorecalculatesKeyViewLoop: YES];
    [self setHidesOnDeactivate: NO];
    [self setReleasedWhenClosed: NO];
    
    mOwner= form;
    mOwner->set_data(self);
    [self setDelegate:self];
  }
  return self;
}


- (mforms::Object*)mformsObject
{
  return mOwner;
}


- (BOOL)isHidden
{
  return ![self isVisible];
}


- (void)setHidden:(BOOL)flag
{
  if (!flag)
  {
    [self makeKeyAndOrderFront:nil];
  }
  else
    [self orderOut:nil];
}


- (void)subviewMinimumSizeChanged
{
  NSSize size= [[self contentView] minimumSize];
  NSSize frameSize= [[self contentView] frame].size;
  BOOL flag= NO;

  if (frameSize.width < size.width)
  {
    frameSize.width= size.width;
    flag= YES;
  }

  if (frameSize.height < size.height)
  {
    frameSize.height= size.height;
    flag= YES;
  }

  if (flag)
    [self setContentSize:frameSize];
 // else
    [[self contentView] resizeSubviewsWithOldSize:frameSize];
  
  [self setContentMinSize:size];
}


- (void)setFrameSize:(NSSize)size
{
  [self setContentSize:size];
}


- (void)windowWillClose:(NSNotification *)notification
{
  if (mIsModal)
    [NSApp stopModal];
  mOwner->was_closed();
}


- (NSInteger)runModal
{
  NSInteger ret;
  mIsModal= YES;

  [self makeKeyAndOrderFront:nil];
  ret= [NSApp runModalForWindow: self];
  mIsModal= NO;
  
  return ret;
}


- (void)setFixedFrameSize:(NSSize)size
{
  [self setFrameSize: size];
}

@end





static bool form_create(::mforms::Form *self, ::mforms::Form *owner, ::mforms::FormFlag flags)
{
 /* MFFormImpl *form=*/ [[[MFFormImpl alloc] initWithObject:self
                                                  owner:owner] autorelease];
    
  return true;
}


static void form_set_title(::mforms::Form *self, const std::string &title)
{
  id form = self->get_data();
  if (form)
  {
    [form setTitle:wrap_nsstring(title)];
  }
}


static void show_modal_button_action(id form, ::mforms::Button *btn)
{
  if (form)
    [form close];
}


static void form_show_modal(::mforms::Form *self, ::mforms::Button *accept, ::mforms::Button *cancel)
{
  id  form = self->get_data();
  if (form)
  {
    if (accept)
    {
      [form setDefaultButtonCell:accept->get_data()];
      accept->signal_clicked().connect(sigc::bind(sigc::ptr_fun(show_modal_button_action), form, accept));
    }
    if (cancel)
      cancel->signal_clicked().connect(sigc::bind(sigc::ptr_fun(show_modal_button_action), form, cancel));
    
    [form makeKeyAndOrderFront:nil];
    [form performSelectorOnMainThread: @selector(runModal) withObject: nil waitUntilDone: YES];
    ///XXX this should not block
  }
}


static void accept_modal(id form)
{
  [NSApp stopModalWithCode:NSOKButton];
}

static void cancel_modal(id form)
{
  [NSApp stopModalWithCode:NSCancelButton];
}


static bool form_run_modal(::mforms::Form *self, ::mforms::Button *accept, ::mforms::Button *cancel)
{
  id  form = self->get_data();
  if (form)
  {    
    if (accept)
    {
      [form setDefaultButtonCell:accept->get_data()];
      accept->signal_clicked().connect(sigc::bind(sigc::ptr_fun(accept_modal), form));
    }
    if (cancel)
      cancel->signal_clicked().connect(sigc::bind(sigc::ptr_fun(cancel_modal), form));
    [form makeKeyAndOrderFront:nil];
    
    NSInvocation* invocation = [NSInvocation invocationWithMethodSignature: [form methodSignatureForSelector: @selector(runModal)]];
    [invocation setTarget: form];
    [invocation setSelector: @selector(runModal)];
    int dialog_result = NSCancelButton;
    [invocation performSelectorOnMainThread: @selector(invoke) withObject: nil waitUntilDone: YES];
    [invocation getReturnValue: &dialog_result];
    if (dialog_result == NSOKButton)
    {
      [form close];
      return true;
    }
    [form close];
  }
  return false;
}


static void form_close(::mforms::Form *self)
{
  id  form = self->get_data();
  if (form)
  {
    [form close];
  }
}


static void form_set_content(::mforms::Form *self, ::mforms::View *child)
{
  id  form = self->get_data();
  if (form)
  {
    [form setContentView:child->get_data()];
    [form subviewMinimumSizeChanged];
  }
}


static void form_center(::mforms::Form *self)
{
  id  form = self->get_data();
  if (form)
  {
    [form center];
  }
}



static void form_flush_events(::mforms::Form *self)
{
  
}


void cf_form_init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();
  
  f->_form_impl.create     = &form_create;
  f->_form_impl.close      = &form_close;
  f->_form_impl.set_title  = &form_set_title;
  f->_form_impl.show_modal = &form_show_modal;
  f->_form_impl.run_modal = &form_run_modal;
  f->_form_impl.set_content= &form_set_content;
  f->_form_impl.flush_events= &form_flush_events;
  f->_form_impl.center= &form_center;
}

