//
//  MFImageBox.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 8/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "MFImageBox.h"
#import "MFView.h"
#include "mforms/mforms.h"
#include "mforms/app.h"

@implementation MFImageBoxImpl

- (id)initWithObject:(::mforms::ImageBox*)aImage
{
  self= [super initWithFrame:NSMakeRect(10,10,10,10)];
  if (self)
  {
    [self setTag: 0];
    [self setImageFrameStyle: NSImageFrameNone];
    mOwner= aImage;
    mOwner->set_data(self);
  }
  return self;
}


- (mforms::Object*)mformsObject
{
  return mOwner;
}



- (NSSize)minimumSize
{
  return [[self image] size];
}



static bool imagebox_create(mforms::ImageBox *image)
{
  [[[MFImageBoxImpl alloc] initWithObject:image] autorelease];
  
  return true;
}


static void imagebox_set_image(mforms::ImageBox *self, const std::string &file)
{
  if (self)
  {
    MFImageBoxImpl *impl= self->get_data();
    NSSize oldSize= [impl frame].size;
    
    std::string full_path= mforms::App::get()->get_resource_path(file);
    NSImage *image= [[[NSImage alloc] initWithContentsOfFile:wrap_nsstring(full_path)] autorelease];
    [impl setImage: image];

    if (!NSEqualSizes([impl frame].size, oldSize))
      [[impl superview] subviewMinimumSizeChanged];
  }
}


void cf_imagebox_init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();
  
  f->_imagebox_impl.create= &imagebox_create;
  f->_imagebox_impl.set_image= &imagebox_set_image;  
}

@end
