/* 
 * (c) 2010 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import "MFSplitter.h"
#include "mforms/mforms.h"


@implementation MFSplitterImpl

- (id)initWithObject:(::mforms::Splitter*)aSplitter
{
  self= [super initWithFrame:NSMakeRect(10,10,10,10)];
  if (self)
  {
    mOwner= aSplitter;
    mOwner->set_data(self);
    [self setDelegate: self];
    mRequestedPosition = -1;
  }
  return self;
}


- (mforms::Object*)mformsObject
{
  return mOwner;
}



- (void)setHorizontal:(BOOL)flag
{
  mHorizontal= flag;
  [self setVertical: flag];
}


- (void)setPosition:(int)position
{
  // if our size is 0, schedule the size to be set later (usually happens in tabviews before being shown)
  if (NSEqualSizes([self frame].size, NSZeroSize))
    mRequestedPosition = position;
  else
    [self setPosition:position ofDividerAtIndex:0];
}


- (NSSize)minimumSize
{
  NSSize size, minSize;
  float maxSize= 0;
  int i = 0;
  
  size.width= 0;
  size.height= 0;
  
  for (id subview in [self subviews])
  {
    if (![subview isHidden])
    {
      minSize= [subview preferredSize];
      
      if (mHorizontal)
      {
        size.width+= minSize.width;
        maxSize= MAX(maxSize, minSize.width);
        size.height= MAX(size.height, MAX(mMinSizes[i], minSize.height));
      }
      else
      {
        size.width= MAX(size.width, MAX(mMinSizes[i], minSize.width));
        maxSize= MAX(maxSize, minSize.height);
        size.height+= minSize.height;
      }
    }
    i++;
  }  
  return size;
}


- (void)resizeSubviewsWithOldSize:(NSSize)osize
{
  [super resizeSubviewsWithOldSize:osize];

  if (NSEqualSizes(osize, [self frame].size))
  {
    for (id sub in [self subviews])
      [sub resizeSubviewsWithOldSize: [sub frame].size];
  }

  if (!NSEqualSizes([self frame].size, NSZeroSize) && mRequestedPosition > 0)
  {
    [self setPosition:mRequestedPosition ofDividerAtIndex:0];
    mRequestedPosition= -1;
  }
}

- (void)setTag:(NSInteger)tag
{
  mTag= tag;
}

//--------------------------------------------------------------------------------------------------

- (NSInteger)tag
{
  return mTag;
}

static bool splitter_create(::mforms::Splitter *self, bool horiz)
{
  MFSplitterImpl *splitter= [[[MFSplitterImpl alloc] initWithObject:self] autorelease];
  
  [splitter setHorizontal:horiz ? YES : NO];
  
  return true;  
}

static void splitter_set_position(::mforms::Splitter *self, int pos)
{
  if ( self )
  {
    MFSplitterImpl* splitter = self->get_data();
    
    if ( splitter )
    {
      [splitter setPosition:pos];
    }
  }
}



static void splitter_add(::mforms::Splitter *self, ::mforms::View *child, int minsize)
{
  int idx;
  MFSplitterImpl *impl = self->get_data();
  if ((idx = [[impl subviews] count]) > 2)
  {
    NSLog(@"Attempt to add subview to splitter with 2 items already");
    return;
  }
  impl->mMinSizes[idx] = minsize;
  [impl addSubview: child->get_data()];
}


static void splitter_remove(::mforms::Splitter *self, ::mforms::View *child)
{
  MFSplitterImpl *impl = self->get_data();
  if ([[impl subviews] indexOfObject: child->get_data()] == 0)
    impl->mMinSizes[0] = impl->mMinSizes[1];
  [child->get_data() removeFromSuperview];
}


void cf_splitter_init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();
  
  f->_splitter_impl.create= &splitter_create;
  f->_splitter_impl.set_position= &splitter_set_position;
  f->_splitter_impl.add= &splitter_add;
  f->_splitter_impl.remove= &splitter_remove;
}

@end


