//
//  MFTabView.mm
//  MySQLWorkbench
//
//  Created by Alfredo Kojima on 6/Feb/09.
//  Copyright 2009 Sun Microsystems Inc. All rights reserved.
//

#import "MFTabView.h"
#include <mforms/mforms.h>

@interface TabViewItemView : NSView
{
@public
  NSTabView *mTabView;
}
@end

@implementation TabViewItemView

- (NSView*)superview
{
  return mTabView;
}


- (void)resizeSubviewsWithOldSize:(NSSize)oldBoundsSize
{
  NSRect frame= NSMakeRect(0, 0, 0, 0);
  
  frame.size= [self frame].size;
  
  if (NSEqualRects(frame, [[[self subviews] lastObject] frame]))
    [[[self subviews] lastObject] resizeSubviewsWithOldSize: oldBoundsSize];
  else
    [[[self subviews] lastObject] setFrame: frame];
}


- (void)setEnabled:(BOOL)flag
{
  [[[self subviews] lastObject] setEnabled: flag];
}

- (NSSize)minimumSize
{
  // A tabview item usually has only one subview attached (the content view), so use this
  // to determine the minimum size.
  if ([[self subviews] count] == 0)
    return NSMakeSize(0, 0);
  return [[[self subviews] objectAtIndex: 0] minimumSize];
}

@end



@implementation MFTabViewImpl

- (id)initWithObject:(::mforms::TabView*)aTabView tabless:(BOOL)tabless
{
  self= [super initWithFrame:NSMakeRect(10, 10, 10, 10)];
  if (self)
  { 
    if (tabless)
      [self setTabViewType: NSNoTabsNoBorder];

    mExtraSize = [super minimumSize];

    mOwner= aTabView;
    mOwner->set_data(self);
    [self setDelegate:self];
  }
  return self;
}

- (mforms::Object*)mformsObject
{
  return mOwner;
}


- (NSSize)minimumSize
{
  NSSize minSize= NSZeroSize;
  
  for (NSTabViewItem *item in [self tabViewItems])
  {
    NSSize size= [[item view] minimumSize];
    
    minSize.width= MAX(minSize.width, size.width);
    minSize.height= MAX(minSize.height, size.height);
  }
  
  minSize.width += mExtraSize.width;
  minSize.height += mExtraSize.height;
    
  return minSize;
}


- (void)resizeSubviewsWithOldSize:(NSSize)oldBoundsSize
{
  for (NSTabViewItem *item in [self tabViewItems])
    [[item view] resizeSubviewsWithOldSize: oldBoundsSize];
}


- (void)setEnabled:(BOOL)flag
{
  for (NSTabViewItem *item in [self tabViewItems])
    [[item view] setEnabled: flag];
}

- (void)setTag:(NSInteger)tag
{
  mTag= tag;
}


- (NSInteger)tag
{
  return mTag;
}


- (void)tabView:(NSTabView *)tabView didSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
  mOwner->signal_tab_changed().emit();
}


static bool tabview_create(::mforms::TabView *self, bool tabless)
{
  [[[MFTabViewImpl alloc] initWithObject:self tabless:tabless] autorelease];
    
  return true;  
}


static void tabview_set_active_tab(::mforms::TabView *self, int tab)
{
  if ( self )
  {
    MFTabViewImpl* tabView = self->get_data();
    
    if ( tabView )
    {
      [tabView selectTabViewItem: [tabView tabViewItemAtIndex:tab]];
    }
  }
}


static int tabview_get_active_tab(::mforms::TabView *self)
{
  if ( self )
  {
    MFTabViewImpl* tabView = self->get_data();
    
    if ( tabView )
    {
      return [tabView indexOfTabViewItem: [tabView selectedTabViewItem]];
    }
  }
  return 0;
}


static int tabview_add_page(::mforms::TabView *self, mforms::View *tab, const std::string &label)
{
  if ( self )
  {
    MFTabViewImpl* tabView = self->get_data();
    
    if ( tabView )
    {
      NSTabViewItem *item= [[[NSTabViewItem alloc] initWithIdentifier: [NSString stringWithFormat:@"%p", tab]] autorelease];
      TabViewItemView *view= [[TabViewItemView alloc] init];
      
      view->mTabView= tabView;
      
      [item setLabel: wrap_nsstring(label)];
      [item setView: view];
      
      [view addSubview: tab->get_data()];
      
      [tabView addTabViewItem: item];
      
      return [tabView numberOfTabViewItems]-1;
    }
  }
  return -1;
}


void cf_tabview_init()
{
  ::mforms::ControlFactory *f = ::mforms::ControlFactory::get_instance();
  
  f->_tabview_impl.create= &tabview_create;
  f->_tabview_impl.set_active_tab= &tabview_set_active_tab;
  f->_tabview_impl.get_active_tab= &tabview_get_active_tab;
  f->_tabview_impl.add_page= &tabview_add_page;
}


@end


