/* 
 * © 2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


/**
 * This file contains a search-and-replace dialog with various options. The actual search/replace functionality
 * is implemented by the owner.
 */
#ifndef _SEARCH_REPLACE_H_
#define _SEARCH_REPLACE_H_

#include "cairo/cairo.h"
#include "mforms/form.h" 
#include "mforms/table.h"
#include "mforms/box.h"
#include "mforms/checkbox.h"
#include "mforms/selector.h"
#include "mforms/label.h"

#include <sigc++/sigc++.h>

namespace mforms {

  // Determines which search options to show and, on return, which option was active.
  enum SearchFlags
  {
    SearchNone                 = 0,
    SearchMatchCase            = 1 << 0,
    SearchMatchWholeWord       = 1 << 1,
    SearchUseRegularExpression = 1 << 2,

    SearchDoReplace            = 1 << 3,
    SearchAll                  = 1 << 4, // If set the target should replace all occurences (makes no sense for search alone).
    SearchPrevious             = 1 << 5, // If set the target should search backwards instead forwards.
  };

  typedef sigc::slot<bool, const std::string, const std::string, SearchFlags> SearchCallback;

  class MFORMS_EXPORT SearchReplace : public Form
  {
  public:
    SearchReplace();
    
    void show(bool modal, SearchFlags flags, bool replace);
    void set_callback(SearchCallback new_callback);
  protected:
    void layout();
    void cancel_pressed();
    void button_pressed(Button* button);
  private:
    Box _top_box;
    Table _table;
    Label _find_label;
    Label _replace_label;
    Selector _find_selector;
    Selector _replace_selector;

    CheckBox _ignore_case_checkbox;
    CheckBox _match_whole_word_checkbox;
    CheckBox _use_regex_checkbox;

    Box _button_box;
    Button _replace_all_button;
    Button _replace_button;
    Button _find_previous_button;
    Button _find_next_button;

    Button _cancel_button;

    SearchCallback _on_action;
  };
}  

#endif // _SEARCH_REPLACE_H_
