/* 
 * © 2008-2009 Sun Microsystems, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#include "stdafx.h"

#include <mforms/form.h>
#include <mforms/mforms.h>

using namespace mforms;

Form::Form(Form *owner, FormFlag flag)
{
  _form_impl= &ControlFactory::get_instance()->_form_impl;
  
  _content= 0;
  _fixed_size= false;
  _release_on_close = false;
  _form_impl->create(this, owner, flag);
}

Form::~Form()
{
  if (_content)
    _content->release();
}

void Form::set_title(const std::string &title)
{
  _form_impl->set_title(this, title);
}

void Form::set_release_on_close(bool flag)
{
  _release_on_close = flag;
}

bool Form::run_modal(Button *accept, Button *cancel)
{
  return _form_impl->run_modal(this, accept, cancel);
}

void Form::show_modal(Button *accept, Button *cancel)
{
  _form_impl->show_modal(this, accept, cancel);
}

void Form::close()
{
  _form_impl->close(this);
}


void Form::center()
{
  _form_impl->center(this);
}


void Form::set_content(View *view)
{
  if (_content != view)
  {
    if (_content) _content->release();
    _content= view;
    _content->retain();
    _form_impl->set_content(this, view);
    _content->set_parent(this);
  }
}

void Form::needs_resize()
{
  relayout();
}

void Form::flush_events()
{
  _form_impl->flush_events(this);
}

